#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <unistd.h>
#include <spawn.h>
#include <sys/wait.h>

extern char **environ;

int main(int argc, char* argv[])
{
    pid_t pid;
    char *child_argv[] = {"echo", "hi", NULL};
    int status;
    status = posix_spawn(&pid, "/bin/echo", NULL, NULL, child_argv, environ);
    if (status == 0) {
        fprintf(stderr, "Child pid: %i\n", pid);
        do {
          if (waitpid(pid, &status, 0) != -1) {
            fprintf(stderr, "Child status %d\n", WEXITSTATUS(status));
          } else {
            perror("waitpid");
            exit(1);
          }
        } while (!WIFEXITED(status) && !WIFSIGNALED(status));
    } else {
        printf("posix_spawn: %s\n", strerror(status));
    }
    return 0;
}