+++
title = "Core and shell"
weight = 10
+++

## Core-and-shell particle

To construct a particle made of a core and a shell, use
```python
composite_particle = ba.CoreAndShell(core, shell)
```
where `core` and `shell` typically are simple particles generated by the
[Particle](../) constructor.

Adjusting the internal positions of the core and shell can be node with a prior call
```python
core.translate(core_position)
shell.translate(shell_position)
```

The `composite_particle` can also be translated as a whole.

Note that core must be fully contained in shell.
The scattering is computed as the coherent sum of the scattering from
shell and core where the scattering power of the latter has been modified
by subtracting the scattering power of the shell material.

##### History

Prior to BornAgain1.19.80, the constructor `ParticleCoreShell` had the
opposite argument order, namely `(shell, core)`.

##### Example

See [Core-and-shell example](../ex/core-shell-particle).
Validated through an alternative implementation that uses particle composition,
{{% ref-ex "scatter2d/CoreShellNanoparticles2.py" %}}.
