
//static
template <std::unsigned_integral Type>
std::string String::to_string(Type value, unsigned base)
{
    std::string ret;
    if (not (2 <= base and base <= 36))         // 2 <= base <= 36
        return ret;

    if (value == 0)
        return ret = "0";

    std::string reversed;
    char const a10 = 'a' - 10;
    while (value != 0)
    {
        unsigned modVal = value % base;
        reversed.push_back( (modVal < 10 ? '0' : a10) + modVal);
        value /= base;
    }

    for (
        auto begin = reversed.rbegin(), end = reversed.rend(); 
            begin != end;
                ++begin
    )
        ret.push_back(*begin);

    return ret;
}
