#define XERR "memorybuf"
#include "memorybuf.ih"

    // called by overflow/underflow: resetting the other buffer when called 
    // after, resp. reading/writing

streamsize MemoryBuf::getOffset()
{
    streamsize offset;

    switch (d_last)
    {
        default:                        // to catch the uninitialize warning
            offset = d_bridge.offset(); // no buffers currently in use
        break;

        case READ:                  // use the lastused read offset
            offset = d_bridge.blockBegin() + (gptr() - eback());
            setg(0, 0, 0);
        break;

        case WRITE:                 // use the lastused write offset
            offset = d_bridge.blockBegin() + (pptr() - pbase());
            setp(0, 0);
        break;
    }

    d_bridge.offset(offset);
    d_bridge.bufLimits();           // set the buffer limits around offset

    return offset;
}

//xerr("IN: d_last: " << d_last << ", offset = " << offset);




