#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius expansions (units packs):
# - Reinforcement
# - Fortification
# - Specialist
# - Escalation
# - Firepower
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250603.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius'

EXPANSION_ID_REINFORCEMENT='reinforcement-pack'
EXPANSION_NAME_REINFORCEMENT='Reinforcement Pack'

EXPANSION_ID_FORTIFICATION='fortification-pack'
EXPANSION_NAME_FORTIFICATION='Fortification Pack'

EXPANSION_ID_ASSAULT='assault-pack'
EXPANSION_NAME_ASSAULT='Assault Pack'

EXPANSION_ID_SPECIALIST='specialist-pack'
EXPANSION_NAME_SPECIALIST='Specialist Pack'

EXPANSION_ID_ESCALATION='escalation-pack'
EXPANSION_NAME_ESCALATION='Escalation Pack'

EXPANSION_ID_FIREPOWER='firepower-pack'
EXPANSION_NAME_FIREPOWER='Firepower Pack'

# Archives

## Reinforcement

ARCHIVE_BASE_REINFORCEMENT_23_NAME='warhammer_40_000_gladius_reinforcement_pack_1_16_00_82313.sh'
ARCHIVE_BASE_REINFORCEMENT_23_MD5='f639dc832183bc75fd079317d0609b8a'
ARCHIVE_BASE_REINFORCEMENT_23_SIZE='1086'
ARCHIVE_BASE_REINFORCEMENT_23_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_REINFORCEMENT_23_URL='https://www.gog.com/game/warhammer_40000_gladius_reinforcement_pack'

ARCHIVE_BASE_REINFORCEMENT_22_NAME='warhammer_40_000_gladius_reinforcement_pack_1_15_01_78637.sh'
ARCHIVE_BASE_REINFORCEMENT_22_MD5='ffa627db6c6910e464a748b182d86758'
ARCHIVE_BASE_REINFORCEMENT_22_SIZE='1086'
ARCHIVE_BASE_REINFORCEMENT_22_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_REINFORCEMENT_21_NAME='warhammer_40_000_gladius_reinforcement_pack_1_14_03_77940.sh'
ARCHIVE_BASE_REINFORCEMENT_21_MD5='901cae49f0ac57a2c39666e40f269c49'
ARCHIVE_BASE_REINFORCEMENT_21_SIZE='1086'
ARCHIVE_BASE_REINFORCEMENT_21_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_REINFORCEMENT_18_NAME='warhammer_40_000_gladius_reinforcement_pack_1_13_03_72014.sh'
ARCHIVE_BASE_REINFORCEMENT_18_MD5='f7d2e11be209a004bc4d1f666ab18875'
ARCHIVE_BASE_REINFORCEMENT_18_SIZE='1086'
ARCHIVE_BASE_REINFORCEMENT_18_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_REINFORCEMENT_15_NAME='warhammer_40_000_gladius_reinforcement_pack_1_12_03_67548.sh'
ARCHIVE_BASE_REINFORCEMENT_15_MD5='290f8f6e2a054d2fcc543318b3636063'
ARCHIVE_BASE_REINFORCEMENT_15_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_15_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_REINFORCEMENT_12_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_04_64361.sh'
ARCHIVE_BASE_REINFORCEMENT_12_MD5='145f5a09d46543718f8bcc8b643f6807'
ARCHIVE_BASE_REINFORCEMENT_12_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_REINFORCEMENT_7_NAME='warhammer_40_000_gladius_reinforcement_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_REINFORCEMENT_7_MD5='59ac7359ac72a1f40f5ba237fcee8698'
ARCHIVE_BASE_REINFORCEMENT_7_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_7_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_REINFORCEMENT_5_NAME='warhammer_40_000_gladius_reinforcement_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_REINFORCEMENT_5_MD5='20cce6c9a3a012a4b2d3fda7101606f4'
ARCHIVE_BASE_REINFORCEMENT_5_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_5_VERSION='1.9.3-gog54377'

ARCHIVE_BASE_REINFORCEMENT_3_NAME='warhammer_40_000_gladius_reinforcement_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_REINFORCEMENT_3_MD5='72e9d71403328df72d4505096c98c423'
ARCHIVE_BASE_REINFORCEMENT_3_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_REINFORCEMENT_0_NAME='warhammer_40_000_gladius_reinforcement_pack_1_07_04_44200.sh'
ARCHIVE_BASE_REINFORCEMENT_0_MD5='013e6db4458c5fe0c39b3a33bdda68e5'
ARCHIVE_BASE_REINFORCEMENT_0_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_0_VERSION='1.7.4-gog44200'

## Fortification

ARCHIVE_BASE_FORTIFICATION_22_NAME='warhammer_40_000_gladius_fortification_pack_1_16_00_82313.sh'
ARCHIVE_BASE_FORTIFICATION_22_MD5='8d7580150a95357439345a7c8c6db2d3'
ARCHIVE_BASE_FORTIFICATION_22_SIZE='1086'
ARCHIVE_BASE_FORTIFICATION_22_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_FORTIFICATION_22_URL='https://www.gog.com/game/warhammer_40000_gladius_fortification_pack'

ARCHIVE_BASE_FORTIFICATION_21_NAME='warhammer_40_000_gladius_fortification_pack_1_15_01_78637.sh'
ARCHIVE_BASE_FORTIFICATION_21_MD5='081e8d397681b99fad38414f005a846b'
ARCHIVE_BASE_FORTIFICATION_21_SIZE='1086'
ARCHIVE_BASE_FORTIFICATION_21_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_FORTIFICATION_20_NAME='warhammer_40_000_gladius_fortification_pack_1_14_03_77940.sh'
ARCHIVE_BASE_FORTIFICATION_20_MD5='4c540595d9e2d42c330488cb091ba1fa'
ARCHIVE_BASE_FORTIFICATION_20_SIZE='1086'
ARCHIVE_BASE_FORTIFICATION_20_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_FORTIFICATION_17_NAME='warhammer_40_000_gladius_fortification_pack_1_13_03_72014.sh'
ARCHIVE_BASE_FORTIFICATION_17_MD5='8c9b997c2dfb6e141db5e02f7b519c93'
ARCHIVE_BASE_FORTIFICATION_17_SIZE='1086'
ARCHIVE_BASE_FORTIFICATION_17_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_FORTIFICATION_14_NAME='warhammer_40_000_gladius_fortification_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FORTIFICATION_14_MD5='32c26b39aaa8329f20bddccc4059a257'
ARCHIVE_BASE_FORTIFICATION_14_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_14_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_FORTIFICATION_11_NAME='warhammer_40_000_gladius_fortification_pack_1_11_04_64361.sh'
ARCHIVE_BASE_FORTIFICATION_11_MD5='90d66263e66f30aa7c6df35ec2b0d276'
ARCHIVE_BASE_FORTIFICATION_11_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_FORTIFICATION_6_NAME='warhammer_40_000_gladius_fortification_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_FORTIFICATION_6_MD5='859c6d14d76a4b1a43880ea89e01ed27'
ARCHIVE_BASE_FORTIFICATION_6_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_6_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_FORTIFICATION_4_NAME='warhammer_40_000_gladius_fortification_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_FORTIFICATION_4_MD5='4221b279557e7af587ec6207f8654071'
ARCHIVE_BASE_FORTIFICATION_4_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_4_VERSION='1.9.3-gog54377'

ARCHIVE_BASE_FORTIFICATION_2_NAME='warhammer_40_000_gladius_fortification_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_FORTIFICATION_2_MD5='d485b048b4c1d391c7671ecc4c88e66d'
ARCHIVE_BASE_FORTIFICATION_2_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_2_VERSION='1.8.4.1-gog49548'

## Assault

ARCHIVE_BASE_ASSAULT_19_NAME='warhammer_40_000_gladius_assault_pack_1_16_00_82313.sh'
ARCHIVE_BASE_ASSAULT_19_MD5='2a103597b520cc937f59ca36bc15edfd'
ARCHIVE_BASE_ASSAULT_19_SIZE='1086'
ARCHIVE_BASE_ASSAULT_19_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_ASSAULT_19_URL='https://www.gog.com/game/warhammer_40000_gladius_assault_pack'

ARCHIVE_BASE_ASSAULT_18_NAME='warhammer_40_000_gladius_assault_pack_1_15_01_78637.sh'
ARCHIVE_BASE_ASSAULT_18_MD5='31305aacc9903eddd50abe2233d71eda'
ARCHIVE_BASE_ASSAULT_18_SIZE='1086'
ARCHIVE_BASE_ASSAULT_18_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_ASSAULT_17_NAME='warhammer_40_000_gladius_assault_pack_1_14_03_77940.sh'
ARCHIVE_BASE_ASSAULT_17_MD5='760deb0defe921b8875c99274be00bec'
ARCHIVE_BASE_ASSAULT_17_SIZE='1086'
ARCHIVE_BASE_ASSAULT_17_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_ASSAULT_14_NAME='warhammer_40_000_gladius_assault_pack_1_13_03_72014.sh'
ARCHIVE_BASE_ASSAULT_14_MD5='f0c6a21687fbcad8442f5bb1c835b1aa'
ARCHIVE_BASE_ASSAULT_14_SIZE='1086'
ARCHIVE_BASE_ASSAULT_14_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_ASSAULT_11_NAME='warhammer_40_000_gladius_assault_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ASSAULT_11_MD5='9e56693f4d1623a9c7dcc9c2cf63a59a'
ARCHIVE_BASE_ASSAULT_11_SIZE='1400'
ARCHIVE_BASE_ASSAULT_11_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_ASSAULT_8_NAME='warhammer_40_000_gladius_assault_pack_1_11_04_64361.sh'
ARCHIVE_BASE_ASSAULT_8_MD5='aae3f873d640d36f3821921efb7525c2'
ARCHIVE_BASE_ASSAULT_8_SIZE='1400'
ARCHIVE_BASE_ASSAULT_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_ASSAULT_3_NAME='warhammer_40_000_gladius_assault_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_ASSAULT_3_MD5='69d3d257e8caa70c7af8bd50b6963e0a'
ARCHIVE_BASE_ASSAULT_3_SIZE='1400'
ARCHIVE_BASE_ASSAULT_3_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_ASSAULT_1_NAME='warhammer_40_000_gladius_assault_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_ASSAULT_1_MD5='8812a45df8fa62523f655ecc2a1dbd46'
ARCHIVE_BASE_ASSAULT_1_SIZE='1400'
ARCHIVE_BASE_ASSAULT_1_VERSION='1.9.3-gog54377'

## Specialist

ARCHIVE_BASE_SPECIALIST_17_NAME='warhammer_40_000_gladius_specialist_pack_1_16_00_82313.sh'
ARCHIVE_BASE_SPECIALIST_17_MD5='0d1846d59bf1e5fa5c630cb3901942d0'
ARCHIVE_BASE_SPECIALIST_17_SIZE='1086'
ARCHIVE_BASE_SPECIALIST_17_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_SPECIALIST_17_URL='https://www.gog.com/game/warhammer_40000_gladius_specialist_pack'

ARCHIVE_BASE_SPECIALIST_16_NAME='warhammer_40_000_gladius_specialist_pack_1_15_01_78637.sh'
ARCHIVE_BASE_SPECIALIST_16_MD5='91546b521b9e1554b97a43e0f542fd05'
ARCHIVE_BASE_SPECIALIST_16_SIZE='1086'
ARCHIVE_BASE_SPECIALIST_16_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_SPECIALIST_15_NAME='warhammer_40_000_gladius_specialist_pack_1_14_03_77940.sh'
ARCHIVE_BASE_SPECIALIST_15_MD5='265a6aa1071eff6f5f7855f63278e61c'
ARCHIVE_BASE_SPECIALIST_15_SIZE='1086'
ARCHIVE_BASE_SPECIALIST_15_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_SPECIALIST_12_NAME='warhammer_40_000_gladius_specialist_pack_1_13_03_72014.sh'
ARCHIVE_BASE_SPECIALIST_12_MD5='065713713aaa72418d048a20dcd9203e'
ARCHIVE_BASE_SPECIALIST_12_SIZE='1086'
ARCHIVE_BASE_SPECIALIST_12_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_SPECIALIST_9_NAME='warhammer_40_000_gladius_specialist_pack_1_12_03_67548.sh'
ARCHIVE_BASE_SPECIALIST_9_MD5='f8e1aaacc5a30496abae99c8a6965799'
ARCHIVE_BASE_SPECIALIST_9_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_9_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_SPECIALIST_6_NAME='warhammer_40_000_gladius_specialist_pack_1_11_04_64361.sh'
ARCHIVE_BASE_SPECIALIST_6_MD5='5f44ab4c03bf70047e6716000a29f910'
ARCHIVE_BASE_SPECIALIST_6_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_SPECIALIST_1_NAME='warhammer_40_000_gladius_specialist_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_SPECIALIST_1_MD5='b0b788d180a82919048621796f68fb1e'
ARCHIVE_BASE_SPECIALIST_1_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_1_VERSION='1.10.1-gog57375'

## Escalation

ARCHIVE_BASE_ESCALATION_10_NAME='warhammer_40_000_gladius_escalation_pack_1_16_00_82313.sh'
ARCHIVE_BASE_ESCALATION_10_MD5='99496fe1509b4a2e1114f5fd66ac062a'
ARCHIVE_BASE_ESCALATION_10_SIZE='1086'
ARCHIVE_BASE_ESCALATION_10_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_ESCALATION_10_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_ESCALATION_9_NAME='warhammer_40_000_gladius_escalation_pack_1_15_01_78637.sh'
ARCHIVE_BASE_ESCALATION_9_MD5='548fae3d18f2bc3a066c41efc8549200'
ARCHIVE_BASE_ESCALATION_9_SIZE='1086'
ARCHIVE_BASE_ESCALATION_9_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_ESCALATION_8_NAME='warhammer_40_000_gladius_escalation_pack_1_14_03_77940.sh'
ARCHIVE_BASE_ESCALATION_8_MD5='847f3fbd0e977f2a944531cabd3efd30'
ARCHIVE_BASE_ESCALATION_8_SIZE='1086'
ARCHIVE_BASE_ESCALATION_8_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_ESCALATION_5_NAME='warhammer_40_000_gladius_escalation_pack_1_13_03_72014.sh'
ARCHIVE_BASE_ESCALATION_5_MD5='5dba4c9a1719723682a2857b44dce0c5'
ARCHIVE_BASE_ESCALATION_5_SIZE='1086'
ARCHIVE_BASE_ESCALATION_5_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_ESCALATION_2_NAME='warhammer_40_000_gladius_escalation_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ESCALATION_2_MD5='ce318c4cc0ee526f1abcd18ddbd4937c'
ARCHIVE_BASE_ESCALATION_2_SIZE='1400'
ARCHIVE_BASE_ESCALATION_2_VERSION='1.12.3-gog67548'

## Firepower

ARCHIVE_BASE_FIREPOWER_9_NAME='warhammer_40_000_gladius_firepower_pack_1_16_00_82313.sh'
ARCHIVE_BASE_FIREPOWER_9_MD5='23b91bf23b00ac2a72d7d3c218f04711'
ARCHIVE_BASE_FIREPOWER_9_SIZE='1086'
ARCHIVE_BASE_FIREPOWER_9_VERSION='1.16.0-gog82313'
ARCHIVE_BASE_FIREPOWER_9_URL='https://www.gog.com/game/warhammer_40000_gladius_firepower_pack'

ARCHIVE_BASE_FIREPOWER_8_NAME='warhammer_40_000_gladius_firepower_pack_1_15_01_78637.sh'
ARCHIVE_BASE_FIREPOWER_8_MD5='fbe795330138176fbce3fb80f7801617'
ARCHIVE_BASE_FIREPOWER_8_SIZE='1086'
ARCHIVE_BASE_FIREPOWER_8_VERSION='1.15.1-gog78637'

ARCHIVE_BASE_FIREPOWER_7_NAME='warhammer_40_000_gladius_firepower_pack_1_14_03_77940.sh'
ARCHIVE_BASE_FIREPOWER_7_MD5='1a81b99275d126cbbfcf1ee3c751cac7'
ARCHIVE_BASE_FIREPOWER_7_SIZE='1086'
ARCHIVE_BASE_FIREPOWER_7_VERSION='1.14.3-gog77940'

ARCHIVE_BASE_FIREPOWER_4_NAME='warhammer_40_000_gladius_firepower_pack_1_13_03_72014.sh'
ARCHIVE_BASE_FIREPOWER_4_MD5='813f40d7fbce991eae9db43aad552a4e'
ARCHIVE_BASE_FIREPOWER_4_SIZE='1086'
ARCHIVE_BASE_FIREPOWER_4_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_FIREPOWER_1_NAME='warhammer_40_000_gladius_firepower_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FIREPOWER_1_MD5='4f5adaaf42d40278df28bae531313c1d'
ARCHIVE_BASE_FIREPOWER_1_SIZE='1400'
ARCHIVE_BASE_FIREPOWER_1_VERSION='1.12.3-gog67548'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data/*.dlc'

PKG_PARENT_ID="$GAME_ID"
PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
