// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.12.2
// source: google/container/v1beta1/cluster_service.proto

package container

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The datapath provider selects the implementation of the Kubernetes networking
// // model for service resolution and network policy enforcement.
type DatapathProvider int32

const (
	// Default value.
	DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED DatapathProvider = 0
	// Use the IPTables implementation based on kube-proxy.
	DatapathProvider_LEGACY_DATAPATH DatapathProvider = 1
	// Use the eBPF based GKE Dataplane V2 with additional features. See the [GKE
	// Dataplane V2
	// documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/dataplane-v2)
	// for more.
	DatapathProvider_ADVANCED_DATAPATH DatapathProvider = 2
)

// Enum value maps for DatapathProvider.
var (
	DatapathProvider_name = map[int32]string{
		0: "DATAPATH_PROVIDER_UNSPECIFIED",
		1: "LEGACY_DATAPATH",
		2: "ADVANCED_DATAPATH",
	}
	DatapathProvider_value = map[string]int32{
		"DATAPATH_PROVIDER_UNSPECIFIED": 0,
		"LEGACY_DATAPATH":               1,
		"ADVANCED_DATAPATH":             2,
	}
)

func (x DatapathProvider) Enum() *DatapathProvider {
	p := new(DatapathProvider)
	*p = x
	return p
}

func (x DatapathProvider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatapathProvider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[0].Descriptor()
}

func (DatapathProvider) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[0]
}

func (x DatapathProvider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatapathProvider.Descriptor instead.
func (DatapathProvider) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{0}
}

// UpgradeResourceType is the resource type that is upgrading. It is used
// in upgrade notifications.
type UpgradeResourceType int32

const (
	// Default value. This shouldn't be used.
	UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED UpgradeResourceType = 0
	// Master / control plane
	UpgradeResourceType_MASTER UpgradeResourceType = 1
	// Node pool
	UpgradeResourceType_NODE_POOL UpgradeResourceType = 2
)

// Enum value maps for UpgradeResourceType.
var (
	UpgradeResourceType_name = map[int32]string{
		0: "UPGRADE_RESOURCE_TYPE_UNSPECIFIED",
		1: "MASTER",
		2: "NODE_POOL",
	}
	UpgradeResourceType_value = map[string]int32{
		"UPGRADE_RESOURCE_TYPE_UNSPECIFIED": 0,
		"MASTER":                            1,
		"NODE_POOL":                         2,
	}
)

func (x UpgradeResourceType) Enum() *UpgradeResourceType {
	p := new(UpgradeResourceType)
	*p = x
	return p
}

func (x UpgradeResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[1].Descriptor()
}

func (UpgradeResourceType) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[1]
}

func (x UpgradeResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeResourceType.Descriptor instead.
func (UpgradeResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{1}
}

// Possible types of sandboxes.
type SandboxConfig_Type int32

const (
	// Default value. This should not be used.
	SandboxConfig_UNSPECIFIED SandboxConfig_Type = 0
	// Run sandbox using gvisor.
	SandboxConfig_GVISOR SandboxConfig_Type = 1
)

// Enum value maps for SandboxConfig_Type.
var (
	SandboxConfig_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "GVISOR",
	}
	SandboxConfig_Type_value = map[string]int32{
		"UNSPECIFIED": 0,
		"GVISOR":      1,
	}
)

func (x SandboxConfig_Type) Enum() *SandboxConfig_Type {
	p := new(SandboxConfig_Type)
	*p = x
	return p
}

func (x SandboxConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SandboxConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[2].Descriptor()
}

func (SandboxConfig_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[2]
}

func (x SandboxConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SandboxConfig_Type.Descriptor instead.
func (SandboxConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{4, 0}
}

// Indicates whether to consume capacity from a reservation or not.
type ReservationAffinity_Type int32

const (
	// Default value. This should not be used.
	ReservationAffinity_UNSPECIFIED ReservationAffinity_Type = 0
	// Do not consume from any reserved capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_Type = 1
	// Consume any reservation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_Type = 2
	// Must consume from a specific reservation. Must specify key value fields
	// for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_Type = 3
)

// Enum value maps for ReservationAffinity_Type.
var (
	ReservationAffinity_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "NO_RESERVATION",
		2: "ANY_RESERVATION",
		3: "SPECIFIC_RESERVATION",
	}
	ReservationAffinity_Type_value = map[string]int32{
		"UNSPECIFIED":          0,
		"NO_RESERVATION":       1,
		"ANY_RESERVATION":      2,
		"SPECIFIC_RESERVATION": 3,
	}
)

func (x ReservationAffinity_Type) Enum() *ReservationAffinity_Type {
	p := new(ReservationAffinity_Type)
	*p = x
	return p
}

func (x ReservationAffinity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[3].Descriptor()
}

func (ReservationAffinity_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[3]
}

func (x ReservationAffinity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_Type.Descriptor instead.
func (ReservationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{6, 0}
}

// Possible values for Effect in taint.
type NodeTaint_Effect int32

const (
	// Not set
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// NoSchedule
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// PreferNoSchedule
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// NoExecute
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

// Enum value maps for NodeTaint_Effect.
var (
	NodeTaint_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "NO_SCHEDULE",
		2: "PREFER_NO_SCHEDULE",
		3: "NO_EXECUTE",
	}
	NodeTaint_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED": 0,
		"NO_SCHEDULE":        1,
		"PREFER_NO_SCHEDULE": 2,
		"NO_EXECUTE":         3,
	}
)

func (x NodeTaint_Effect) Enum() *NodeTaint_Effect {
	p := new(NodeTaint_Effect)
	*p = x
	return p
}

func (x NodeTaint_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTaint_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[4].Descriptor()
}

func (NodeTaint_Effect) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[4]
}

func (x NodeTaint_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTaint_Effect.Descriptor instead.
func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{7, 0}
}

// Istio auth mode, https://istio.io/docs/concepts/security/mutual-tls.html
type IstioConfig_IstioAuthMode int32

const (
	// auth not enabled
	IstioConfig_AUTH_NONE IstioConfig_IstioAuthMode = 0
	// auth mutual TLS enabled
	IstioConfig_AUTH_MUTUAL_TLS IstioConfig_IstioAuthMode = 1
)

// Enum value maps for IstioConfig_IstioAuthMode.
var (
	IstioConfig_IstioAuthMode_name = map[int32]string{
		0: "AUTH_NONE",
		1: "AUTH_MUTUAL_TLS",
	}
	IstioConfig_IstioAuthMode_value = map[string]int32{
		"AUTH_NONE":       0,
		"AUTH_MUTUAL_TLS": 1,
	}
)

func (x IstioConfig_IstioAuthMode) Enum() *IstioConfig_IstioAuthMode {
	p := new(IstioConfig_IstioAuthMode)
	*p = x
	return p
}

func (x IstioConfig_IstioAuthMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IstioConfig_IstioAuthMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[5].Descriptor()
}

func (IstioConfig_IstioAuthMode) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[5]
}

func (x IstioConfig_IstioAuthMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IstioConfig_IstioAuthMode.Descriptor instead.
func (IstioConfig_IstioAuthMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{21, 0}
}

// Load balancer type of ingress service of Cloud Run.
type CloudRunConfig_LoadBalancerType int32

const (
	// Load balancer type for Cloud Run is unspecified.
	CloudRunConfig_LOAD_BALANCER_TYPE_UNSPECIFIED CloudRunConfig_LoadBalancerType = 0
	// Install external load balancer for Cloud Run.
	CloudRunConfig_LOAD_BALANCER_TYPE_EXTERNAL CloudRunConfig_LoadBalancerType = 1
	// Install internal load balancer for Cloud Run.
	CloudRunConfig_LOAD_BALANCER_TYPE_INTERNAL CloudRunConfig_LoadBalancerType = 2
)

// Enum value maps for CloudRunConfig_LoadBalancerType.
var (
	CloudRunConfig_LoadBalancerType_name = map[int32]string{
		0: "LOAD_BALANCER_TYPE_UNSPECIFIED",
		1: "LOAD_BALANCER_TYPE_EXTERNAL",
		2: "LOAD_BALANCER_TYPE_INTERNAL",
	}
	CloudRunConfig_LoadBalancerType_value = map[string]int32{
		"LOAD_BALANCER_TYPE_UNSPECIFIED": 0,
		"LOAD_BALANCER_TYPE_EXTERNAL":    1,
		"LOAD_BALANCER_TYPE_INTERNAL":    2,
	}
)

func (x CloudRunConfig_LoadBalancerType) Enum() *CloudRunConfig_LoadBalancerType {
	p := new(CloudRunConfig_LoadBalancerType)
	*p = x
	return p
}

func (x CloudRunConfig_LoadBalancerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudRunConfig_LoadBalancerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[6].Descriptor()
}

func (CloudRunConfig_LoadBalancerType) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[6]
}

func (x CloudRunConfig_LoadBalancerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudRunConfig_LoadBalancerType.Descriptor instead.
func (CloudRunConfig_LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{22, 0}
}

// Allowed Network Policy providers.
type NetworkPolicy_Provider int32

const (
	// Not set
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	// Tigera (Calico Felix).
	NetworkPolicy_CALICO NetworkPolicy_Provider = 1
)

// Enum value maps for NetworkPolicy_Provider.
var (
	NetworkPolicy_Provider_name = map[int32]string{
		0: "PROVIDER_UNSPECIFIED",
		1: "CALICO",
	}
	NetworkPolicy_Provider_value = map[string]int32{
		"PROVIDER_UNSPECIFIED": 0,
		"CALICO":               1,
	}
)

func (x NetworkPolicy_Provider) Enum() *NetworkPolicy_Provider {
	p := new(NetworkPolicy_Provider)
	*p = x
	return p
}

func (x NetworkPolicy_Provider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicy_Provider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[7].Descriptor()
}

func (NetworkPolicy_Provider) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[7]
}

func (x NetworkPolicy_Provider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicy_Provider.Descriptor instead.
func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{25, 0}
}

// Type of the integration.
type ClusterTelemetry_Type int32

const (
	// Not set.
	ClusterTelemetry_UNSPECIFIED ClusterTelemetry_Type = 0
	// Monitoring integration is disabled.
	ClusterTelemetry_DISABLED ClusterTelemetry_Type = 1
	// Monitoring integration is enabled.
	ClusterTelemetry_ENABLED ClusterTelemetry_Type = 2
	// Only system components are monitored and logged.
	ClusterTelemetry_SYSTEM_ONLY ClusterTelemetry_Type = 3
)

// Enum value maps for ClusterTelemetry_Type.
var (
	ClusterTelemetry_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
		3: "SYSTEM_ONLY",
	}
	ClusterTelemetry_Type_value = map[string]int32{
		"UNSPECIFIED": 0,
		"DISABLED":    1,
		"ENABLED":     2,
		"SYSTEM_ONLY": 3,
	}
)

func (x ClusterTelemetry_Type) Enum() *ClusterTelemetry_Type {
	p := new(ClusterTelemetry_Type)
	*p = x
	return p
}

func (x ClusterTelemetry_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterTelemetry_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[8].Descriptor()
}

func (ClusterTelemetry_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[8]
}

func (x ClusterTelemetry_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterTelemetry_Type.Descriptor instead.
func (ClusterTelemetry_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{30, 0}
}

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
	// The DEGRADED state indicates the cluster requires user action to restore
	// full functionality. Details can be found in the `statusMessage` field.
	Cluster_DEGRADED Cluster_Status = 6
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"RECONCILING":        3,
		"STOPPING":           4,
		"ERROR":              5,
		"DEGRADED":           6,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[9].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[9]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{31, 0}
}

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

// Enum value maps for Operation_Status.
var (
	Operation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
		4: "ABORTING",
	}
	Operation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PENDING":            1,
		"RUNNING":            2,
		"DONE":               3,
		"ABORTING":           4,
	}
)

func (x Operation_Status) Enum() *Operation_Status {
	p := new(Operation_Status)
	*p = x
	return p
}

func (x Operation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[10].Descriptor()
}

func (Operation_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[10]
}

func (x Operation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Status.Descriptor instead.
func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{33, 0}
}

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// Set node pool management.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// Automatic node pool repair.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Automatic node upgrade.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Set labels.
	Operation_SET_LABELS Operation_Type = 12
	// Set/generate master auth materials
	Operation_SET_MASTER_AUTH Operation_Type = 13
	// Set node pool size.
	Operation_SET_NODE_POOL_SIZE Operation_Type = 14
	// Updates network policy for a cluster.
	Operation_SET_NETWORK_POLICY Operation_Type = 15
	// Set the maintenance policy.
	Operation_SET_MAINTENANCE_POLICY Operation_Type = 16
)

// Enum value maps for Operation_Type.
var (
	Operation_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "CREATE_CLUSTER",
		2:  "DELETE_CLUSTER",
		3:  "UPGRADE_MASTER",
		4:  "UPGRADE_NODES",
		5:  "REPAIR_CLUSTER",
		6:  "UPDATE_CLUSTER",
		7:  "CREATE_NODE_POOL",
		8:  "DELETE_NODE_POOL",
		9:  "SET_NODE_POOL_MANAGEMENT",
		10: "AUTO_REPAIR_NODES",
		11: "AUTO_UPGRADE_NODES",
		12: "SET_LABELS",
		13: "SET_MASTER_AUTH",
		14: "SET_NODE_POOL_SIZE",
		15: "SET_NETWORK_POLICY",
		16: "SET_MAINTENANCE_POLICY",
	}
	Operation_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":         0,
		"CREATE_CLUSTER":           1,
		"DELETE_CLUSTER":           2,
		"UPGRADE_MASTER":           3,
		"UPGRADE_NODES":            4,
		"REPAIR_CLUSTER":           5,
		"UPDATE_CLUSTER":           6,
		"CREATE_NODE_POOL":         7,
		"DELETE_NODE_POOL":         8,
		"SET_NODE_POOL_MANAGEMENT": 9,
		"AUTO_REPAIR_NODES":        10,
		"AUTO_UPGRADE_NODES":       11,
		"SET_LABELS":               12,
		"SET_MASTER_AUTH":          13,
		"SET_NODE_POOL_SIZE":       14,
		"SET_NETWORK_POLICY":       15,
		"SET_MAINTENANCE_POLICY":   16,
	}
)

func (x Operation_Type) Enum() *Operation_Type {
	p := new(Operation_Type)
	*p = x
	return p
}

func (x Operation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[11].Descriptor()
}

func (Operation_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[11]
}

func (x Operation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Type.Descriptor instead.
func (Operation_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{33, 1}
}

// Operation type: what type update to perform.
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out.
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
	// Set the username.  If an empty username is provided, basic authentication
	// is disabled for the cluster.  If a non-empty username is provided, basic
	// authentication is enabled, with either a provided password or a generated
	// one.
	SetMasterAuthRequest_SET_USERNAME SetMasterAuthRequest_Action = 3
)

// Enum value maps for SetMasterAuthRequest_Action.
var (
	SetMasterAuthRequest_Action_name = map[int32]string{
		0: "UNKNOWN",
		1: "SET_PASSWORD",
		2: "GENERATE_PASSWORD",
		3: "SET_USERNAME",
	}
	SetMasterAuthRequest_Action_value = map[string]int32{
		"UNKNOWN":           0,
		"SET_PASSWORD":      1,
		"GENERATE_PASSWORD": 2,
		"SET_USERNAME":      3,
	}
)

func (x SetMasterAuthRequest_Action) Enum() *SetMasterAuthRequest_Action {
	p := new(SetMasterAuthRequest_Action)
	*p = x
	return p
}

func (x SetMasterAuthRequest_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetMasterAuthRequest_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[12].Descriptor()
}

func (SetMasterAuthRequest_Action) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[12]
}

func (x SetMasterAuthRequest_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetMasterAuthRequest_Action.Descriptor instead.
func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{45, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

// Enum value maps for NodePool_Status.
var (
	NodePool_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RUNNING_WITH_ERROR",
		4: "RECONCILING",
		5: "STOPPING",
		6: "ERROR",
	}
	NodePool_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"RUNNING_WITH_ERROR": 3,
		"RECONCILING":        4,
		"STOPPING":           5,
		"ERROR":              6,
	}
)

func (x NodePool_Status) Enum() *NodePool_Status {
	p := new(NodePool_Status)
	*p = x
	return p
}

func (x NodePool_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePool_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[13].Descriptor()
}

func (NodePool_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[13]
}

func (x NodePool_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePool_Status.Descriptor instead.
func (NodePool_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{59, 0}
}

// Defines possible options for autoscaling_profile field.
type ClusterAutoscaling_AutoscalingProfile int32

const (
	// No change to autoscaling configuration.
	ClusterAutoscaling_PROFILE_UNSPECIFIED ClusterAutoscaling_AutoscalingProfile = 0
	// Prioritize optimizing utilization of resources.
	ClusterAutoscaling_OPTIMIZE_UTILIZATION ClusterAutoscaling_AutoscalingProfile = 1
	// Use default (balanced) autoscaling configuration.
	ClusterAutoscaling_BALANCED ClusterAutoscaling_AutoscalingProfile = 2
)

// Enum value maps for ClusterAutoscaling_AutoscalingProfile.
var (
	ClusterAutoscaling_AutoscalingProfile_name = map[int32]string{
		0: "PROFILE_UNSPECIFIED",
		1: "OPTIMIZE_UTILIZATION",
		2: "BALANCED",
	}
	ClusterAutoscaling_AutoscalingProfile_value = map[string]int32{
		"PROFILE_UNSPECIFIED":  0,
		"OPTIMIZE_UTILIZATION": 1,
		"BALANCED":             2,
	}
)

func (x ClusterAutoscaling_AutoscalingProfile) Enum() *ClusterAutoscaling_AutoscalingProfile {
	p := new(ClusterAutoscaling_AutoscalingProfile)
	*p = x
	return p
}

func (x ClusterAutoscaling_AutoscalingProfile) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterAutoscaling_AutoscalingProfile) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[14].Descriptor()
}

func (ClusterAutoscaling_AutoscalingProfile) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[14]
}

func (x ClusterAutoscaling_AutoscalingProfile) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterAutoscaling_AutoscalingProfile.Descriptor instead.
func (ClusterAutoscaling_AutoscalingProfile) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{71, 0}
}

// NodeMetadata is the configuration for if and how to expose the node
// metadata to the workload running on the node.
type WorkloadMetadataConfig_NodeMetadata int32

const (
	// Not set.
	WorkloadMetadataConfig_UNSPECIFIED WorkloadMetadataConfig_NodeMetadata = 0
	// Prevent workloads not in hostNetwork from accessing certain VM metadata,
	// specifically kube-env, which contains Kubelet credentials, and the
	// instance identity token.
	//
	// Metadata concealment is a temporary security solution available while the
	// bootstrapping process for cluster nodes is being redesigned with
	// significant security improvements.  This feature is scheduled to be
	// deprecated in the future and later removed.
	WorkloadMetadataConfig_SECURE WorkloadMetadataConfig_NodeMetadata = 1
	// Expose all VM metadata to pods.
	WorkloadMetadataConfig_EXPOSE WorkloadMetadataConfig_NodeMetadata = 2
	// Run the GKE Metadata Server on this node. The GKE Metadata Server exposes
	// a metadata API to workloads that is compatible with the V1 Compute
	// Metadata APIs exposed by the Compute Engine and App Engine Metadata
	// Servers. This feature can only be enabled if Workload Identity is enabled
	// at the cluster level.
	WorkloadMetadataConfig_GKE_METADATA_SERVER WorkloadMetadataConfig_NodeMetadata = 3
)

// Enum value maps for WorkloadMetadataConfig_NodeMetadata.
var (
	WorkloadMetadataConfig_NodeMetadata_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SECURE",
		2: "EXPOSE",
		3: "GKE_METADATA_SERVER",
	}
	WorkloadMetadataConfig_NodeMetadata_value = map[string]int32{
		"UNSPECIFIED":         0,
		"SECURE":              1,
		"EXPOSE":              2,
		"GKE_METADATA_SERVER": 3,
	}
)

func (x WorkloadMetadataConfig_NodeMetadata) Enum() *WorkloadMetadataConfig_NodeMetadata {
	p := new(WorkloadMetadataConfig_NodeMetadata)
	*p = x
	return p
}

func (x WorkloadMetadataConfig_NodeMetadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadMetadataConfig_NodeMetadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[15].Descriptor()
}

func (WorkloadMetadataConfig_NodeMetadata) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[15]
}

func (x WorkloadMetadataConfig_NodeMetadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadMetadataConfig_NodeMetadata.Descriptor instead.
func (WorkloadMetadataConfig_NodeMetadata) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{80, 0}
}

// Mode is the configuration for how to expose metadata to workloads running
// on the node.
type WorkloadMetadataConfig_Mode int32

const (
	// Not set.
	WorkloadMetadataConfig_MODE_UNSPECIFIED WorkloadMetadataConfig_Mode = 0
	// Expose all Compute Engine metadata to pods.
	WorkloadMetadataConfig_GCE_METADATA WorkloadMetadataConfig_Mode = 1
	// Run the GKE Metadata Server on this node. The GKE Metadata Server exposes
	// a metadata API to workloads that is compatible with the V1 Compute
	// Metadata APIs exposed by the Compute Engine and App Engine Metadata
	// Servers. This feature can only be enabled if Workload Identity is enabled
	// at the cluster level.
	WorkloadMetadataConfig_GKE_METADATA WorkloadMetadataConfig_Mode = 2
)

// Enum value maps for WorkloadMetadataConfig_Mode.
var (
	WorkloadMetadataConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "GCE_METADATA",
		2: "GKE_METADATA",
	}
	WorkloadMetadataConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"GCE_METADATA":     1,
		"GKE_METADATA":     2,
	}
)

func (x WorkloadMetadataConfig_Mode) Enum() *WorkloadMetadataConfig_Mode {
	p := new(WorkloadMetadataConfig_Mode)
	*p = x
	return p
}

func (x WorkloadMetadataConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadMetadataConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[16].Descriptor()
}

func (WorkloadMetadataConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[16]
}

func (x WorkloadMetadataConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadMetadataConfig_Mode.Descriptor instead.
func (WorkloadMetadataConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{80, 1}
}

// LocationType is the type of GKE location, regional or zonal.
type Location_LocationType int32

const (
	// LOCATION_TYPE_UNSPECIFIED means the location type was not determined.
	Location_LOCATION_TYPE_UNSPECIFIED Location_LocationType = 0
	// A GKE Location where Zonal clusters can be created.
	Location_ZONE Location_LocationType = 1
	// A GKE Location where Regional clusters can be created.
	Location_REGION Location_LocationType = 2
)

// Enum value maps for Location_LocationType.
var (
	Location_LocationType_name = map[int32]string{
		0: "LOCATION_TYPE_UNSPECIFIED",
		1: "ZONE",
		2: "REGION",
	}
	Location_LocationType_value = map[string]int32{
		"LOCATION_TYPE_UNSPECIFIED": 0,
		"ZONE":                      1,
		"REGION":                    2,
	}
)

func (x Location_LocationType) Enum() *Location_LocationType {
	p := new(Location_LocationType)
	*p = x
	return p
}

func (x Location_LocationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Location_LocationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[17].Descriptor()
}

func (Location_LocationType) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[17]
}

func (x Location_LocationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Location_LocationType.Descriptor instead.
func (Location_LocationType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{85, 0}
}

// Code for each condition
type StatusCondition_Code int32

const (
	// UNKNOWN indicates a generic condition.
	StatusCondition_UNKNOWN StatusCondition_Code = 0
	// GCE_STOCKOUT indicates that Google Compute Engine resources are
	// temporarily unavailable.
	StatusCondition_GCE_STOCKOUT StatusCondition_Code = 1
	// GKE_SERVICE_ACCOUNT_DELETED indicates that the user deleted their robot
	// service account.
	StatusCondition_GKE_SERVICE_ACCOUNT_DELETED StatusCondition_Code = 2
	// Google Compute Engine quota was exceeded.
	StatusCondition_GCE_QUOTA_EXCEEDED StatusCondition_Code = 3
	// Cluster state was manually changed by an SRE due to a system logic error.
	StatusCondition_SET_BY_OPERATOR StatusCondition_Code = 4
	// Unable to perform an encrypt operation against the CloudKMS key used for
	// etcd level encryption.
	// More codes TBA
	StatusCondition_CLOUD_KMS_KEY_ERROR StatusCondition_Code = 7
)

// Enum value maps for StatusCondition_Code.
var (
	StatusCondition_Code_name = map[int32]string{
		0: "UNKNOWN",
		1: "GCE_STOCKOUT",
		2: "GKE_SERVICE_ACCOUNT_DELETED",
		3: "GCE_QUOTA_EXCEEDED",
		4: "SET_BY_OPERATOR",
		7: "CLOUD_KMS_KEY_ERROR",
	}
	StatusCondition_Code_value = map[string]int32{
		"UNKNOWN":                     0,
		"GCE_STOCKOUT":                1,
		"GKE_SERVICE_ACCOUNT_DELETED": 2,
		"GCE_QUOTA_EXCEEDED":          3,
		"SET_BY_OPERATOR":             4,
		"CLOUD_KMS_KEY_ERROR":         7,
	}
)

func (x StatusCondition_Code) Enum() *StatusCondition_Code {
	p := new(StatusCondition_Code)
	*p = x
	return p
}

func (x StatusCondition_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatusCondition_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[18].Descriptor()
}

func (StatusCondition_Code) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[18]
}

func (x StatusCondition_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatusCondition_Code.Descriptor instead.
func (StatusCondition_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{86, 0}
}

// Status shows the current usage of a secondary IP range.
type UsableSubnetworkSecondaryRange_Status int32

const (
	// UNKNOWN is the zero value of the Status enum. It's not a valid status.
	UsableSubnetworkSecondaryRange_UNKNOWN UsableSubnetworkSecondaryRange_Status = 0
	// UNUSED denotes that this range is unclaimed by any cluster.
	UsableSubnetworkSecondaryRange_UNUSED UsableSubnetworkSecondaryRange_Status = 1
	// IN_USE_SERVICE denotes that this range is claimed by a cluster for
	// services. It cannot be used for other clusters.
	UsableSubnetworkSecondaryRange_IN_USE_SERVICE UsableSubnetworkSecondaryRange_Status = 2
	// IN_USE_SHAREABLE_POD denotes this range was created by the network admin
	// and is currently claimed by a cluster for pods. It can only be used by
	// other clusters as a pod range.
	UsableSubnetworkSecondaryRange_IN_USE_SHAREABLE_POD UsableSubnetworkSecondaryRange_Status = 3
	// IN_USE_MANAGED_POD denotes this range was created by GKE and is claimed
	// for pods. It cannot be used for other clusters.
	UsableSubnetworkSecondaryRange_IN_USE_MANAGED_POD UsableSubnetworkSecondaryRange_Status = 4
)

// Enum value maps for UsableSubnetworkSecondaryRange_Status.
var (
	UsableSubnetworkSecondaryRange_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "UNUSED",
		2: "IN_USE_SERVICE",
		3: "IN_USE_SHAREABLE_POD",
		4: "IN_USE_MANAGED_POD",
	}
	UsableSubnetworkSecondaryRange_Status_value = map[string]int32{
		"UNKNOWN":              0,
		"UNUSED":               1,
		"IN_USE_SERVICE":       2,
		"IN_USE_SHAREABLE_POD": 3,
		"IN_USE_MANAGED_POD":   4,
	}
)

func (x UsableSubnetworkSecondaryRange_Status) Enum() *UsableSubnetworkSecondaryRange_Status {
	p := new(UsableSubnetworkSecondaryRange_Status)
	*p = x
	return p
}

func (x UsableSubnetworkSecondaryRange_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetworkSecondaryRange_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[19].Descriptor()
}

func (UsableSubnetworkSecondaryRange_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[19]
}

func (x UsableSubnetworkSecondaryRange_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetworkSecondaryRange_Status.Descriptor instead.
func (UsableSubnetworkSecondaryRange_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{90, 0}
}

// State of etcd encryption.
type DatabaseEncryption_State int32

const (
	// Should never be set
	DatabaseEncryption_UNKNOWN DatabaseEncryption_State = 0
	// Secrets in etcd are encrypted.
	DatabaseEncryption_ENCRYPTED DatabaseEncryption_State = 1
	// Secrets in etcd are stored in plain text (at etcd level) - this is
	// unrelated to Compute Engine level full disk encryption.
	DatabaseEncryption_DECRYPTED DatabaseEncryption_State = 2
)

// Enum value maps for DatabaseEncryption_State.
var (
	DatabaseEncryption_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "ENCRYPTED",
		2: "DECRYPTED",
	}
	DatabaseEncryption_State_value = map[string]int32{
		"UNKNOWN":   0,
		"ENCRYPTED": 1,
		"DECRYPTED": 2,
	}
)

func (x DatabaseEncryption_State) Enum() *DatabaseEncryption_State {
	p := new(DatabaseEncryption_State)
	*p = x
	return p
}

func (x DatabaseEncryption_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEncryption_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[20].Descriptor()
}

func (DatabaseEncryption_State) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[20]
}

func (x DatabaseEncryption_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEncryption_State.Descriptor instead.
func (DatabaseEncryption_State) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{97, 0}
}

// Possible values for 'channel'.
type ReleaseChannel_Channel int32

const (
	// No channel specified.
	ReleaseChannel_UNSPECIFIED ReleaseChannel_Channel = 0
	// RAPID channel is offered on an early access basis for customers who want
	// to test new releases.
	//
	// WARNING: Versions available in the RAPID Channel may be subject to
	// unresolved issues with no known workaround and are not subject to any
	// SLAs.
	ReleaseChannel_RAPID ReleaseChannel_Channel = 1
	// Clusters subscribed to REGULAR receive versions that are considered GA
	// quality. REGULAR is intended for production users who want to take
	// advantage of new features.
	ReleaseChannel_REGULAR ReleaseChannel_Channel = 2
	// Clusters subscribed to STABLE receive versions that are known to be
	// stable and reliable in production.
	ReleaseChannel_STABLE ReleaseChannel_Channel = 3
)

// Enum value maps for ReleaseChannel_Channel.
var (
	ReleaseChannel_Channel_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "RAPID",
		2: "REGULAR",
		3: "STABLE",
	}
	ReleaseChannel_Channel_value = map[string]int32{
		"UNSPECIFIED": 0,
		"RAPID":       1,
		"REGULAR":     2,
		"STABLE":      3,
	}
)

func (x ReleaseChannel_Channel) Enum() *ReleaseChannel_Channel {
	p := new(ReleaseChannel_Channel)
	*p = x
	return p
}

func (x ReleaseChannel_Channel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReleaseChannel_Channel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1beta1_cluster_service_proto_enumTypes[21].Descriptor()
}

func (ReleaseChannel_Channel) Type() protoreflect.EnumType {
	return &file_google_container_v1beta1_cluster_service_proto_enumTypes[21]
}

func (x ReleaseChannel_Channel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReleaseChannel_Channel.Descriptor instead.
func (ReleaseChannel_Channel) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{105, 0}
}

// Parameters that can be configured on Linux nodes.
type LinuxNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Linux kernel parameters to be applied to the nodes and all pods running
	// on the nodes.
	//
	// The following parameters are supported.
	//
	// net.core.netdev_max_backlog
	// net.core.rmem_max
	// net.core.wmem_default
	// net.core.wmem_max
	// net.core.optmem_max
	// net.core.somaxconn
	// net.ipv4.tcp_rmem
	// net.ipv4.tcp_wmem
	// net.ipv4.tcp_tw_reuse
	Sysctls map[string]string `protobuf:"bytes,1,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LinuxNodeConfig) Reset() {
	*x = LinuxNodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinuxNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxNodeConfig) ProtoMessage() {}

func (x *LinuxNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxNodeConfig.ProtoReflect.Descriptor instead.
func (*LinuxNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{0}
}

func (x *LinuxNodeConfig) GetSysctls() map[string]string {
	if x != nil {
		return x.Sysctls
	}
	return nil
}

// Node kubelet configs.
type NodeKubeletConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Control the CPU management policy on the node.
	// See
	// https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
	//
	// The following values are allowed.
	//   - "none": the default, which represents the existing scheduling behavior.
	//   - "static": allows pods with certain resource characteristics to be
	//               granted increased CPU affinity and exclusivity on the node.
	//  The default value is 'none' if unspecified.
	CpuManagerPolicy string `protobuf:"bytes,1,opt,name=cpu_manager_policy,json=cpuManagerPolicy,proto3" json:"cpu_manager_policy,omitempty"`
	// Enable CPU CFS quota enforcement for containers that specify CPU limits.
	//
	// This option is enabled by default which makes kubelet use CFS quota
	// (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
	// enforce container CPU limits. Otherwise, CPU limits will not be enforced at
	// all.
	//
	// Disable this option to mitigate CPU throttling problems while still having
	// your pods to be in Guaranteed QoS class by specifying the CPU limits.
	//
	// The default value is 'true' if unspecified.
	CpuCfsQuota *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=cpu_cfs_quota,json=cpuCfsQuota,proto3" json:"cpu_cfs_quota,omitempty"`
	// Set the CPU CFS quota period value 'cpu.cfs_period_us'.
	//
	// The string must be a sequence of decimal numbers, each with optional
	// fraction and a unit suffix, such as "300ms".
	// Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
	// The value must be a positive duration.
	CpuCfsQuotaPeriod string `protobuf:"bytes,3,opt,name=cpu_cfs_quota_period,json=cpuCfsQuotaPeriod,proto3" json:"cpu_cfs_quota_period,omitempty"`
}

func (x *NodeKubeletConfig) Reset() {
	*x = NodeKubeletConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeKubeletConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeKubeletConfig) ProtoMessage() {}

func (x *NodeKubeletConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeKubeletConfig.ProtoReflect.Descriptor instead.
func (*NodeKubeletConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{1}
}

func (x *NodeKubeletConfig) GetCpuManagerPolicy() string {
	if x != nil {
		return x.CpuManagerPolicy
	}
	return ""
}

func (x *NodeKubeletConfig) GetCpuCfsQuota() *wrapperspb.BoolValue {
	if x != nil {
		return x.CpuCfsQuota
	}
	return nil
}

func (x *NodeKubeletConfig) GetCpuCfsQuotaPeriod() string {
	if x != nil {
		return x.CpuCfsQuotaPeriod
	}
	return ""
}

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a Google Compute Engine [machine
	// type](https://cloud.google.com/compute/docs/machine-types).
	//
	// If unspecified, the default machine type is
	// `e2-medium`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container
	// Registry](https://cloud.google.com/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs.
	// Specify the email address of the Service Account; otherwise, if no Service
	// Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the reserved keys:
	//  - "cluster-location"
	//  - "cluster-name"
	//  - "cluster-uid"
	//  - "configure-sh"
	//  - "containerd-configure-sh"
	//  - "enable-oslogin"
	//  - "gci-ensure-gke-docker"
	//  - "gci-metrics-enabled"
	//  - "gci-update-strategy"
	//  - "instance-template"
	//  - "kube-env"
	//  - "startup-script"
	//  - "user-data"
	//  - "disable-address-manager"
	//  - "windows-startup-script-ps1"
	//  - "common-psm1"
	//  - "k8s-node-setup-psm1"
	//  - "install-ssh-psm1"
	//  - "user-profile-psm1"
	//
	// The following keys are reserved for Windows nodes:
	//  - "serial-port-logging-enable"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependent upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// inforamtion about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Sandbox configuration for this node.
	SandboxConfig *SandboxConfig `protobuf:"bytes,17,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	// Setting this field will assign instances of this
	// pool to run on the specified node group. This is useful for running
	// workloads on [sole tenant
	// nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
	NodeGroup string `protobuf:"bytes,18,opt,name=node_group,json=nodeGroup,proto3" json:"node_group,omitempty"`
	// The optional reservation affinity. Setting this field will apply
	// the specified [Zonal Compute
	// Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
	// to this node pool.
	ReservationAffinity *ReservationAffinity `protobuf:"bytes,19,opt,name=reservation_affinity,json=reservationAffinity,proto3" json:"reservation_affinity,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
	// 'pd-balanced')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,12,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// `minCpuPlatform: "Intel Haswell"` or
	// `minCpuPlatform: "Intel Sandy Bridge"`. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	MinCpuPlatform string `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// The workload metadata configuration for this node.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// List of kubernetes taints to be applied to each node.
	//
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Taints []*NodeTaint `protobuf:"bytes,15,rep,name=taints,proto3" json:"taints,omitempty"`
	//
	// The Customer Managed Encryption Key used to encrypt the boot disk attached
	// to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
	// For more information about protecting resources with Cloud KMS Keys please
	// see:
	// https://cloud.google.com/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `protobuf:"bytes,23,opt,name=boot_disk_kms_key,json=bootDiskKmsKey,proto3" json:"boot_disk_kms_key,omitempty"`
	// Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,20,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,21,opt,name=linux_node_config,json=linuxNodeConfig,proto3" json:"linux_node_config,omitempty"`
	// Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `protobuf:"bytes,22,opt,name=kubelet_config,json=kubeletConfig,proto3" json:"kubelet_config,omitempty"`
	// Parameters for the ephemeral storage filesystem.
	// If unspecified, ephemeral storage is backed by the boot disk.
	EphemeralStorageConfig *EphemeralStorageConfig `protobuf:"bytes,24,opt,name=ephemeral_storage_config,json=ephemeralStorageConfig,proto3" json:"ephemeral_storage_config,omitempty"`
}

func (x *NodeConfig) Reset() {
	*x = NodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfig) ProtoMessage() {}

func (x *NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfig.ProtoReflect.Descriptor instead.
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{2}
}

func (x *NodeConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *NodeConfig) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeConfig) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *NodeConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *NodeConfig) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *NodeConfig) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *NodeConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NodeConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

func (x *NodeConfig) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *NodeConfig) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *NodeConfig) GetAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *NodeConfig) GetSandboxConfig() *SandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

func (x *NodeConfig) GetNodeGroup() string {
	if x != nil {
		return x.NodeGroup
	}
	return ""
}

func (x *NodeConfig) GetReservationAffinity() *ReservationAffinity {
	if x != nil {
		return x.ReservationAffinity
	}
	return nil
}

func (x *NodeConfig) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *NodeConfig) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *NodeConfig) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if x != nil {
		return x.WorkloadMetadataConfig
	}
	return nil
}

func (x *NodeConfig) GetTaints() []*NodeTaint {
	if x != nil {
		return x.Taints
	}
	return nil
}

func (x *NodeConfig) GetBootDiskKmsKey() string {
	if x != nil {
		return x.BootDiskKmsKey
	}
	return ""
}

func (x *NodeConfig) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *NodeConfig) GetLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.LinuxNodeConfig
	}
	return nil
}

func (x *NodeConfig) GetKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.KubeletConfig
	}
	return nil
}

func (x *NodeConfig) GetEphemeralStorageConfig() *EphemeralStorageConfig {
	if x != nil {
		return x.EphemeralStorageConfig
	}
	return nil
}

// A set of Shielded Instance options.
type ShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the instance has Secure Boot enabled.
	//
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the
	// boot process if signature verification fails.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Defines whether the instance has integrity monitoring enabled.
	//
	// Enables monitoring and attestation of the boot integrity of the instance.
	// The attestation is performed against the integrity policy baseline. This
	// baseline is initially derived from the implicitly trusted boot image when
	// the instance is created.
	EnableIntegrityMonitoring bool `protobuf:"varint,2,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *ShieldedInstanceConfig) Reset() {
	*x = ShieldedInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedInstanceConfig) ProtoMessage() {}

func (x *ShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{3}
}

func (x *ShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil {
		return x.EnableSecureBoot
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// SandboxConfig contains configurations of the sandbox to use for the node.
type SandboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the sandbox to use for the node (e.g. 'gvisor')
	//
	// Deprecated: Do not use.
	SandboxType string `protobuf:"bytes,1,opt,name=sandbox_type,json=sandboxType,proto3" json:"sandbox_type,omitempty"`
	// Type of the sandbox to use for the node.
	Type SandboxConfig_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.container.v1beta1.SandboxConfig_Type" json:"type,omitempty"`
}

func (x *SandboxConfig) Reset() {
	*x = SandboxConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SandboxConfig) ProtoMessage() {}

func (x *SandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SandboxConfig.ProtoReflect.Descriptor instead.
func (*SandboxConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{4}
}

// Deprecated: Do not use.
func (x *SandboxConfig) GetSandboxType() string {
	if x != nil {
		return x.SandboxType
	}
	return ""
}

func (x *SandboxConfig) GetType() SandboxConfig_Type {
	if x != nil {
		return x.Type
	}
	return SandboxConfig_UNSPECIFIED
}

// EphemeralStorageConfig contains configuration for the ephemeral storage
// filesystem.
type EphemeralStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of local SSDs to use to back ephemeral storage. Uses NVMe
	// interfaces. Each local SSD is 375 GB in size.
	// If zero, it means to disable using local SSDs as ephemeral storage.
	LocalSsdCount int32 `protobuf:"varint,1,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
}

func (x *EphemeralStorageConfig) Reset() {
	*x = EphemeralStorageConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EphemeralStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EphemeralStorageConfig) ProtoMessage() {}

func (x *EphemeralStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EphemeralStorageConfig.ProtoReflect.Descriptor instead.
func (*EphemeralStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{5}
}

func (x *EphemeralStorageConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

// [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
// is the configuration of desired reservation which instances could take
// capacity from.
type ReservationAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Corresponds to the type of reservation consumption.
	ConsumeReservationType ReservationAffinity_Type `protobuf:"varint,1,opt,name=consume_reservation_type,json=consumeReservationType,proto3,enum=google.container.v1beta1.ReservationAffinity_Type" json:"consume_reservation_type,omitempty"`
	// Corresponds to the label key of a reservation resource. To target a
	// SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as
	// the key and specify the name of your reservation as its value.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Corresponds to the label value(s) of reservation resource(s).
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ReservationAffinity) Reset() {
	*x = ReservationAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReservationAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReservationAffinity) ProtoMessage() {}

func (x *ReservationAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReservationAffinity.ProtoReflect.Descriptor instead.
func (*ReservationAffinity) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{6}
}

func (x *ReservationAffinity) GetConsumeReservationType() ReservationAffinity_Type {
	if x != nil {
		return x.ConsumeReservationType
	}
	return ReservationAffinity_UNSPECIFIED
}

func (x *ReservationAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ReservationAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Kubernetes taint is comprised of three fields: key, value, and effect. Effect
// can only be one of three types:  NoSchedule, PreferNoSchedule or NoExecute.
//
// See
// [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration)
// for more information, including usage and the valid values.
type NodeTaint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key for taint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value for taint.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Effect for taint.
	Effect NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.container.v1beta1.NodeTaint_Effect" json:"effect,omitempty"`
}

func (x *NodeTaint) Reset() {
	*x = NodeTaint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeTaint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTaint) ProtoMessage() {}

func (x *NodeTaint) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTaint.ProtoReflect.Descriptor instead.
func (*NodeTaint) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{7}
}

func (x *NodeTaint) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *NodeTaint) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *NodeTaint) GetEffect() NodeTaint_Effect {
	if x != nil {
		return x.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, basic authentication can be disabled by
	// leaving username unspecified (or setting it to the empty string).
	//
	// Warning: basic authentication is deprecated, and will be removed in GKE
	// control plane versions 1.19 and newer. For a list of recommended
	// authentication methods, see:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
	//
	// Deprecated: Do not use.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	//
	// Warning: basic authentication is deprecated, and will be removed in GKE
	// control plane versions 1.19 and newer. For a list of recommended
	// authentication methods, see:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
	//
	// Deprecated: Do not use.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Configuration for client certificate authentication on the cluster. For
	// clusters before v1.12, if no configuration is specified, a client
	// certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `protobuf:"bytes,3,opt,name=client_certificate_config,json=clientCertificateConfig,proto3" json:"client_certificate_config,omitempty"`
	ClusterCaCertificate    string                   `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey string `protobuf:"bytes,102,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
}

func (x *MasterAuth) Reset() {
	*x = MasterAuth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuth) ProtoMessage() {}

func (x *MasterAuth) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuth.ProtoReflect.Descriptor instead.
func (*MasterAuth) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{8}
}

// Deprecated: Do not use.
func (x *MasterAuth) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Deprecated: Do not use.
func (x *MasterAuth) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MasterAuth) GetClientCertificateConfig() *ClientCertificateConfig {
	if x != nil {
		return x.ClientCertificateConfig
	}
	return nil
}

func (x *MasterAuth) GetClusterCaCertificate() string {
	if x != nil {
		return x.ClusterCaCertificate
	}
	return ""
}

func (x *MasterAuth) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MasterAuth) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

// Configuration for client certificates on the cluster.
type ClientCertificateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue a client certificate.
	IssueClientCertificate bool `protobuf:"varint,1,opt,name=issue_client_certificate,json=issueClientCertificate,proto3" json:"issue_client_certificate,omitempty"`
}

func (x *ClientCertificateConfig) Reset() {
	*x = ClientCertificateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientCertificateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCertificateConfig) ProtoMessage() {}

func (x *ClientCertificateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCertificateConfig.ProtoReflect.Descriptor instead.
func (*ClientCertificateConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{9}
}

func (x *ClientCertificateConfig) GetIssueClientCertificate() bool {
	if x != nil {
		return x.IssueClientCertificate
	}
	return false
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing,proto3" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling,proto3" json:"horizontal_pod_autoscaling,omitempty"`
	// Configuration for the Kubernetes Dashboard.
	// This addon is deprecated, and will be disabled in 1.15. It is recommended
	// to use the Cloud Console to manage and monitor your Kubernetes clusters,
	// workloads and applications. For more information, see:
	// https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
	//
	// Deprecated: Do not use.
	KubernetesDashboard *KubernetesDashboard `protobuf:"bytes,3,opt,name=kubernetes_dashboard,json=kubernetesDashboard,proto3" json:"kubernetes_dashboard,omitempty"`
	// Configuration for NetworkPolicy. This only tracks whether the addon
	// is enabled or not on the Master, it does not track whether network policy
	// is enabled for the nodes.
	NetworkPolicyConfig *NetworkPolicyConfig `protobuf:"bytes,4,opt,name=network_policy_config,json=networkPolicyConfig,proto3" json:"network_policy_config,omitempty"`
	// Configuration for Istio, an open platform to connect, manage, and secure
	// microservices.
	IstioConfig *IstioConfig `protobuf:"bytes,5,opt,name=istio_config,json=istioConfig,proto3" json:"istio_config,omitempty"`
	// Configuration for the Cloud Run addon. The `IstioConfig` addon must be
	// enabled in order to enable Cloud Run addon. This option can only be enabled
	// at cluster creation time.
	CloudRunConfig *CloudRunConfig `protobuf:"bytes,7,opt,name=cloud_run_config,json=cloudRunConfig,proto3" json:"cloud_run_config,omitempty"`
	// Configuration for NodeLocalDNS, a dns cache running on cluster nodes
	DnsCacheConfig *DnsCacheConfig `protobuf:"bytes,8,opt,name=dns_cache_config,json=dnsCacheConfig,proto3" json:"dns_cache_config,omitempty"`
	// Configuration for the ConfigConnector add-on, a Kubernetes
	// extension to manage hosted GCP services through the Kubernetes API
	ConfigConnectorConfig *ConfigConnectorConfig `protobuf:"bytes,10,opt,name=config_connector_config,json=configConnectorConfig,proto3" json:"config_connector_config,omitempty"`
	// Configuration for the Compute Engine Persistent Disk CSI driver.
	GcePersistentDiskCsiDriverConfig *GcePersistentDiskCsiDriverConfig `protobuf:"bytes,11,opt,name=gce_persistent_disk_csi_driver_config,json=gcePersistentDiskCsiDriverConfig,proto3" json:"gce_persistent_disk_csi_driver_config,omitempty"`
	// Configuration for the KALM addon, which manages the lifecycle of k8s
	// applications.
	KalmConfig *KalmConfig `protobuf:"bytes,12,opt,name=kalm_config,json=kalmConfig,proto3" json:"kalm_config,omitempty"`
}

func (x *AddonsConfig) Reset() {
	*x = AddonsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddonsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddonsConfig) ProtoMessage() {}

func (x *AddonsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddonsConfig.ProtoReflect.Descriptor instead.
func (*AddonsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{10}
}

func (x *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if x != nil {
		return x.HttpLoadBalancing
	}
	return nil
}

func (x *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if x != nil {
		return x.HorizontalPodAutoscaling
	}
	return nil
}

// Deprecated: Do not use.
func (x *AddonsConfig) GetKubernetesDashboard() *KubernetesDashboard {
	if x != nil {
		return x.KubernetesDashboard
	}
	return nil
}

func (x *AddonsConfig) GetNetworkPolicyConfig() *NetworkPolicyConfig {
	if x != nil {
		return x.NetworkPolicyConfig
	}
	return nil
}

func (x *AddonsConfig) GetIstioConfig() *IstioConfig {
	if x != nil {
		return x.IstioConfig
	}
	return nil
}

func (x *AddonsConfig) GetCloudRunConfig() *CloudRunConfig {
	if x != nil {
		return x.CloudRunConfig
	}
	return nil
}

func (x *AddonsConfig) GetDnsCacheConfig() *DnsCacheConfig {
	if x != nil {
		return x.DnsCacheConfig
	}
	return nil
}

func (x *AddonsConfig) GetConfigConnectorConfig() *ConfigConnectorConfig {
	if x != nil {
		return x.ConfigConnectorConfig
	}
	return nil
}

func (x *AddonsConfig) GetGcePersistentDiskCsiDriverConfig() *GcePersistentDiskCsiDriverConfig {
	if x != nil {
		return x.GcePersistentDiskCsiDriverConfig
	}
	return nil
}

func (x *AddonsConfig) GetKalmConfig() *KalmConfig {
	if x != nil {
		return x.KalmConfig
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *HttpLoadBalancing) Reset() {
	*x = HttpLoadBalancing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpLoadBalancing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpLoadBalancing) ProtoMessage() {}

func (x *HttpLoadBalancing) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpLoadBalancing.ProtoReflect.Descriptor instead.
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{11}
}

func (x *HttpLoadBalancing) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that metrics are collected into Stackdriver
	// Monitoring.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *HorizontalPodAutoscaling) Reset() {
	*x = HorizontalPodAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HorizontalPodAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HorizontalPodAutoscaling) ProtoMessage() {}

func (x *HorizontalPodAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HorizontalPodAutoscaling.ProtoReflect.Descriptor instead.
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{12}
}

func (x *HorizontalPodAutoscaling) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *KubernetesDashboard) Reset() {
	*x = KubernetesDashboard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesDashboard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesDashboard) ProtoMessage() {}

func (x *KubernetesDashboard) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesDashboard.ProtoReflect.Descriptor instead.
func (*KubernetesDashboard) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{13}
}

func (x *KubernetesDashboard) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for NetworkPolicy. This only tracks whether the addon
// is enabled or not on the Master, it does not track whether network policy
// is enabled for the nodes.
type NetworkPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether NetworkPolicy is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *NetworkPolicyConfig) Reset() {
	*x = NetworkPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicyConfig) ProtoMessage() {}

func (x *NetworkPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicyConfig.ProtoReflect.Descriptor instead.
func (*NetworkPolicyConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{14}
}

func (x *NetworkPolicyConfig) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for NodeLocal DNSCache
type DnsCacheConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether NodeLocal DNSCache is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *DnsCacheConfig) Reset() {
	*x = DnsCacheConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsCacheConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsCacheConfig) ProtoMessage() {}

func (x *DnsCacheConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsCacheConfig.ProtoReflect.Descriptor instead.
func (*DnsCacheConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{15}
}

func (x *DnsCacheConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the KALM addon.
type KalmConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether KALM is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *KalmConfig) Reset() {
	*x = KalmConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KalmConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KalmConfig) ProtoMessage() {}

func (x *KalmConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KalmConfig.ProtoReflect.Descriptor instead.
func (*KalmConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{16}
}

func (x *KalmConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the Config Connector add-on.
type ConfigConnectorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud Connector is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ConfigConnectorConfig) Reset() {
	*x = ConfigConnectorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigConnectorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigConnectorConfig) ProtoMessage() {}

func (x *ConfigConnectorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigConnectorConfig.ProtoReflect.Descriptor instead.
func (*ConfigConnectorConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{17}
}

func (x *ConfigConnectorConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the Compute Engine PD CSI driver. This option can only be
// enabled at cluster creation time.
type GcePersistentDiskCsiDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Compute Engine PD CSI driver is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GcePersistentDiskCsiDriverConfig) Reset() {
	*x = GcePersistentDiskCsiDriverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcePersistentDiskCsiDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcePersistentDiskCsiDriverConfig) ProtoMessage() {}

func (x *GcePersistentDiskCsiDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcePersistentDiskCsiDriverConfig.ProtoReflect.Descriptor instead.
func (*GcePersistentDiskCsiDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{18}
}

func (x *GcePersistentDiskCsiDriverConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for controlling master global access settings.
type PrivateClusterMasterGlobalAccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whenever master is accessible globally or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PrivateClusterMasterGlobalAccessConfig) Reset() {
	*x = PrivateClusterMasterGlobalAccessConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateClusterMasterGlobalAccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateClusterMasterGlobalAccessConfig) ProtoMessage() {}

func (x *PrivateClusterMasterGlobalAccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateClusterMasterGlobalAccessConfig.ProtoReflect.Descriptor instead.
func (*PrivateClusterMasterGlobalAccessConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{19}
}

func (x *PrivateClusterMasterGlobalAccessConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for private clusters.
type PrivateClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether nodes have internal IP addresses only. If enabled, all nodes are
	// given only RFC 1918 private addresses and communicate with the master via
	// private networking.
	EnablePrivateNodes bool `protobuf:"varint,1,opt,name=enable_private_nodes,json=enablePrivateNodes,proto3" json:"enable_private_nodes,omitempty"`
	// Whether the master's internal IP address is used as the cluster endpoint.
	EnablePrivateEndpoint bool `protobuf:"varint,2,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// The IP range in CIDR notation to use for the hosted master network. This
	// range will be used for assigning internal IP addresses to the master or
	// set of masters, as well as the ILB VIP. This range must not overlap with
	// any other ranges in use within the cluster's network.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Output only. The internal IP address of this cluster's master endpoint.
	PrivateEndpoint string `protobuf:"bytes,4,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Output only. The external IP address of this cluster's master endpoint.
	PublicEndpoint string `protobuf:"bytes,5,opt,name=public_endpoint,json=publicEndpoint,proto3" json:"public_endpoint,omitempty"`
	// Output only. The peering name in the customer VPC used by this cluster.
	PeeringName string `protobuf:"bytes,7,opt,name=peering_name,json=peeringName,proto3" json:"peering_name,omitempty"`
	// Controls master global access settings.
	MasterGlobalAccessConfig *PrivateClusterMasterGlobalAccessConfig `protobuf:"bytes,8,opt,name=master_global_access_config,json=masterGlobalAccessConfig,proto3" json:"master_global_access_config,omitempty"`
}

func (x *PrivateClusterConfig) Reset() {
	*x = PrivateClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateClusterConfig) ProtoMessage() {}

func (x *PrivateClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateClusterConfig.ProtoReflect.Descriptor instead.
func (*PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{20}
}

func (x *PrivateClusterConfig) GetEnablePrivateNodes() bool {
	if x != nil {
		return x.EnablePrivateNodes
	}
	return false
}

func (x *PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if x != nil {
		return x.EnablePrivateEndpoint
	}
	return false
}

func (x *PrivateClusterConfig) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

func (x *PrivateClusterConfig) GetPrivateEndpoint() string {
	if x != nil {
		return x.PrivateEndpoint
	}
	return ""
}

func (x *PrivateClusterConfig) GetPublicEndpoint() string {
	if x != nil {
		return x.PublicEndpoint
	}
	return ""
}

func (x *PrivateClusterConfig) GetPeeringName() string {
	if x != nil {
		return x.PeeringName
	}
	return ""
}

func (x *PrivateClusterConfig) GetMasterGlobalAccessConfig() *PrivateClusterMasterGlobalAccessConfig {
	if x != nil {
		return x.MasterGlobalAccessConfig
	}
	return nil
}

// Configuration options for Istio addon.
type IstioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Istio is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// The specified Istio auth mode, either none, or mutual TLS.
	Auth IstioConfig_IstioAuthMode `protobuf:"varint,2,opt,name=auth,proto3,enum=google.container.v1beta1.IstioConfig_IstioAuthMode" json:"auth,omitempty"`
}

func (x *IstioConfig) Reset() {
	*x = IstioConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IstioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstioConfig) ProtoMessage() {}

func (x *IstioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstioConfig.ProtoReflect.Descriptor instead.
func (*IstioConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{21}
}

func (x *IstioConfig) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *IstioConfig) GetAuth() IstioConfig_IstioAuthMode {
	if x != nil {
		return x.Auth
	}
	return IstioConfig_AUTH_NONE
}

// Configuration options for the Cloud Run feature.
type CloudRunConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud Run addon is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Which load balancer type is installed for Cloud Run.
	LoadBalancerType CloudRunConfig_LoadBalancerType `protobuf:"varint,3,opt,name=load_balancer_type,json=loadBalancerType,proto3,enum=google.container.v1beta1.CloudRunConfig_LoadBalancerType" json:"load_balancer_type,omitempty"`
}

func (x *CloudRunConfig) Reset() {
	*x = CloudRunConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRunConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunConfig) ProtoMessage() {}

func (x *CloudRunConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunConfig.ProtoReflect.Descriptor instead.
func (*CloudRunConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{22}
}

func (x *CloudRunConfig) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *CloudRunConfig) GetLoadBalancerType() CloudRunConfig_LoadBalancerType {
	if x != nil {
		return x.LoadBalancerType
	}
	return CloudRunConfig_LOAD_BALANCER_TYPE_UNSPECIFIED
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not master authorized networks is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// cidr_blocks define up to 10 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig) Reset() {
	*x = MasterAuthorizedNetworksConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuthorizedNetworksConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{23}
}

func (x *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if x != nil {
		return x.CidrBlocks
	}
	return nil
}

// Configuration for the legacy Attribute Based Access Control authorization
// mode.
type LegacyAbac struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the ABAC authorizer is enabled for this cluster. When enabled,
	// identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those
	// provided by the RBAC configuration or IAM.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *LegacyAbac) Reset() {
	*x = LegacyAbac{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LegacyAbac) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LegacyAbac) ProtoMessage() {}

func (x *LegacyAbac) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LegacyAbac.ProtoReflect.Descriptor instead.
func (*LegacyAbac) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{24}
}

func (x *LegacyAbac) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected network policy provider.
	Provider NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.container.v1beta1.NetworkPolicy_Provider" json:"provider,omitempty"`
	// Whether network policy is enabled on the cluster.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{25}
}

func (x *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if x != nil {
		return x.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

func (x *NetworkPolicy) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for controlling how IPs are allocated in the cluster.
type IPAllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether alias IPs will be used for pod IPs in the cluster.
	// This is used in conjunction with use_routes. It cannot
	// be true if use_routes is true. If both use_ip_aliases and use_routes are
	// false, then the server picks the default IP allocation mode
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases,proto3" json:"use_ip_aliases,omitempty"`
	// Whether a new subnetwork will be created automatically for the cluster.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `protobuf:"varint,2,opt,name=create_subnetwork,json=createSubnetwork,proto3" json:"create_subnetwork,omitempty"`
	// A custom subnetwork name to be used if `create_subnetwork` is true.  If
	// this field is empty, then an automatic name will be chosen for the new
	// subnetwork.
	SubnetworkName string `protobuf:"bytes,3,opt,name=subnetwork_name,json=subnetworkName,proto3" json:"subnetwork_name,omitempty"`
	// This field is deprecated, use cluster_ipv4_cidr_block.
	//
	// Deprecated: Do not use.
	ClusterIpv4Cidr string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// This field is deprecated, use node_ipv4_cidr_block.
	//
	// Deprecated: Do not use.
	NodeIpv4Cidr string `protobuf:"bytes,5,opt,name=node_ipv4_cidr,json=nodeIpv4Cidr,proto3" json:"node_ipv4_cidr,omitempty"`
	// This field is deprecated, use services_ipv4_cidr_block.
	//
	// Deprecated: Do not use.
	ServicesIpv4Cidr string `protobuf:"bytes,6,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// The name of the secondary range to be used for the cluster CIDR
	// block.  The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `protobuf:"bytes,7,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName,proto3" json:"cluster_secondary_range_name,omitempty"`
	// The name of the secondary range to be used as for the services
	// CIDR block.  The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `protobuf:"bytes,8,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName,proto3" json:"services_secondary_range_name,omitempty"`
	// The IP address range for the cluster pod IPs. If this field is set, then
	// `cluster.cluster_ipv4_cidr` must be left blank.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3" json:"cluster_ipv4_cidr_block,omitempty"`
	// The IP address range of the instance IPs in this cluster.
	//
	// This is applicable only if `create_subnetwork` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	NodeIpv4CidrBlock string `protobuf:"bytes,10,opt,name=node_ipv4_cidr_block,json=nodeIpv4CidrBlock,proto3" json:"node_ipv4_cidr_block,omitempty"`
	// The IP address range of the services IPs in this cluster. If blank, a range
	// will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string `protobuf:"bytes,11,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock,proto3" json:"services_ipv4_cidr_block,omitempty"`
	// If true, allow allocation of cluster CIDR ranges that overlap with certain
	// kinds of network routes. By default we do not allow cluster CIDR ranges to
	// intersect with any user declared routes. With allow_route_overlap == true,
	// we allow overlapping with CIDR ranges that are larger than the cluster CIDR
	// range.
	//
	// If this field is set to true, then cluster and services CIDRs must be
	// fully-specified (e.g. `10.96.0.0/14`, but not `/14`), which means:
	// 1) When `use_ip_aliases` is true, `cluster_ipv4_cidr_block` and
	//    `services_ipv4_cidr_block` must be fully-specified.
	// 2) When `use_ip_aliases` is false, `cluster.cluster_ipv4_cidr` muse be
	//    fully-specified.
	AllowRouteOverlap bool `protobuf:"varint,12,opt,name=allow_route_overlap,json=allowRouteOverlap,proto3" json:"allow_route_overlap,omitempty"`
	// The IP address range of the Cloud TPUs in this cluster. If unspecified, a
	// range will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// If unspecified, the range will use the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	// This field is deprecated, use cluster.tpu_config.ipv4_cidr_block instead.
	TpuIpv4CidrBlock string `protobuf:"bytes,13,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	// Whether routes will be used for pod IPs in the cluster.
	// This is used in conjunction with use_ip_aliases. It cannot be true if
	// use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
	// then the server picks the default IP allocation mode
	UseRoutes bool `protobuf:"varint,15,opt,name=use_routes,json=useRoutes,proto3" json:"use_routes,omitempty"`
}

func (x *IPAllocationPolicy) Reset() {
	*x = IPAllocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IPAllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPAllocationPolicy) ProtoMessage() {}

func (x *IPAllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPAllocationPolicy.ProtoReflect.Descriptor instead.
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{26}
}

func (x *IPAllocationPolicy) GetUseIpAliases() bool {
	if x != nil {
		return x.UseIpAliases
	}
	return false
}

func (x *IPAllocationPolicy) GetCreateSubnetwork() bool {
	if x != nil {
		return x.CreateSubnetwork
	}
	return false
}

func (x *IPAllocationPolicy) GetSubnetworkName() string {
	if x != nil {
		return x.SubnetworkName
	}
	return ""
}

// Deprecated: Do not use.
func (x *IPAllocationPolicy) GetClusterIpv4Cidr() string {
	if x != nil {
		return x.ClusterIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (x *IPAllocationPolicy) GetNodeIpv4Cidr() string {
	if x != nil {
		return x.NodeIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (x *IPAllocationPolicy) GetServicesIpv4Cidr() string {
	if x != nil {
		return x.ServicesIpv4Cidr
	}
	return ""
}

func (x *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if x != nil {
		return x.ClusterSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if x != nil {
		return x.ServicesSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if x != nil {
		return x.ClusterIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetNodeIpv4CidrBlock() string {
	if x != nil {
		return x.NodeIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if x != nil {
		return x.ServicesIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetAllowRouteOverlap() bool {
	if x != nil {
		return x.AllowRouteOverlap
	}
	return false
}

func (x *IPAllocationPolicy) GetTpuIpv4CidrBlock() string {
	if x != nil {
		return x.TpuIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetUseRoutes() bool {
	if x != nil {
		return x.UseRoutes
	}
	return false
}

// Configuration for Binary Authorization.
type BinaryAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable Binary Authorization for this cluster. If enabled, all container
	// images will be validated by Google Binauthz.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *BinaryAuthorization) Reset() {
	*x = BinaryAuthorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinaryAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinaryAuthorization) ProtoMessage() {}

func (x *BinaryAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinaryAuthorization.ProtoReflect.Descriptor instead.
func (*BinaryAuthorization) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{27}
}

func (x *BinaryAuthorization) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the PodSecurityPolicy feature.
type PodSecurityPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable the PodSecurityPolicy controller for this cluster. If enabled, pods
	// must be valid under a PodSecurityPolicy to be created.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PodSecurityPolicyConfig) Reset() {
	*x = PodSecurityPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PodSecurityPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodSecurityPolicyConfig) ProtoMessage() {}

func (x *PodSecurityPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodSecurityPolicyConfig.ProtoReflect.Descriptor instead.
func (*PodSecurityPolicyConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{28}
}

func (x *PodSecurityPolicyConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for returning group information from authenticators.
type AuthenticatorGroupsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether this cluster should return group membership lookups
	// during authentication using a group of security groups.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name of the security group-of-groups to be used. Only relevant
	// if enabled = true.
	SecurityGroup string `protobuf:"bytes,2,opt,name=security_group,json=securityGroup,proto3" json:"security_group,omitempty"`
}

func (x *AuthenticatorGroupsConfig) Reset() {
	*x = AuthenticatorGroupsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticatorGroupsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticatorGroupsConfig) ProtoMessage() {}

func (x *AuthenticatorGroupsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticatorGroupsConfig.ProtoReflect.Descriptor instead.
func (*AuthenticatorGroupsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{29}
}

func (x *AuthenticatorGroupsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AuthenticatorGroupsConfig) GetSecurityGroup() string {
	if x != nil {
		return x.SecurityGroup
	}
	return ""
}

// Telemetry integration for the cluster.
type ClusterTelemetry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the integration.
	Type ClusterTelemetry_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.container.v1beta1.ClusterTelemetry_Type" json:"type,omitempty"`
}

func (x *ClusterTelemetry) Reset() {
	*x = ClusterTelemetry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterTelemetry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterTelemetry) ProtoMessage() {}

func (x *ClusterTelemetry) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterTelemetry.ProtoReflect.Descriptor instead.
func (*ClusterTelemetry) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{30}
}

func (x *ClusterTelemetry) GetType() ClusterTelemetry_Type {
	if x != nil {
		return x.Type
	}
	return ClusterTelemetry_UNSPECIFIED
}

// A Google Kubernetes Engine cluster.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this cluster. The name must be unique within this project
	// and location (e.g. zone or region), and can be up to 40 characters with
	// the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	//
	// This field is deprecated, use node_pool.initial_node_count instead.
	//
	// Deprecated: Do not use.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool. (For configuration of each node pool, see
	// `node_pool.config`)
	//
	// If unspecified, the defaults are used.
	// This field is deprecated, use node_pool.config instead.
	//
	// Deprecated: Do not use.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	// If unspecified, the defaults are used:
	// For clusters before v1.12, if master_auth is unspecified, `username` will
	// be set to "admin", a random password will be generated, and a client
	// certificate will be issued.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth,proto3" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	// * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//   available as of GKE 1.15).
	// * `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	// * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//   longer available as of GKE 1.15).
	// * `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. If left unspecified, the `default`
	// network will be used. On output this shows the network ID instead of the
	// name.
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
	// the cluster is connected. On output this shows the subnetwork ID instead of
	// the name.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located.
	//
	// This field provides a default value if
	// [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// are not specified during node pool creation.
	//
	// Warning: changing cluster locations will update the
	// [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// of all node pools and will result in nodes being added and/or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1beta1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha,proto3" json:"enable_kubernetes_alpha,omitempty"`
	// The resource labels for the cluster to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,15,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `protobuf:"bytes,16,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `protobuf:"bytes,18,opt,name=legacy_abac,json=legacyAbac,proto3" json:"legacy_abac,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,19,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,20,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// The configuration options for master authorized networks feature.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,22,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
	// Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,23,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Configuration for Binary Authorization.
	BinaryAuthorization *BinaryAuthorization `protobuf:"bytes,24,opt,name=binary_authorization,json=binaryAuthorization,proto3" json:"binary_authorization,omitempty"`
	// Configuration for the PodSecurityPolicy feature.
	PodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,25,opt,name=pod_security_policy_config,json=podSecurityPolicyConfig,proto3" json:"pod_security_policy_config,omitempty"`
	// Cluster-level autoscaling configuration.
	Autoscaling *ClusterAutoscaling `protobuf:"bytes,26,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// Configuration for cluster networking.
	NetworkConfig *NetworkConfig `protobuf:"bytes,27,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// If this is a private cluster setup. Private clusters are clusters that, by
	// default have no external IP addresses on the nodes and where nodes and the
	// master communicate over private IP addresses.
	// This field is deprecated, use private_cluster_config.enable_private_nodes
	// instead.
	//
	// Deprecated: Do not use.
	PrivateCluster bool `protobuf:"varint,28,opt,name=private_cluster,json=privateCluster,proto3" json:"private_cluster,omitempty"`
	// The IP prefix in CIDR notation to use for the hosted master network.
	// This prefix will be used for assigning private IP addresses to the
	// master or set of masters, as well as the ILB VIP.
	// This field is deprecated, use
	// private_cluster_config.master_ipv4_cidr_block instead.
	//
	// Deprecated: Do not use.
	MasterIpv4CidrBlock string `protobuf:"bytes,29,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// The default constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool of this cluster. Only honored
	// if cluster created with IP Alias support.
	DefaultMaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,30,opt,name=default_max_pods_constraint,json=defaultMaxPodsConstraint,proto3" json:"default_max_pods_constraint,omitempty"`
	// Configuration for exporting resource usages. Resource usage export is
	// disabled when this config unspecified.
	ResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,33,opt,name=resource_usage_export_config,json=resourceUsageExportConfig,proto3" json:"resource_usage_export_config,omitempty"`
	// Configuration controlling RBAC group membership information.
	AuthenticatorGroupsConfig *AuthenticatorGroupsConfig `protobuf:"bytes,34,opt,name=authenticator_groups_config,json=authenticatorGroupsConfig,proto3" json:"authenticator_groups_config,omitempty"`
	// Configuration for private cluster.
	PrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,37,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	VerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,39,opt,name=vertical_pod_autoscaling,json=verticalPodAutoscaling,proto3" json:"vertical_pod_autoscaling,omitempty"`
	// Shielded Nodes configuration.
	ShieldedNodes *ShieldedNodes `protobuf:"bytes,40,opt,name=shielded_nodes,json=shieldedNodes,proto3" json:"shielded_nodes,omitempty"`
	// Release channel configuration.
	ReleaseChannel *ReleaseChannel `protobuf:"bytes,41,opt,name=release_channel,json=releaseChannel,proto3" json:"release_channel,omitempty"`
	// Configuration for the use of Kubernetes Service Accounts in GCP IAM
	// policies.
	WorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,43,opt,name=workload_identity_config,json=workloadIdentityConfig,proto3" json:"workload_identity_config,omitempty"`
	// Telemetry integration for the cluster.
	ClusterTelemetry *ClusterTelemetry `protobuf:"bytes,46,opt,name=cluster_telemetry,json=clusterTelemetry,proto3" json:"cluster_telemetry,omitempty"`
	// Configuration for Cloud TPU support;
	TpuConfig *TpuConfig `protobuf:"bytes,47,opt,name=tpu_config,json=tpuConfig,proto3" json:"tpu_config,omitempty"`
	// Notification configuration of the cluster.
	NotificationConfig *NotificationConfig `protobuf:"bytes,49,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Configuration of Confidential Nodes
	ConfidentialNodes *ConfidentialNodes `protobuf:"bytes,50,opt,name=confidential_nodes,json=confidentialNodes,proto3" json:"confidential_nodes,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field is deprecated, use location instead.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,101,opt,name=zone,proto3" json:"zone,omitempty"`
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "","-": picks the default Kubernetes version
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion,proto3" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion,proto3" json:"current_master_version,omitempty"`
	// [Output only] Deprecated, use
	// [NodePool.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools)
	// instead. The current version of the node software components.
	// If they are currently at multiple versions because they're in the process
	// of being upgraded, this reflects the minimum version of all nodes.
	//
	// Deprecated: Do not use.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion,proto3" json:"current_node_version,omitempty"`
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,proto3,enum=google.container.v1beta1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Deprecated. Use conditions instead.
	// Additional information about the current status of this
	// cluster, if available.
	//
	// Deprecated: Do not use.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range. This field will only be set when cluster is in route-based network
	// mode.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize,proto3" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// Deprecated. Use node_pools.instance_group_urls.
	//
	// Deprecated: Do not use.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// [Output only]  The number of nodes currently in the cluster. Deprecated.
	// Call Kubernetes API directly to retrieve node information.
	//
	// Deprecated: Do not use.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount,proto3" json:"current_node_count,omitempty"`
	// [Output only] The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// or
	// [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `protobuf:"bytes,114,opt,name=location,proto3" json:"location,omitempty"`
	// Enable the ability to use Cloud TPUs in this cluster.
	// This field is deprecated, use tpu_config.enabled instead.
	EnableTpu bool `protobuf:"varint,115,opt,name=enable_tpu,json=enableTpu,proto3" json:"enable_tpu,omitempty"`
	// [Output only] The IP address range of the Cloud TPUs in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`).
	TpuIpv4CidrBlock string `protobuf:"bytes,116,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	// Configuration of etcd encryption.
	DatabaseEncryption *DatabaseEncryption `protobuf:"bytes,38,opt,name=database_encryption,json=databaseEncryption,proto3" json:"database_encryption,omitempty"`
	// Which conditions caused the current cluster state.
	Conditions []*StatusCondition `protobuf:"bytes,118,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Configuration for master components.
	Master *Master `protobuf:"bytes,124,opt,name=master,proto3" json:"master,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{31}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Deprecated: Do not use.
func (x *Cluster) GetInitialNodeCount() int32 {
	if x != nil {
		return x.InitialNodeCount
	}
	return 0
}

// Deprecated: Do not use.
func (x *Cluster) GetNodeConfig() *NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

func (x *Cluster) GetMasterAuth() *MasterAuth {
	if x != nil {
		return x.MasterAuth
	}
	return nil
}

func (x *Cluster) GetLoggingService() string {
	if x != nil {
		return x.LoggingService
	}
	return ""
}

func (x *Cluster) GetMonitoringService() string {
	if x != nil {
		return x.MonitoringService
	}
	return ""
}

func (x *Cluster) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Cluster) GetClusterIpv4Cidr() string {
	if x != nil {
		return x.ClusterIpv4Cidr
	}
	return ""
}

func (x *Cluster) GetAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.AddonsConfig
	}
	return nil
}

func (x *Cluster) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *Cluster) GetNodePools() []*NodePool {
	if x != nil {
		return x.NodePools
	}
	return nil
}

func (x *Cluster) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *Cluster) GetEnableKubernetesAlpha() bool {
	if x != nil {
		return x.EnableKubernetesAlpha
	}
	return false
}

func (x *Cluster) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *Cluster) GetLabelFingerprint() string {
	if x != nil {
		return x.LabelFingerprint
	}
	return ""
}

func (x *Cluster) GetLegacyAbac() *LegacyAbac {
	if x != nil {
		return x.LegacyAbac
	}
	return nil
}

func (x *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if x != nil {
		return x.IpAllocationPolicy
	}
	return nil
}

func (x *Cluster) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (x *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *Cluster) GetBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.BinaryAuthorization
	}
	return nil
}

func (x *Cluster) GetPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if x != nil {
		return x.PodSecurityPolicyConfig
	}
	return nil
}

func (x *Cluster) GetAutoscaling() *ClusterAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *Cluster) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

// Deprecated: Do not use.
func (x *Cluster) GetPrivateCluster() bool {
	if x != nil {
		return x.PrivateCluster
	}
	return false
}

// Deprecated: Do not use.
func (x *Cluster) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

func (x *Cluster) GetDefaultMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.DefaultMaxPodsConstraint
	}
	return nil
}

func (x *Cluster) GetResourceUsageExportConfig() *ResourceUsageExportConfig {
	if x != nil {
		return x.ResourceUsageExportConfig
	}
	return nil
}

func (x *Cluster) GetAuthenticatorGroupsConfig() *AuthenticatorGroupsConfig {
	if x != nil {
		return x.AuthenticatorGroupsConfig
	}
	return nil
}

func (x *Cluster) GetPrivateClusterConfig() *PrivateClusterConfig {
	if x != nil {
		return x.PrivateClusterConfig
	}
	return nil
}

func (x *Cluster) GetVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if x != nil {
		return x.VerticalPodAutoscaling
	}
	return nil
}

func (x *Cluster) GetShieldedNodes() *ShieldedNodes {
	if x != nil {
		return x.ShieldedNodes
	}
	return nil
}

func (x *Cluster) GetReleaseChannel() *ReleaseChannel {
	if x != nil {
		return x.ReleaseChannel
	}
	return nil
}

func (x *Cluster) GetWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.WorkloadIdentityConfig
	}
	return nil
}

func (x *Cluster) GetClusterTelemetry() *ClusterTelemetry {
	if x != nil {
		return x.ClusterTelemetry
	}
	return nil
}

func (x *Cluster) GetTpuConfig() *TpuConfig {
	if x != nil {
		return x.TpuConfig
	}
	return nil
}

func (x *Cluster) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *Cluster) GetConfidentialNodes() *ConfidentialNodes {
	if x != nil {
		return x.ConfidentialNodes
	}
	return nil
}

func (x *Cluster) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

// Deprecated: Do not use.
func (x *Cluster) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Cluster) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *Cluster) GetInitialClusterVersion() string {
	if x != nil {
		return x.InitialClusterVersion
	}
	return ""
}

func (x *Cluster) GetCurrentMasterVersion() string {
	if x != nil {
		return x.CurrentMasterVersion
	}
	return ""
}

// Deprecated: Do not use.
func (x *Cluster) GetCurrentNodeVersion() string {
	if x != nil {
		return x.CurrentNodeVersion
	}
	return ""
}

func (x *Cluster) GetCreateTime() string {
	if x != nil {
		return x.CreateTime
	}
	return ""
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *Cluster) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Cluster) GetNodeIpv4CidrSize() int32 {
	if x != nil {
		return x.NodeIpv4CidrSize
	}
	return 0
}

func (x *Cluster) GetServicesIpv4Cidr() string {
	if x != nil {
		return x.ServicesIpv4Cidr
	}
	return ""
}

// Deprecated: Do not use.
func (x *Cluster) GetInstanceGroupUrls() []string {
	if x != nil {
		return x.InstanceGroupUrls
	}
	return nil
}

// Deprecated: Do not use.
func (x *Cluster) GetCurrentNodeCount() int32 {
	if x != nil {
		return x.CurrentNodeCount
	}
	return 0
}

func (x *Cluster) GetExpireTime() string {
	if x != nil {
		return x.ExpireTime
	}
	return ""
}

func (x *Cluster) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Cluster) GetEnableTpu() bool {
	if x != nil {
		return x.EnableTpu
	}
	return false
}

func (x *Cluster) GetTpuIpv4CidrBlock() string {
	if x != nil {
		return x.TpuIpv4CidrBlock
	}
	return ""
}

func (x *Cluster) GetDatabaseEncryption() *DatabaseEncryption {
	if x != nil {
		return x.DatabaseEncryption
	}
	return nil
}

func (x *Cluster) GetConditions() []*StatusCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *Cluster) GetMaster() *Master {
	if x != nil {
		return x.Master
	}
	return nil
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion,proto3" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	// * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//   longer available as of GKE 1.15).
	// * `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService,proto3" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig,proto3" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family",
	// "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
	// is specified and there is more than one node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId,proto3" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType,proto3" json:"desired_image_type,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling,proto3" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located.
	//
	// This list must always include the cluster's primary zone.
	//
	// Warning: changing cluster locations will update the locations of all node
	// pools and will result in nodes being added and/or removed.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations,proto3" json:"desired_locations,omitempty"`
	// The desired configuration options for master authorized networks feature.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,12,opt,name=desired_master_authorized_networks_config,json=desiredMasterAuthorizedNetworksConfig,proto3" json:"desired_master_authorized_networks_config,omitempty"`
	// The desired configuration options for the PodSecurityPolicy feature.
	DesiredPodSecurityPolicyConfig *PodSecurityPolicyConfig `protobuf:"bytes,14,opt,name=desired_pod_security_policy_config,json=desiredPodSecurityPolicyConfig,proto3" json:"desired_pod_security_policy_config,omitempty"`
	// Cluster-level autoscaling configuration.
	DesiredClusterAutoscaling *ClusterAutoscaling `protobuf:"bytes,15,opt,name=desired_cluster_autoscaling,json=desiredClusterAutoscaling,proto3" json:"desired_cluster_autoscaling,omitempty"`
	// The desired configuration options for the Binary Authorization feature.
	DesiredBinaryAuthorization *BinaryAuthorization `protobuf:"bytes,16,opt,name=desired_binary_authorization,json=desiredBinaryAuthorization,proto3" json:"desired_binary_authorization,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	// * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//   available as of GKE 1.15).
	// * `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	DesiredLoggingService string `protobuf:"bytes,19,opt,name=desired_logging_service,json=desiredLoggingService,proto3" json:"desired_logging_service,omitempty"`
	// The desired configuration for exporting resource usage.
	DesiredResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,21,opt,name=desired_resource_usage_export_config,json=desiredResourceUsageExportConfig,proto3" json:"desired_resource_usage_export_config,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	DesiredVerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,22,opt,name=desired_vertical_pod_autoscaling,json=desiredVerticalPodAutoscaling,proto3" json:"desired_vertical_pod_autoscaling,omitempty"`
	// The desired private cluster configuration.
	DesiredPrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,25,opt,name=desired_private_cluster_config,json=desiredPrivateClusterConfig,proto3" json:"desired_private_cluster_config,omitempty"`
	// The desired config of Intra-node visibility.
	DesiredIntraNodeVisibilityConfig *IntraNodeVisibilityConfig `protobuf:"bytes,26,opt,name=desired_intra_node_visibility_config,json=desiredIntraNodeVisibilityConfig,proto3" json:"desired_intra_node_visibility_config,omitempty"`
	// The desired status of whether to disable default sNAT for this cluster.
	DesiredDefaultSnatStatus *DefaultSnatStatus `protobuf:"bytes,28,opt,name=desired_default_snat_status,json=desiredDefaultSnatStatus,proto3" json:"desired_default_snat_status,omitempty"`
	// The desired telemetry integration for the cluster.
	DesiredClusterTelemetry *ClusterTelemetry `protobuf:"bytes,30,opt,name=desired_cluster_telemetry,json=desiredClusterTelemetry,proto3" json:"desired_cluster_telemetry,omitempty"`
	// The desired release channel configuration.
	DesiredReleaseChannel *ReleaseChannel `protobuf:"bytes,31,opt,name=desired_release_channel,json=desiredReleaseChannel,proto3" json:"desired_release_channel,omitempty"`
	// The desired Cloud TPU configuration.
	DesiredTpuConfig *TpuConfig `protobuf:"bytes,38,opt,name=desired_tpu_config,json=desiredTpuConfig,proto3" json:"desired_tpu_config,omitempty"`
	// The desired datapath provider for the cluster.
	DesiredDatapathProvider DatapathProvider `protobuf:"varint,50,opt,name=desired_datapath_provider,json=desiredDatapathProvider,proto3,enum=google.container.v1beta1.DatapathProvider" json:"desired_datapath_provider,omitempty"`
	// The desired notification configuration.
	DesiredNotificationConfig *NotificationConfig `protobuf:"bytes,55,opt,name=desired_notification_config,json=desiredNotificationConfig,proto3" json:"desired_notification_config,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	DesiredMasterVersion string `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion,proto3" json:"desired_master_version,omitempty"`
	// Configuration of etcd encryption.
	DesiredDatabaseEncryption *DatabaseEncryption `protobuf:"bytes,46,opt,name=desired_database_encryption,json=desiredDatabaseEncryption,proto3" json:"desired_database_encryption,omitempty"`
	// Configuration for Workload Identity.
	DesiredWorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,47,opt,name=desired_workload_identity_config,json=desiredWorkloadIdentityConfig,proto3" json:"desired_workload_identity_config,omitempty"`
	// Configuration for Shielded Nodes.
	DesiredShieldedNodes *ShieldedNodes `protobuf:"bytes,48,opt,name=desired_shielded_nodes,json=desiredShieldedNodes,proto3" json:"desired_shielded_nodes,omitempty"`
	// Configuration for master components.
	DesiredMaster *Master `protobuf:"bytes,52,opt,name=desired_master,json=desiredMaster,proto3" json:"desired_master,omitempty"`
	// AuthenticatorGroupsConfig specifies the config for the cluster security
	// groups settings.
	DesiredAuthenticatorGroupsConfig *AuthenticatorGroupsConfig `protobuf:"bytes,63,opt,name=desired_authenticator_groups_config,json=desiredAuthenticatorGroupsConfig,proto3" json:"desired_authenticator_groups_config,omitempty"`
}

func (x *ClusterUpdate) Reset() {
	*x = ClusterUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterUpdate) ProtoMessage() {}

func (x *ClusterUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterUpdate.ProtoReflect.Descriptor instead.
func (*ClusterUpdate) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{32}
}

func (x *ClusterUpdate) GetDesiredNodeVersion() string {
	if x != nil {
		return x.DesiredNodeVersion
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredMonitoringService() string {
	if x != nil {
		return x.DesiredMonitoringService
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.DesiredAddonsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolId() string {
	if x != nil {
		return x.DesiredNodePoolId
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredImageType() string {
	if x != nil {
		return x.DesiredImageType
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.DesiredNodePoolAutoscaling
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredLocations() []string {
	if x != nil {
		return x.DesiredLocations
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.DesiredMasterAuthorizedNetworksConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredPodSecurityPolicyConfig() *PodSecurityPolicyConfig {
	if x != nil {
		return x.DesiredPodSecurityPolicyConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredClusterAutoscaling() *ClusterAutoscaling {
	if x != nil {
		return x.DesiredClusterAutoscaling
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.DesiredBinaryAuthorization
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredLoggingService() string {
	if x != nil {
		return x.DesiredLoggingService
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredResourceUsageExportConfig() *ResourceUsageExportConfig {
	if x != nil {
		return x.DesiredResourceUsageExportConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if x != nil {
		return x.DesiredVerticalPodAutoscaling
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredPrivateClusterConfig() *PrivateClusterConfig {
	if x != nil {
		return x.DesiredPrivateClusterConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredIntraNodeVisibilityConfig() *IntraNodeVisibilityConfig {
	if x != nil {
		return x.DesiredIntraNodeVisibilityConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredDefaultSnatStatus() *DefaultSnatStatus {
	if x != nil {
		return x.DesiredDefaultSnatStatus
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredClusterTelemetry() *ClusterTelemetry {
	if x != nil {
		return x.DesiredClusterTelemetry
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredReleaseChannel() *ReleaseChannel {
	if x != nil {
		return x.DesiredReleaseChannel
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredTpuConfig() *TpuConfig {
	if x != nil {
		return x.DesiredTpuConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredDatapathProvider() DatapathProvider {
	if x != nil {
		return x.DesiredDatapathProvider
	}
	return DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED
}

func (x *ClusterUpdate) GetDesiredNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.DesiredNotificationConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMasterVersion() string {
	if x != nil {
		return x.DesiredMasterVersion
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredDatabaseEncryption() *DatabaseEncryption {
	if x != nil {
		return x.DesiredDatabaseEncryption
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.DesiredWorkloadIdentityConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredShieldedNodes() *ShieldedNodes {
	if x != nil {
		return x.DesiredShieldedNodes
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMaster() *Master {
	if x != nil {
		return x.DesiredMaster
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredAuthenticatorGroupsConfig() *AuthenticatorGroupsConfig {
	if x != nil {
		return x.DesiredAuthenticatorGroupsConfig
	}
	return nil
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// operation is taking place. This field is deprecated, use location instead.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.container.v1beta1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,proto3,enum=google.container.v1beta1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. If an error has occurred, a textual description of the error.
	// Deprecated. Use field error instead.
	//
	// Deprecated: Do not use.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// or
	// [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `protobuf:"bytes,9,opt,name=location,proto3" json:"location,omitempty"`
	// [Output only] The time the operation started, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `protobuf:"bytes,10,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] The time the operation completed, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime string `protobuf:"bytes,11,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. [Output only] Progress information for an operation.
	Progress *OperationProgress `protobuf:"bytes,12,opt,name=progress,proto3" json:"progress,omitempty"`
	// Which conditions caused the current cluster state.
	// Deprecated. Use field error instead.
	//
	// Deprecated: Do not use.
	ClusterConditions []*StatusCondition `protobuf:"bytes,13,rep,name=cluster_conditions,json=clusterConditions,proto3" json:"cluster_conditions,omitempty"`
	// Which conditions caused the current node pool state.
	// Deprecated. Use field error instead.
	//
	// Deprecated: Do not use.
	NodepoolConditions []*StatusCondition `protobuf:"bytes,14,rep,name=nodepool_conditions,json=nodepoolConditions,proto3" json:"nodepool_conditions,omitempty"`
	// The error result of the operation in case of failure.
	Error *status.Status `protobuf:"bytes,15,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{33}
}

func (x *Operation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Do not use.
func (x *Operation) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Operation) GetOperationType() Operation_Type {
	if x != nil {
		return x.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (x *Operation) GetStatus() Operation_Status {
	if x != nil {
		return x.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (x *Operation) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// Deprecated: Do not use.
func (x *Operation) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Operation) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Operation) GetTargetLink() string {
	if x != nil {
		return x.TargetLink
	}
	return ""
}

func (x *Operation) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Operation) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *Operation) GetEndTime() string {
	if x != nil {
		return x.EndTime
	}
	return ""
}

func (x *Operation) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

// Deprecated: Do not use.
func (x *Operation) GetClusterConditions() []*StatusCondition {
	if x != nil {
		return x.ClusterConditions
	}
	return nil
}

// Deprecated: Do not use.
func (x *Operation) GetNodepoolConditions() []*StatusCondition {
	if x != nil {
		return x.NodepoolConditions
	}
	return nil
}

func (x *Operation) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Information about operation (or operation stage) progress.
type OperationProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A non-parameterized string describing an operation stage.
	// Unset for single-stage operations.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Status of an operation stage.
	// Unset for single-stage operations.
	Status Operation_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.container.v1beta1.Operation_Status" json:"status,omitempty"`
	// Progress metric bundle, for example:
	//   metrics: [{name: "nodes done",     int_value: 15},
	//             {name: "nodes total",    int_value: 32}]
	// or
	//   metrics: [{name: "progress",       double_value: 0.56},
	//             {name: "progress scale", double_value: 1.0}]
	Metrics []*OperationProgress_Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Substages of an operation or a stage.
	Stages []*OperationProgress `protobuf:"bytes,4,rep,name=stages,proto3" json:"stages,omitempty"`
}

func (x *OperationProgress) Reset() {
	*x = OperationProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationProgress) ProtoMessage() {}

func (x *OperationProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationProgress.ProtoReflect.Descriptor instead.
func (*OperationProgress) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{34}
}

func (x *OperationProgress) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OperationProgress) GetStatus() Operation_Status {
	if x != nil {
		return x.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (x *OperationProgress) GetMetrics() []*OperationProgress_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *OperationProgress) GetStages() []*OperationProgress {
	if x != nil {
		return x.Stages
	}
	return nil
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. A [cluster
	// resource](https://cloud.google.com/container-engine/reference/rest/v1beta1/projects.locations.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The parent (project and location) where the cluster will be created.
	// Specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{35}
}

// Deprecated: Do not use.
func (x *CreateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CreateClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to retrieve.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{36}
}

// Deprecated: Do not use.
func (x *GetClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{37}
}

// Deprecated: Do not use.
func (x *UpdateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *UpdateClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetNodePoolVersionRequest updates the version of a node pool.
type UpdateNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	NodeVersion string `protobuf:"bytes,5,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Required. The desired image type for the node pool.
	ImageType string `protobuf:"bytes,6,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// node pool's nodes should be located. Changing the locations for a node pool
	// will result in nodes being either created or removed from the node pool,
	// depending on whether locations are being added or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// The desired workload metadata config for the node pool.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to
	// update. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	// Upgrade settings control disruption and speed of the upgrade.
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,15,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
	// Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,19,opt,name=linux_node_config,json=linuxNodeConfig,proto3" json:"linux_node_config,omitempty"`
	// Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `protobuf:"bytes,20,opt,name=kubelet_config,json=kubeletConfig,proto3" json:"kubelet_config,omitempty"`
}

func (x *UpdateNodePoolRequest) Reset() {
	*x = UpdateNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNodePoolRequest) ProtoMessage() {}

func (x *UpdateNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNodePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{38}
}

// Deprecated: Do not use.
func (x *UpdateNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetNodeVersion() string {
	if x != nil {
		return x.NodeVersion
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if x != nil {
		return x.WorkloadMetadataConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.LinuxNodeConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.KubeletConfig
	}
	return nil
}

// SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,5,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to set
	// autoscaler settings. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolAutoscalingRequest) Reset() {
	*x = SetNodePoolAutoscalingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetNodePoolAutoscalingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolAutoscalingRequest) ProtoMessage() {}

func (x *SetNodePoolAutoscalingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolAutoscalingRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolAutoscalingRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{39}
}

// Deprecated: Do not use.
func (x *SetNodePoolAutoscalingRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolAutoscalingRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolAutoscalingRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolAutoscalingRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolAutoscalingRequest) GetAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *SetNodePoolAutoscalingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLoggingServiceRequest sets the logging service of a cluster.
type SetLoggingServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	// * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//   available as of GKE 1.15).
	// * `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	LoggingService string `protobuf:"bytes,4,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLoggingServiceRequest) Reset() {
	*x = SetLoggingServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetLoggingServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLoggingServiceRequest) ProtoMessage() {}

func (x *SetLoggingServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLoggingServiceRequest.ProtoReflect.Descriptor instead.
func (*SetLoggingServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{40}
}

// Deprecated: Do not use.
func (x *SetLoggingServiceRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLoggingServiceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLoggingServiceRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLoggingServiceRequest) GetLoggingService() string {
	if x != nil {
		return x.LoggingService
	}
	return ""
}

func (x *SetLoggingServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMonitoringServiceRequest sets the monitoring service of a cluster.
type SetMonitoringServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	// * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//   longer available as of GKE 1.15).
	// * `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `protobuf:"bytes,4,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set monitoring.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMonitoringServiceRequest) Reset() {
	*x = SetMonitoringServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMonitoringServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMonitoringServiceRequest) ProtoMessage() {}

func (x *SetMonitoringServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMonitoringServiceRequest.ProtoReflect.Descriptor instead.
func (*SetMonitoringServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{41}
}

// Deprecated: Do not use.
func (x *SetMonitoringServiceRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetMonitoringServiceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetMonitoringServiceRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMonitoringServiceRequest) GetMonitoringService() string {
	if x != nil {
		return x.MonitoringService
	}
	return ""
}

func (x *SetMonitoringServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetAddonsRequest sets the addons associated with the cluster.
type SetAddonsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The desired configurations for the various addons available to run in the
	// cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,4,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetAddonsConfigRequest) Reset() {
	*x = SetAddonsConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetAddonsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAddonsConfigRequest) ProtoMessage() {}

func (x *SetAddonsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAddonsConfigRequest.ProtoReflect.Descriptor instead.
func (*SetAddonsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{42}
}

// Deprecated: Do not use.
func (x *SetAddonsConfigRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetAddonsConfigRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetAddonsConfigRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetAddonsConfigRequest) GetAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.AddonsConfig
	}
	return nil
}

func (x *SetAddonsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located. Changing the locations a cluster is in
	// will result in nodes being either created or removed from the cluster,
	// depending on whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	Locations []string `protobuf:"bytes,4,rep,name=locations,proto3" json:"locations,omitempty"`
	// The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLocationsRequest) Reset() {
	*x = SetLocationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetLocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLocationsRequest) ProtoMessage() {}

func (x *SetLocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLocationsRequest.ProtoReflect.Descriptor instead.
func (*SetLocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{43}
}

// Deprecated: Do not use.
func (x *SetLocationsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLocationsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLocationsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLocationsRequest) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *SetLocationsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	MasterVersion string `protobuf:"bytes,4,opt,name=master_version,json=masterVersion,proto3" json:"master_version,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateMasterRequest) Reset() {
	*x = UpdateMasterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMasterRequest) ProtoMessage() {}

func (x *UpdateMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMasterRequest.ProtoReflect.Descriptor instead.
func (*UpdateMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{44}
}

// Deprecated: Do not use.
func (x *UpdateMasterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateMasterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *UpdateMasterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *UpdateMasterRequest) GetMasterVersion() string {
	if x != nil {
		return x.MasterVersion
	}
	return ""
}

func (x *UpdateMasterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The exact form of action to be taken on the master auth.
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,proto3,enum=google.container.v1beta1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// Required. A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMasterAuthRequest) Reset() {
	*x = SetMasterAuthRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMasterAuthRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMasterAuthRequest) ProtoMessage() {}

func (x *SetMasterAuthRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMasterAuthRequest.ProtoReflect.Descriptor instead.
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{45}
}

// Deprecated: Do not use.
func (x *SetMasterAuthRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetMasterAuthRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetMasterAuthRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if x != nil {
		return x.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (x *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *SetMasterAuthRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to delete.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to delete.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{46}
}

// Deprecated: Do not use.
func (x *DeleteClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *DeleteClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *DeleteClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides, or "-" for all zones. This field has been deprecated and
	// replaced by the parent field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The parent (project and location) where the clusters will be listed.
	// Specified in the format `projects/*/locations/*`.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{47}
}

// Deprecated: Do not use.
func (x *ListClustersRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *ListClustersRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{48}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetMissingZones() []string {
	if x != nil {
		return x.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to get.
	// Specified in the format `projects/*/locations/*/operations/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOperationRequest) Reset() {
	*x = GetOperationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOperationRequest) ProtoMessage() {}

func (x *GetOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOperationRequest.ProtoReflect.Descriptor instead.
func (*GetOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{49}
}

// Deprecated: Do not use.
func (x *GetOperationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetOperationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetOperationRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *GetOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) to return
	// operations for, or `-` for all zones. This field has been deprecated and
	// replaced by the parent field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The parent (project and location) where the operations will be listed.
	// Specified in the format `projects/*/locations/*`.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListOperationsRequest) Reset() {
	*x = ListOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperationsRequest) ProtoMessage() {}

func (x *ListOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{50}
}

// Deprecated: Do not use.
func (x *ListOperationsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *ListOperationsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ListOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// operation resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to cancel.
	// Specified in the format `projects/*/locations/*/operations/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelOperationRequest) Reset() {
	*x = CancelOperationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelOperationRequest) ProtoMessage() {}

func (x *CancelOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelOperationRequest.ProtoReflect.Descriptor instead.
func (*CancelOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{51}
}

// Deprecated: Do not use.
func (x *CancelOperationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CancelOperationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *CancelOperationRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *CancelOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
}

func (x *ListOperationsResponse) Reset() {
	*x = ListOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperationsResponse) ProtoMessage() {}

func (x *ListOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{52}
}

func (x *ListOperationsResponse) GetOperations() []*Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListOperationsResponse) GetMissingZones() []string {
	if x != nil {
		return x.MissingZones
	}
	return nil
}

// Gets the current Kubernetes Engine service configuration.
type GetServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) to return
	// operations for. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The name (project and location) of the server config to get,
	// specified in the format `projects/*/locations/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServerConfigRequest) Reset() {
	*x = GetServerConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServerConfigRequest) ProtoMessage() {}

func (x *GetServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{53}
}

// Deprecated: Do not use.
func (x *GetServerConfigRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetServerConfigRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *GetServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Kubernetes Engine service configuration.
type ServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion,proto3" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions, in descending order.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions,proto3" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType,proto3" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes,proto3" json:"valid_image_types,omitempty"`
	// List of valid master versions, in descending order.
	ValidMasterVersions []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions,proto3" json:"valid_master_versions,omitempty"`
	// List of release channel configurations.
	Channels []*ServerConfig_ReleaseChannelConfig `protobuf:"bytes,9,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *ServerConfig) Reset() {
	*x = ServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig) ProtoMessage() {}

func (x *ServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{54}
}

func (x *ServerConfig) GetDefaultClusterVersion() string {
	if x != nil {
		return x.DefaultClusterVersion
	}
	return ""
}

func (x *ServerConfig) GetValidNodeVersions() []string {
	if x != nil {
		return x.ValidNodeVersions
	}
	return nil
}

func (x *ServerConfig) GetDefaultImageType() string {
	if x != nil {
		return x.DefaultImageType
	}
	return ""
}

func (x *ServerConfig) GetValidImageTypes() []string {
	if x != nil {
		return x.ValidImageTypes
	}
	return nil
}

func (x *ServerConfig) GetValidMasterVersions() []string {
	if x != nil {
		return x.ValidMasterVersions
	}
	return nil
}

func (x *ServerConfig) GetChannels() []*ServerConfig_ReleaseChannelConfig {
	if x != nil {
		return x.Channels
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool,proto3" json:"node_pool,omitempty"`
	// The parent (project, location, cluster id) where the node pool will be
	// created. Specified in the format
	// `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,6,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateNodePoolRequest) Reset() {
	*x = CreateNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNodePoolRequest) ProtoMessage() {}

func (x *CreateNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNodePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{55}
}

// Deprecated: Do not use.
func (x *CreateNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CreateNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *CreateNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateNodePoolRequest) GetNodePool() *NodePool {
	if x != nil {
		return x.NodePool
	}
	return nil
}

func (x *CreateNodePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to delete.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to
	// delete. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNodePoolRequest) Reset() {
	*x = DeleteNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNodePoolRequest) ProtoMessage() {}

func (x *DeleteNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNodePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{56}
}

// Deprecated: Do not use.
func (x *DeleteNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *DeleteNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *DeleteNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *DeleteNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *DeleteNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The parent (project, location, cluster id) where the node pools will be
	// listed. Specified in the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListNodePoolsRequest) Reset() {
	*x = ListNodePoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodePoolsRequest) ProtoMessage() {}

func (x *ListNodePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{57}
}

// Deprecated: Do not use.
func (x *ListNodePoolsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *ListNodePoolsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *ListNodePoolsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ListNodePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to
	// get. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNodePoolRequest) Reset() {
	*x = GetNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodePoolRequest) ProtoMessage() {}

func (x *GetNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodePoolRequest.ProtoReflect.Descriptor instead.
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{58}
}

// Deprecated: Do not use.
func (x *GetNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *GetNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *GetNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// NodePool's nodes should be located.
	//
	// If this value is unspecified during node pool creation, the
	// [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
	// value will be used, instead.
	//
	// Warning: changing node pool locations will result in nodes being added
	// and/or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The version of the Kubernetes of this node.
	Version string `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	// [Output only] The resource URLs of the [managed instance
	// groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with this node pool.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// [Output only] The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,proto3,enum=google.container.v1beta1.NodePool_Status" json:"status,omitempty"`
	// [Output only] Deprecated. Use conditions instead.
	// Additional information about the current status of this
	// node pool instance, if available.
	//
	// Deprecated: Do not use.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,6,opt,name=max_pods_constraint,json=maxPodsConstraint,proto3" json:"max_pods_constraint,omitempty"`
	// Which conditions caused the current node pool state.
	Conditions []*StatusCondition `protobuf:"bytes,105,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// [Output only] The pod CIDR block size per node in this node pool.
	PodIpv4CidrSize int32 `protobuf:"varint,7,opt,name=pod_ipv4_cidr_size,json=podIpv4CidrSize,proto3" json:"pod_ipv4_cidr_size,omitempty"`
	// Upgrade settings control disruption and speed of the upgrade.
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,107,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
}

func (x *NodePool) Reset() {
	*x = NodePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool) ProtoMessage() {}

func (x *NodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool.ProtoReflect.Descriptor instead.
func (*NodePool) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{59}
}

func (x *NodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodePool) GetConfig() *NodeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *NodePool) GetInitialNodeCount() int32 {
	if x != nil {
		return x.InitialNodeCount
	}
	return 0
}

func (x *NodePool) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *NodePool) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *NodePool) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *NodePool) GetInstanceGroupUrls() []string {
	if x != nil {
		return x.InstanceGroupUrls
	}
	return nil
}

func (x *NodePool) GetStatus() NodePool_Status {
	if x != nil {
		return x.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *NodePool) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *NodePool) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *NodePool) GetMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.MaxPodsConstraint
	}
	return nil
}

func (x *NodePool) GetConditions() []*StatusCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *NodePool) GetPodIpv4CidrSize() int32 {
	if x != nil {
		return x.PodIpv4CidrSize
	}
	return 0
}

func (x *NodePool) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the nodes will be automatically upgraded.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// Whether the nodes will be automatically repaired.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions,proto3" json:"upgrade_options,omitempty"`
}

func (x *NodeManagement) Reset() {
	*x = NodeManagement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeManagement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeManagement) ProtoMessage() {}

func (x *NodeManagement) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeManagement.ProtoReflect.Descriptor instead.
func (*NodeManagement) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{60}
}

func (x *NodeManagement) GetAutoUpgrade() bool {
	if x != nil {
		return x.AutoUpgrade
	}
	return false
}

func (x *NodeManagement) GetAutoRepair() bool {
	if x != nil {
		return x.AutoRepair
	}
	return false
}

func (x *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if x != nil {
		return x.UpgradeOptions
	}
	return nil
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output only] This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime,proto3" json:"auto_upgrade_start_time,omitempty"`
	// [Output only] This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *AutoUpgradeOptions) Reset() {
	*x = AutoUpgradeOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoUpgradeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoUpgradeOptions) ProtoMessage() {}

func (x *AutoUpgradeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoUpgradeOptions.ProtoReflect.Descriptor instead.
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{61}
}

func (x *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if x != nil {
		return x.AutoUpgradeStartTime
	}
	return ""
}

func (x *AutoUpgradeOptions) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// MaintenancePolicy defines the maintenance policy to be used for the cluster.
type MaintenancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the maintenance window in which maintenance may be performed.
	Window *MaintenanceWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// A hash identifying the version of this policy, so that updates to fields of
	// the policy won't accidentally undo intermediate changes (and so that users
	// of the API unaware of some fields won't accidentally remove other fields).
	// Make a `get()` request to the cluster to get the current
	// resource version and include it with requests to set the policy.
	ResourceVersion string `protobuf:"bytes,3,opt,name=resource_version,json=resourceVersion,proto3" json:"resource_version,omitempty"`
}

func (x *MaintenancePolicy) Reset() {
	*x = MaintenancePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenancePolicy) ProtoMessage() {}

func (x *MaintenancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenancePolicy.ProtoReflect.Descriptor instead.
func (*MaintenancePolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{62}
}

func (x *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *MaintenancePolicy) GetResourceVersion() string {
	if x != nil {
		return x.ResourceVersion
	}
	return ""
}

// MaintenanceWindow defines the maintenance window to be used for the cluster.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unimplemented, reserved for future use.
	// HourlyMaintenanceWindow hourly_maintenance_window = 1;
	//
	// Types that are assignable to Policy:
	//	*MaintenanceWindow_DailyMaintenanceWindow
	//	*MaintenanceWindow_RecurringWindow
	Policy isMaintenanceWindow_Policy `protobuf_oneof:"policy"`
	// Exceptions to maintenance window. Non-emergency maintenance should not
	// occur in these windows.
	MaintenanceExclusions map[string]*TimeWindow `protobuf:"bytes,4,rep,name=maintenance_exclusions,json=maintenanceExclusions,proto3" json:"maintenance_exclusions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{63}
}

func (m *MaintenanceWindow) GetPolicy() isMaintenanceWindow_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *MaintenanceWindow) GetDailyMaintenanceWindow() *DailyMaintenanceWindow {
	if x, ok := x.GetPolicy().(*MaintenanceWindow_DailyMaintenanceWindow); ok {
		return x.DailyMaintenanceWindow
	}
	return nil
}

func (x *MaintenanceWindow) GetRecurringWindow() *RecurringTimeWindow {
	if x, ok := x.GetPolicy().(*MaintenanceWindow_RecurringWindow); ok {
		return x.RecurringWindow
	}
	return nil
}

func (x *MaintenanceWindow) GetMaintenanceExclusions() map[string]*TimeWindow {
	if x != nil {
		return x.MaintenanceExclusions
	}
	return nil
}

type isMaintenanceWindow_Policy interface {
	isMaintenanceWindow_Policy()
}

type MaintenanceWindow_DailyMaintenanceWindow struct {
	// DailyMaintenanceWindow specifies a daily maintenance operation window.
	DailyMaintenanceWindow *DailyMaintenanceWindow `protobuf:"bytes,2,opt,name=daily_maintenance_window,json=dailyMaintenanceWindow,proto3,oneof"`
}

type MaintenanceWindow_RecurringWindow struct {
	// RecurringWindow specifies some number of recurring time periods for
	// maintenance to occur. The time windows may be overlapping. If no
	// maintenance windows are set, maintenance can occur at any time.
	RecurringWindow *RecurringTimeWindow `protobuf:"bytes,3,opt,name=recurring_window,json=recurringWindow,proto3,oneof"`
}

func (*MaintenanceWindow_DailyMaintenanceWindow) isMaintenanceWindow_Policy() {}

func (*MaintenanceWindow_RecurringWindow) isMaintenanceWindow_Policy() {}

// Represents an arbitrary window of time.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the window first starts.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time that the window ends. The end time should take place after the
	// start time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{64}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Represents an arbitrary window of time that recurs.
type RecurringTimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The window of the first recurrence.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
	// this window reccurs. They go on for the span of time between the start and
	// end time.
	//
	// For example, to have something repeat every weekday, you'd use:
	// `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR`
	//
	// To repeat some window daily (equivalent to the DailyMaintenanceWindow):
	// `FREQ=DAILY`
	//
	// For the first weekend of every month:
	// `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU`
	//
	// This specifies how frequently the window starts. Eg, if you wanted to have
	// a 9-5 UTC-4 window every weekday, you'd use something like:
	// ```
	// start time = 2019-01-01T09:00:00-0400
	// end time = 2019-01-01T17:00:00-0400
	// recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
	// ```
	//
	// Windows can span multiple days. Eg, to make the window encompass every
	// weekend from midnight Saturday till the last minute of Sunday UTC:
	// ```
	// start time = 2019-01-05T00:00:00Z
	// end time = 2019-01-07T23:59:00Z
	// recurrence = FREQ=WEEKLY;BYDAY=SA
	// ```
	//
	// Note the start and end time's specific dates are largely arbitrary except
	// to specify duration of the window and when it first starts.
	// The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
	Recurrence string `protobuf:"bytes,2,opt,name=recurrence,proto3" json:"recurrence,omitempty"`
}

func (x *RecurringTimeWindow) Reset() {
	*x = RecurringTimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecurringTimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecurringTimeWindow) ProtoMessage() {}

func (x *RecurringTimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecurringTimeWindow.ProtoReflect.Descriptor instead.
func (*RecurringTimeWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{65}
}

func (x *RecurringTimeWindow) GetWindow() *TimeWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *RecurringTimeWindow) GetRecurrence() string {
	if x != nil {
		return x.Recurrence
	}
	return ""
}

// Time window specified for daily maintenance operations.
type DailyMaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time within the maintenance window to start the maintenance operations.
	// It must be in format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
	StartTime string `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// [Output only] Duration of the time window, automatically chosen to be
	// smallest possible in the given scenario.
	Duration string `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *DailyMaintenanceWindow) Reset() {
	*x = DailyMaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyMaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyMaintenanceWindow) ProtoMessage() {}

func (x *DailyMaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyMaintenanceWindow.ProtoReflect.Descriptor instead.
func (*DailyMaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{66}
}

func (x *DailyMaintenanceWindow) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *DailyMaintenanceWindow) GetDuration() string {
	if x != nil {
		return x.Duration
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// management properties. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolManagementRequest) Reset() {
	*x = SetNodePoolManagementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetNodePoolManagementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolManagementRequest) ProtoMessage() {}

func (x *SetNodePoolManagementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolManagementRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{67}
}

// Deprecated: Do not use.
func (x *SetNodePoolManagementRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolManagementRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolManagementRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolManagementRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *SetNodePoolManagementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetNodePoolSizeRequest sets the size a node
// pool.
type SetNodePoolSizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. The desired node count for the pool.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// size.
	// Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolSizeRequest) Reset() {
	*x = SetNodePoolSizeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetNodePoolSizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolSizeRequest) ProtoMessage() {}

func (x *SetNodePoolSizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolSizeRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolSizeRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{68}
}

// Deprecated: Do not use.
func (x *SetNodePoolSizeRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolSizeRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolSizeRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNodePoolSizeRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolSizeRequest) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *SetNodePoolSizeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to rollback.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Deprecated. The name of the node pool to rollback.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node poll to
	// rollback upgrade.
	// Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RollbackNodePoolUpgradeRequest) Reset() {
	*x = RollbackNodePoolUpgradeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackNodePoolUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackNodePoolUpgradeRequest) ProtoMessage() {}

func (x *RollbackNodePoolUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackNodePoolUpgradeRequest.ProtoReflect.Descriptor instead.
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{69}
}

// Deprecated: Do not use.
func (x *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *RollbackNodePoolUpgradeRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Do not use.
func (x *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *RollbackNodePoolUpgradeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of node pools for a cluster.
	NodePools []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
}

func (x *ListNodePoolsResponse) Reset() {
	*x = ListNodePoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodePoolsResponse) ProtoMessage() {}

func (x *ListNodePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{70}
}

func (x *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if x != nil {
		return x.NodePools
	}
	return nil
}

// ClusterAutoscaling contains global, per-cluster information
// required by Cluster Autoscaler to automatically adjust
// the size of the cluster and create/delete
// node pools based on the current needs.
type ClusterAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables automatic node pool creation and deletion.
	EnableNodeAutoprovisioning bool `protobuf:"varint,1,opt,name=enable_node_autoprovisioning,json=enableNodeAutoprovisioning,proto3" json:"enable_node_autoprovisioning,omitempty"`
	// Contains global constraints regarding minimum and maximum
	// amount of resources in the cluster.
	ResourceLimits []*ResourceLimit `protobuf:"bytes,2,rep,name=resource_limits,json=resourceLimits,proto3" json:"resource_limits,omitempty"`
	// Defines autoscaling behaviour.
	AutoscalingProfile ClusterAutoscaling_AutoscalingProfile `protobuf:"varint,3,opt,name=autoscaling_profile,json=autoscalingProfile,proto3,enum=google.container.v1beta1.ClusterAutoscaling_AutoscalingProfile" json:"autoscaling_profile,omitempty"`
	// AutoprovisioningNodePoolDefaults contains defaults for a node pool
	// created by NAP.
	AutoprovisioningNodePoolDefaults *AutoprovisioningNodePoolDefaults `protobuf:"bytes,4,opt,name=autoprovisioning_node_pool_defaults,json=autoprovisioningNodePoolDefaults,proto3" json:"autoprovisioning_node_pool_defaults,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// NodePool's nodes can be created by NAP.
	AutoprovisioningLocations []string `protobuf:"bytes,5,rep,name=autoprovisioning_locations,json=autoprovisioningLocations,proto3" json:"autoprovisioning_locations,omitempty"`
}

func (x *ClusterAutoscaling) Reset() {
	*x = ClusterAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterAutoscaling) ProtoMessage() {}

func (x *ClusterAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterAutoscaling.ProtoReflect.Descriptor instead.
func (*ClusterAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{71}
}

func (x *ClusterAutoscaling) GetEnableNodeAutoprovisioning() bool {
	if x != nil {
		return x.EnableNodeAutoprovisioning
	}
	return false
}

func (x *ClusterAutoscaling) GetResourceLimits() []*ResourceLimit {
	if x != nil {
		return x.ResourceLimits
	}
	return nil
}

func (x *ClusterAutoscaling) GetAutoscalingProfile() ClusterAutoscaling_AutoscalingProfile {
	if x != nil {
		return x.AutoscalingProfile
	}
	return ClusterAutoscaling_PROFILE_UNSPECIFIED
}

func (x *ClusterAutoscaling) GetAutoprovisioningNodePoolDefaults() *AutoprovisioningNodePoolDefaults {
	if x != nil {
		return x.AutoprovisioningNodePoolDefaults
	}
	return nil
}

func (x *ClusterAutoscaling) GetAutoprovisioningLocations() []string {
	if x != nil {
		return x.AutoprovisioningLocations
	}
	return nil
}

// AutoprovisioningNodePoolDefaults contains defaults for a node pool created
// by NAP.
type AutoprovisioningNodePoolDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container
	// Registry](https://cloud.google.com/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,1,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs.
	// Specify the email address of the Service Account; otherwise, if no Service
	// Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Upgrade settings control disruption and speed of the upgrade.
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,3,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,4,opt,name=management,proto3" json:"management,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// `minCpuPlatform: "Intel Haswell"` or
	// `minCpuPlatform: "Intel Sandy Bridge"`. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	// To unset the min cpu platform field pass "automatic"
	// as field value.
	MinCpuPlatform string `protobuf:"bytes,5,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,6,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
	// 'pd-balanced')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,7,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,8,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	//
	// The Customer Managed Encryption Key used to encrypt the boot disk attached
	// to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
	// For more information about protecting resources with Cloud KMS Keys please
	// see:
	// https://cloud.google.com/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `protobuf:"bytes,9,opt,name=boot_disk_kms_key,json=bootDiskKmsKey,proto3" json:"boot_disk_kms_key,omitempty"`
	// The image type to use for node created by NodeAutoprovisioning.
	ImageType string `protobuf:"bytes,10,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
}

func (x *AutoprovisioningNodePoolDefaults) Reset() {
	*x = AutoprovisioningNodePoolDefaults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoprovisioningNodePoolDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoprovisioningNodePoolDefaults) ProtoMessage() {}

func (x *AutoprovisioningNodePoolDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoprovisioningNodePoolDefaults.ProtoReflect.Descriptor instead.
func (*AutoprovisioningNodePoolDefaults) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{72}
}

func (x *AutoprovisioningNodePoolDefaults) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *AutoprovisioningNodePoolDefaults) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetBootDiskKmsKey() string {
	if x != nil {
		return x.BootDiskKmsKey
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

// Contains information about amount of some resource in the cluster.
// For memory, value should be in GB.
type ResourceLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name "cpu", "memory" or gpu-specific string.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Minimum amount of the resource in the cluster.
	Minimum int64 `protobuf:"varint,2,opt,name=minimum,proto3" json:"minimum,omitempty"`
	// Maximum amount of the resource in the cluster.
	Maximum int64 `protobuf:"varint,3,opt,name=maximum,proto3" json:"maximum,omitempty"`
}

func (x *ResourceLimit) Reset() {
	*x = ResourceLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceLimit) ProtoMessage() {}

func (x *ResourceLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceLimit.ProtoReflect.Descriptor instead.
func (*ResourceLimit) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{73}
}

func (x *ResourceLimit) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *ResourceLimit) GetMinimum() int64 {
	if x != nil {
		return x.Minimum
	}
	return 0
}

func (x *ResourceLimit) GetMaximum() int64 {
	if x != nil {
		return x.Maximum
	}
	return 0
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum number of nodes in the NodePool. Must be >= 1 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the NodePool. Must be >= min_node_count. There
	// has to enough quota to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
	// Can this node pool be deleted automatically.
	Autoprovisioned bool `protobuf:"varint,4,opt,name=autoprovisioned,proto3" json:"autoprovisioned,omitempty"`
}

func (x *NodePoolAutoscaling) Reset() {
	*x = NodePoolAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePoolAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePoolAutoscaling) ProtoMessage() {}

func (x *NodePoolAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePoolAutoscaling.ProtoReflect.Descriptor instead.
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{74}
}

func (x *NodePoolAutoscaling) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

func (x *NodePoolAutoscaling) GetAutoprovisioned() bool {
	if x != nil {
		return x.Autoprovisioned
	}
	return false
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Kubernetes Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a `get()` request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// The name (project, location, cluster id) of the cluster to set labels.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLabelsRequest) Reset() {
	*x = SetLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLabelsRequest) ProtoMessage() {}

func (x *SetLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLabelsRequest.ProtoReflect.Descriptor instead.
func (*SetLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{75}
}

// Deprecated: Do not use.
func (x *SetLabelsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLabelsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLabelsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLabelsRequest) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *SetLabelsRequest) GetLabelFingerprint() string {
	if x != nil {
		return x.LabelFingerprint
	}
	return ""
}

func (x *SetLabelsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name (project, location, cluster id) of the cluster to set legacy abac.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLegacyAbacRequest) Reset() {
	*x = SetLegacyAbacRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetLegacyAbacRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLegacyAbacRequest) ProtoMessage() {}

func (x *SetLegacyAbacRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLegacyAbacRequest.ProtoReflect.Descriptor instead.
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{76}
}

// Deprecated: Do not use.
func (x *SetLegacyAbacRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLegacyAbacRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetLegacyAbacRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLegacyAbacRequest) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SetLegacyAbacRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster id) of the cluster to start IP
	// rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to rotate credentials during IP rotation.
	RotateCredentials bool `protobuf:"varint,7,opt,name=rotate_credentials,json=rotateCredentials,proto3" json:"rotate_credentials,omitempty"`
}

func (x *StartIPRotationRequest) Reset() {
	*x = StartIPRotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartIPRotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartIPRotationRequest) ProtoMessage() {}

func (x *StartIPRotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartIPRotationRequest.ProtoReflect.Descriptor instead.
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{77}
}

// Deprecated: Do not use.
func (x *StartIPRotationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *StartIPRotationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *StartIPRotationRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *StartIPRotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartIPRotationRequest) GetRotateCredentials() bool {
	if x != nil {
		return x.RotateCredentials
	}
	return false
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster id) of the cluster to complete IP
	// rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteIPRotationRequest) Reset() {
	*x = CompleteIPRotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteIPRotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteIPRotationRequest) ProtoMessage() {}

func (x *CompleteIPRotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteIPRotationRequest.ProtoReflect.Descriptor instead.
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{78}
}

// Deprecated: Do not use.
func (x *CompleteIPRotationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *CompleteIPRotationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *CompleteIPRotationRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CompleteIPRotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AcceleratorConfig represents a Hardware Accelerator request.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	// The accelerator type resource name. List of supported accelerators
	// [here](https://cloud.google.com/compute/docs/gpus)
	AcceleratorType string `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{79}
}

func (x *AcceleratorConfig) GetAcceleratorCount() int64 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

func (x *AcceleratorConfig) GetAcceleratorType() string {
	if x != nil {
		return x.AcceleratorType
	}
	return ""
}

// WorkloadMetadataConfig defines the metadata configuration to expose to
// workloads on the node pool.
type WorkloadMetadataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// NodeMetadata is the configuration for how to expose metadata to the
	// workloads running on the node.
	//
	// Deprecated: Do not use.
	NodeMetadata WorkloadMetadataConfig_NodeMetadata `protobuf:"varint,1,opt,name=node_metadata,json=nodeMetadata,proto3,enum=google.container.v1beta1.WorkloadMetadataConfig_NodeMetadata" json:"node_metadata,omitempty"`
	// Mode is the configuration for how to expose metadata to workloads running
	// on the node pool.
	Mode WorkloadMetadataConfig_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.container.v1beta1.WorkloadMetadataConfig_Mode" json:"mode,omitempty"`
}

func (x *WorkloadMetadataConfig) Reset() {
	*x = WorkloadMetadataConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadMetadataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadMetadataConfig) ProtoMessage() {}

func (x *WorkloadMetadataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadMetadataConfig.ProtoReflect.Descriptor instead.
func (*WorkloadMetadataConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{80}
}

// Deprecated: Do not use.
func (x *WorkloadMetadataConfig) GetNodeMetadata() WorkloadMetadataConfig_NodeMetadata {
	if x != nil {
		return x.NodeMetadata
	}
	return WorkloadMetadataConfig_UNSPECIFIED
}

func (x *WorkloadMetadataConfig) GetMode() WorkloadMetadataConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return WorkloadMetadataConfig_MODE_UNSPECIFIED
}

// SetNetworkPolicyRequest enables/disables network policy for a cluster.
type SetNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Deprecated. The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Do not use.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Do not use.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set networking
	// policy. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNetworkPolicyRequest) Reset() {
	*x = SetNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNetworkPolicyRequest) ProtoMessage() {}

func (x *SetNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*SetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{81}
}

// Deprecated: Do not use.
func (x *SetNetworkPolicyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNetworkPolicyRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Do not use.
func (x *SetNetworkPolicyRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *SetNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The maintenance policy to be set for the cluster. An empty field
	// clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,4,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// The name (project, location, cluster id) of the cluster to set maintenance
	// policy.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMaintenancePolicyRequest) Reset() {
	*x = SetMaintenancePolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMaintenancePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMaintenancePolicyRequest) ProtoMessage() {}

func (x *SetMaintenancePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMaintenancePolicyRequest.ProtoReflect.Descriptor instead.
func (*SetMaintenancePolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{82}
}

func (x *SetMaintenancePolicyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetMaintenancePolicy() *MaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *SetMaintenancePolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListLocationsRequest is used to request the locations that offer GKE.
type ListLocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Contains the name of the resource requested.
	// Specified in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListLocationsRequest) Reset() {
	*x = ListLocationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLocationsRequest) ProtoMessage() {}

func (x *ListLocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLocationsRequest.ProtoReflect.Descriptor instead.
func (*ListLocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{83}
}

func (x *ListLocationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// ListLocationsResponse returns the list of all GKE locations and their
// recommendation state.
type ListLocationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A full list of GKE locations.
	Locations []*Location `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	// Only return ListLocationsResponse that occur after the page_token. This
	// value should be populated from the ListLocationsResponse.next_page_token if
	// that response token was set (which happens when listing more Locations than
	// fit in a single ListLocationsResponse).
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLocationsResponse) Reset() {
	*x = ListLocationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLocationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLocationsResponse) ProtoMessage() {}

func (x *ListLocationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLocationsResponse.ProtoReflect.Descriptor instead.
func (*ListLocationsResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{84}
}

func (x *ListLocationsResponse) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *ListLocationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Location returns the location name, and if the location is recommended
// for GKE cluster scheduling.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the type of location this Location is for.
	// Regional or Zonal.
	Type Location_LocationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.container.v1beta1.Location_LocationType" json:"type,omitempty"`
	// Contains the name of the resource requested.
	// Specified in the format `projects/*/locations/*`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Whether the location is recomended for GKE cluster scheduling.
	Recommended bool `protobuf:"varint,3,opt,name=recommended,proto3" json:"recommended,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{85}
}

func (x *Location) GetType() Location_LocationType {
	if x != nil {
		return x.Type
	}
	return Location_LOCATION_TYPE_UNSPECIFIED
}

func (x *Location) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Location) GetRecommended() bool {
	if x != nil {
		return x.Recommended
	}
	return false
}

// StatusCondition describes why a cluster or a node pool has a certain status
// (e.g., ERROR or DEGRADED).
type StatusCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Machine-friendly representation of the condition
	// Deprecated. Use canonical_code instead.
	//
	// Deprecated: Do not use.
	Code StatusCondition_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.container.v1beta1.StatusCondition_Code" json:"code,omitempty"`
	// Human-friendly representation of the condition
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Canonical code of the condition.
	CanonicalCode code.Code `protobuf:"varint,3,opt,name=canonical_code,json=canonicalCode,proto3,enum=google.rpc.Code" json:"canonical_code,omitempty"`
}

func (x *StatusCondition) Reset() {
	*x = StatusCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusCondition) ProtoMessage() {}

func (x *StatusCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusCondition.ProtoReflect.Descriptor instead.
func (*StatusCondition) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{86}
}

// Deprecated: Do not use.
func (x *StatusCondition) GetCode() StatusCondition_Code {
	if x != nil {
		return x.Code
	}
	return StatusCondition_UNKNOWN
}

func (x *StatusCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *StatusCondition) GetCanonicalCode() code.Code {
	if x != nil {
		return x.CanonicalCode
	}
	return code.Code(0)
}

// NetworkConfig reports the relative names of network & subnetwork.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative name of the Google Compute Engine
	// [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. Example:
	// projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The relative name of the Google Compute Engine
	// [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
	// cluster is connected. Example:
	// projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Whether Intra-node visibility is enabled for this cluster.
	// This makes same node pod to pod traffic visible for VPC network.
	EnableIntraNodeVisibility bool `protobuf:"varint,5,opt,name=enable_intra_node_visibility,json=enableIntraNodeVisibility,proto3" json:"enable_intra_node_visibility,omitempty"`
	// Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
	// will be disabled when default_snat_status is disabled. When disabled is set
	// to false, default IP masquerade rules will be applied to the nodes to
	// prevent sNAT on cluster internal traffic.
	DefaultSnatStatus *DefaultSnatStatus `protobuf:"bytes,7,opt,name=default_snat_status,json=defaultSnatStatus,proto3" json:"default_snat_status,omitempty"`
	// The desired datapath provider for this cluster. By default, uses the
	// IPTables-based kube-proxy implementation.
	DatapathProvider DatapathProvider `protobuf:"varint,11,opt,name=datapath_provider,json=datapathProvider,proto3,enum=google.container.v1beta1.DatapathProvider" json:"datapath_provider,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{87}
}

func (x *NetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkConfig) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *NetworkConfig) GetEnableIntraNodeVisibility() bool {
	if x != nil {
		return x.EnableIntraNodeVisibility
	}
	return false
}

func (x *NetworkConfig) GetDefaultSnatStatus() *DefaultSnatStatus {
	if x != nil {
		return x.DefaultSnatStatus
	}
	return nil
}

func (x *NetworkConfig) GetDatapathProvider() DatapathProvider {
	if x != nil {
		return x.DatapathProvider
	}
	return DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED
}

// ListUsableSubnetworksRequest requests the list of usable subnetworks.
// available to a user for creating clusters.
type ListUsableSubnetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project where subnetworks are usable.
	// Specified in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filtering currently only supports equality on the networkProjectId and must
	// be in the form: "networkProjectId=[PROJECTID]", where `networkProjectId`
	// is the project which owns the listed subnetworks. This defaults to the
	// parent project ID.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The max number of results per page that should be returned. If the number
	// of available results is larger than `page_size`, a `next_page_token` is
	// returned which can be used to get the next page of results in subsequent
	// requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set this to the nextPageToken returned by
	// previous list requests to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUsableSubnetworksRequest) Reset() {
	*x = ListUsableSubnetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableSubnetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableSubnetworksRequest) ProtoMessage() {}

func (x *ListUsableSubnetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableSubnetworksRequest.ProtoReflect.Descriptor instead.
func (*ListUsableSubnetworksRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{88}
}

func (x *ListUsableSubnetworksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUsableSubnetworksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListUsableSubnetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsableSubnetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// ListUsableSubnetworksResponse is the response of
// ListUsableSubnetworksRequest.
type ListUsableSubnetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of usable subnetworks in the specified network project.
	Subnetworks []*UsableSubnetwork `protobuf:"bytes,1,rep,name=subnetworks,proto3" json:"subnetworks,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `page_size`, use the
	// `next_page_token` as a value for the query parameter `page_token` in the
	// next request. The value will become empty when there are no more pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListUsableSubnetworksResponse) Reset() {
	*x = ListUsableSubnetworksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableSubnetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableSubnetworksResponse) ProtoMessage() {}

func (x *ListUsableSubnetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableSubnetworksResponse.ProtoReflect.Descriptor instead.
func (*ListUsableSubnetworksResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{89}
}

func (x *ListUsableSubnetworksResponse) GetSubnetworks() []*UsableSubnetwork {
	if x != nil {
		return x.Subnetworks
	}
	return nil
}

func (x *ListUsableSubnetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Secondary IP range of a usable subnetwork.
type UsableSubnetworkSecondaryRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name associated with this subnetwork secondary range, used when adding
	// an alias IP range to a VM instance.
	RangeName string `protobuf:"bytes,1,opt,name=range_name,json=rangeName,proto3" json:"range_name,omitempty"`
	// The range of IP addresses belonging to this subnetwork secondary range.
	IpCidrRange string `protobuf:"bytes,2,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// This field is to determine the status of the secondary range programmably.
	Status UsableSubnetworkSecondaryRange_Status `protobuf:"varint,3,opt,name=status,proto3,enum=google.container.v1beta1.UsableSubnetworkSecondaryRange_Status" json:"status,omitempty"`
}

func (x *UsableSubnetworkSecondaryRange) Reset() {
	*x = UsableSubnetworkSecondaryRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsableSubnetworkSecondaryRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsableSubnetworkSecondaryRange) ProtoMessage() {}

func (x *UsableSubnetworkSecondaryRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsableSubnetworkSecondaryRange.ProtoReflect.Descriptor instead.
func (*UsableSubnetworkSecondaryRange) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{90}
}

func (x *UsableSubnetworkSecondaryRange) GetRangeName() string {
	if x != nil {
		return x.RangeName
	}
	return ""
}

func (x *UsableSubnetworkSecondaryRange) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *UsableSubnetworkSecondaryRange) GetStatus() UsableSubnetworkSecondaryRange_Status {
	if x != nil {
		return x.Status
	}
	return UsableSubnetworkSecondaryRange_UNKNOWN
}

// UsableSubnetwork resource returns the subnetwork name, its associated network
// and the primary CIDR range.
type UsableSubnetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subnetwork Name.
	// Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,1,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Network Name.
	// Example: projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// The range of internal addresses that are owned by this subnetwork.
	IpCidrRange string `protobuf:"bytes,3,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// Secondary IP ranges.
	SecondaryIpRanges []*UsableSubnetworkSecondaryRange `protobuf:"bytes,4,rep,name=secondary_ip_ranges,json=secondaryIpRanges,proto3" json:"secondary_ip_ranges,omitempty"`
	// A human readable status message representing the reasons for cases where
	// the caller cannot use the secondary ranges under the subnet. For example if
	// the secondary_ip_ranges is empty due to a permission issue, an insufficient
	// permission message will be given by status_message.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
}

func (x *UsableSubnetwork) Reset() {
	*x = UsableSubnetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsableSubnetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsableSubnetwork) ProtoMessage() {}

func (x *UsableSubnetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsableSubnetwork.ProtoReflect.Descriptor instead.
func (*UsableSubnetwork) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{91}
}

func (x *UsableSubnetwork) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *UsableSubnetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *UsableSubnetwork) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *UsableSubnetwork) GetSecondaryIpRanges() []*UsableSubnetworkSecondaryRange {
	if x != nil {
		return x.SecondaryIpRanges
	}
	return nil
}

func (x *UsableSubnetwork) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

// VerticalPodAutoscaling contains global, per-cluster information
// required by Vertical Pod Autoscaler to automatically adjust
// the resources of pods controlled by it.
type VerticalPodAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables vertical pod autoscaling.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *VerticalPodAutoscaling) Reset() {
	*x = VerticalPodAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerticalPodAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerticalPodAutoscaling) ProtoMessage() {}

func (x *VerticalPodAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerticalPodAutoscaling.ProtoReflect.Descriptor instead.
func (*VerticalPodAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{92}
}

func (x *VerticalPodAutoscaling) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// DefaultSnatStatus contains the desired state of whether default sNAT should
// be disabled on the cluster.
type DefaultSnatStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disables cluster default sNAT rules.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *DefaultSnatStatus) Reset() {
	*x = DefaultSnatStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultSnatStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultSnatStatus) ProtoMessage() {}

func (x *DefaultSnatStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultSnatStatus.ProtoReflect.Descriptor instead.
func (*DefaultSnatStatus) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{93}
}

func (x *DefaultSnatStatus) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// IntraNodeVisibilityConfig contains the desired config of the intra-node
// visibility on this cluster.
type IntraNodeVisibilityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables intra node visibility for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *IntraNodeVisibilityConfig) Reset() {
	*x = IntraNodeVisibilityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntraNodeVisibilityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntraNodeVisibilityConfig) ProtoMessage() {}

func (x *IntraNodeVisibilityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntraNodeVisibilityConfig.ProtoReflect.Descriptor instead.
func (*IntraNodeVisibilityConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{94}
}

func (x *IntraNodeVisibilityConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Constraints applied to pods.
type MaxPodsConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Constraint enforced on the max num of pods per node.
	MaxPodsPerNode int64 `protobuf:"varint,1,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3" json:"max_pods_per_node,omitempty"`
}

func (x *MaxPodsConstraint) Reset() {
	*x = MaxPodsConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaxPodsConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaxPodsConstraint) ProtoMessage() {}

func (x *MaxPodsConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaxPodsConstraint.ProtoReflect.Descriptor instead.
func (*MaxPodsConstraint) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{95}
}

func (x *MaxPodsConstraint) GetMaxPodsPerNode() int64 {
	if x != nil {
		return x.MaxPodsPerNode
	}
	return 0
}

// Configuration for the use of Kubernetes Service Accounts in GCP IAM
// policies.
type WorkloadIdentityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IAM Identity Namespace to attach all Kubernetes Service Accounts to.
	//
	// Deprecated: Do not use.
	IdentityNamespace string `protobuf:"bytes,1,opt,name=identity_namespace,json=identityNamespace,proto3" json:"identity_namespace,omitempty"`
	// The workload pool to attach all Kubernetes service accounts to.
	WorkloadPool string `protobuf:"bytes,2,opt,name=workload_pool,json=workloadPool,proto3" json:"workload_pool,omitempty"`
	// identity provider is the third party identity provider.
	IdentityProvider string `protobuf:"bytes,3,opt,name=identity_provider,json=identityProvider,proto3" json:"identity_provider,omitempty"`
}

func (x *WorkloadIdentityConfig) Reset() {
	*x = WorkloadIdentityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadIdentityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityConfig) ProtoMessage() {}

func (x *WorkloadIdentityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityConfig.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{96}
}

// Deprecated: Do not use.
func (x *WorkloadIdentityConfig) GetIdentityNamespace() string {
	if x != nil {
		return x.IdentityNamespace
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetWorkloadPool() string {
	if x != nil {
		return x.WorkloadPool
	}
	return ""
}

func (x *WorkloadIdentityConfig) GetIdentityProvider() string {
	if x != nil {
		return x.IdentityProvider
	}
	return ""
}

// Configuration of etcd encryption.
type DatabaseEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Denotes the state of etcd encryption.
	State DatabaseEncryption_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.container.v1beta1.DatabaseEncryption_State" json:"state,omitempty"`
	// Name of CloudKMS key to use for the encryption of secrets in etcd.
	// Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
}

func (x *DatabaseEncryption) Reset() {
	*x = DatabaseEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEncryption) ProtoMessage() {}

func (x *DatabaseEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEncryption.ProtoReflect.Descriptor instead.
func (*DatabaseEncryption) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{97}
}

func (x *DatabaseEncryption) GetState() DatabaseEncryption_State {
	if x != nil {
		return x.State
	}
	return DatabaseEncryption_UNKNOWN
}

func (x *DatabaseEncryption) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

// Configuration for exporting cluster resource usages.
type ResourceUsageExportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration to use BigQuery as usage export destination.
	BigqueryDestination *ResourceUsageExportConfig_BigQueryDestination `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
	// Whether to enable network egress metering for this cluster. If enabled, a
	// daemonset will be created in the cluster to meter network egress traffic.
	EnableNetworkEgressMetering bool `protobuf:"varint,2,opt,name=enable_network_egress_metering,json=enableNetworkEgressMetering,proto3" json:"enable_network_egress_metering,omitempty"`
	// Configuration to enable resource consumption metering.
	ConsumptionMeteringConfig *ResourceUsageExportConfig_ConsumptionMeteringConfig `protobuf:"bytes,3,opt,name=consumption_metering_config,json=consumptionMeteringConfig,proto3" json:"consumption_metering_config,omitempty"`
}

func (x *ResourceUsageExportConfig) Reset() {
	*x = ResourceUsageExportConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceUsageExportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig) ProtoMessage() {}

func (x *ResourceUsageExportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{98}
}

func (x *ResourceUsageExportConfig) GetBigqueryDestination() *ResourceUsageExportConfig_BigQueryDestination {
	if x != nil {
		return x.BigqueryDestination
	}
	return nil
}

func (x *ResourceUsageExportConfig) GetEnableNetworkEgressMetering() bool {
	if x != nil {
		return x.EnableNetworkEgressMetering
	}
	return false
}

func (x *ResourceUsageExportConfig) GetConsumptionMeteringConfig() *ResourceUsageExportConfig_ConsumptionMeteringConfig {
	if x != nil {
		return x.ConsumptionMeteringConfig
	}
	return nil
}

// Configuration of Shielded Nodes feature.
type ShieldedNodes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Shielded Nodes features are enabled on all nodes in this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ShieldedNodes) Reset() {
	*x = ShieldedNodes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShieldedNodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedNodes) ProtoMessage() {}

func (x *ShieldedNodes) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedNodes.ProtoReflect.Descriptor instead.
func (*ShieldedNodes) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{99}
}

func (x *ShieldedNodes) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// GetOpenIDConfigRequest gets the OIDC discovery document for the
// cluster. See the OpenID Connect Discovery 1.0 specification for details.
type GetOpenIDConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster (project, location, cluster id) to get the discovery document
	// for. Specified in the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GetOpenIDConfigRequest) Reset() {
	*x = GetOpenIDConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOpenIDConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOpenIDConfigRequest) ProtoMessage() {}

func (x *GetOpenIDConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOpenIDConfigRequest.ProtoReflect.Descriptor instead.
func (*GetOpenIDConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{100}
}

func (x *GetOpenIDConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
// See the OpenID Connect Discovery 1.0 specification for details.
type GetOpenIDConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OIDC Issuer.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// JSON Web Key uri.
	JwksUri string `protobuf:"bytes,2,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// Supported response types.
	ResponseTypesSupported []string `protobuf:"bytes,3,rep,name=response_types_supported,json=responseTypesSupported,proto3" json:"response_types_supported,omitempty"`
	// Supported subject types.
	SubjectTypesSupported []string `protobuf:"bytes,4,rep,name=subject_types_supported,json=subjectTypesSupported,proto3" json:"subject_types_supported,omitempty"`
	// supported ID Token signing Algorithms.
	IdTokenSigningAlgValuesSupported []string `protobuf:"bytes,5,rep,name=id_token_signing_alg_values_supported,json=idTokenSigningAlgValuesSupported,proto3" json:"id_token_signing_alg_values_supported,omitempty"`
	// Supported claims.
	ClaimsSupported []string `protobuf:"bytes,6,rep,name=claims_supported,json=claimsSupported,proto3" json:"claims_supported,omitempty"`
	// Supported grant types.
	GrantTypes []string `protobuf:"bytes,7,rep,name=grant_types,json=grantTypes,proto3" json:"grant_types,omitempty"`
}

func (x *GetOpenIDConfigResponse) Reset() {
	*x = GetOpenIDConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOpenIDConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOpenIDConfigResponse) ProtoMessage() {}

func (x *GetOpenIDConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOpenIDConfigResponse.ProtoReflect.Descriptor instead.
func (*GetOpenIDConfigResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{101}
}

func (x *GetOpenIDConfigResponse) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *GetOpenIDConfigResponse) GetJwksUri() string {
	if x != nil {
		return x.JwksUri
	}
	return ""
}

func (x *GetOpenIDConfigResponse) GetResponseTypesSupported() []string {
	if x != nil {
		return x.ResponseTypesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetSubjectTypesSupported() []string {
	if x != nil {
		return x.SubjectTypesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetIdTokenSigningAlgValuesSupported() []string {
	if x != nil {
		return x.IdTokenSigningAlgValuesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetClaimsSupported() []string {
	if x != nil {
		return x.ClaimsSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetGrantTypes() []string {
	if x != nil {
		return x.GrantTypes
	}
	return nil
}

// GetJSONWebKeysRequest gets the public component of the keys used by the
// cluster to sign token requests. This will be the jwks_uri for the discover
// document returned by getOpenIDConfig. See the OpenID Connect
// Discovery 1.0 specification for details.
type GetJSONWebKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster (project, location, cluster id) to get keys for. Specified in
	// the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GetJSONWebKeysRequest) Reset() {
	*x = GetJSONWebKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJSONWebKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJSONWebKeysRequest) ProtoMessage() {}

func (x *GetJSONWebKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJSONWebKeysRequest.ProtoReflect.Descriptor instead.
func (*GetJSONWebKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{102}
}

func (x *GetJSONWebKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Jwk is a JSON Web Key as specified in RFC 7517
type Jwk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key Type.
	Kty string `protobuf:"bytes,1,opt,name=kty,proto3" json:"kty,omitempty"`
	// Algorithm.
	Alg string `protobuf:"bytes,2,opt,name=alg,proto3" json:"alg,omitempty"`
	// Permitted uses for the public keys.
	Use string `protobuf:"bytes,3,opt,name=use,proto3" json:"use,omitempty"`
	// Key ID.
	Kid string `protobuf:"bytes,4,opt,name=kid,proto3" json:"kid,omitempty"`
	// Used for RSA keys.
	N string `protobuf:"bytes,5,opt,name=n,proto3" json:"n,omitempty"`
	// Used for RSA keys.
	E string `protobuf:"bytes,6,opt,name=e,proto3" json:"e,omitempty"`
	// Used for ECDSA keys.
	X string `protobuf:"bytes,7,opt,name=x,proto3" json:"x,omitempty"`
	// Used for ECDSA keys.
	Y string `protobuf:"bytes,8,opt,name=y,proto3" json:"y,omitempty"`
	// Used for ECDSA keys.
	Crv string `protobuf:"bytes,9,opt,name=crv,proto3" json:"crv,omitempty"`
}

func (x *Jwk) Reset() {
	*x = Jwk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Jwk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Jwk) ProtoMessage() {}

func (x *Jwk) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Jwk.ProtoReflect.Descriptor instead.
func (*Jwk) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{103}
}

func (x *Jwk) GetKty() string {
	if x != nil {
		return x.Kty
	}
	return ""
}

func (x *Jwk) GetAlg() string {
	if x != nil {
		return x.Alg
	}
	return ""
}

func (x *Jwk) GetUse() string {
	if x != nil {
		return x.Use
	}
	return ""
}

func (x *Jwk) GetKid() string {
	if x != nil {
		return x.Kid
	}
	return ""
}

func (x *Jwk) GetN() string {
	if x != nil {
		return x.N
	}
	return ""
}

func (x *Jwk) GetE() string {
	if x != nil {
		return x.E
	}
	return ""
}

func (x *Jwk) GetX() string {
	if x != nil {
		return x.X
	}
	return ""
}

func (x *Jwk) GetY() string {
	if x != nil {
		return x.Y
	}
	return ""
}

func (x *Jwk) GetCrv() string {
	if x != nil {
		return x.Crv
	}
	return ""
}

// GetJSONWebKeysResponse is a valid JSON Web Key Set as specififed in rfc 7517
type GetJSONWebKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public component of the keys used by the cluster to sign token
	// requests.
	Keys []*Jwk `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *GetJSONWebKeysResponse) Reset() {
	*x = GetJSONWebKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJSONWebKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJSONWebKeysResponse) ProtoMessage() {}

func (x *GetJSONWebKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJSONWebKeysResponse.ProtoReflect.Descriptor instead.
func (*GetJSONWebKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{104}
}

func (x *GetJSONWebKeysResponse) GetKeys() []*Jwk {
	if x != nil {
		return x.Keys
	}
	return nil
}

// ReleaseChannel indicates which release channel a cluster is
// subscribed to. Release channels are arranged in order of risk.
//
// When a cluster is subscribed to a release channel, Google maintains
// both the master version and the node version. Node auto-upgrade
// defaults to true and cannot be disabled.
type ReleaseChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// channel specifies which release channel the cluster is subscribed to.
	Channel ReleaseChannel_Channel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.container.v1beta1.ReleaseChannel_Channel" json:"channel,omitempty"`
}

func (x *ReleaseChannel) Reset() {
	*x = ReleaseChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseChannel) ProtoMessage() {}

func (x *ReleaseChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseChannel.ProtoReflect.Descriptor instead.
func (*ReleaseChannel) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{105}
}

func (x *ReleaseChannel) GetChannel() ReleaseChannel_Channel {
	if x != nil {
		return x.Channel
	}
	return ReleaseChannel_UNSPECIFIED
}

// Configuration for Cloud TPU.
type TpuConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud TPU integration is enabled or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Whether to use service networking for Cloud TPU or not.
	UseServiceNetworking bool `protobuf:"varint,2,opt,name=use_service_networking,json=useServiceNetworking,proto3" json:"use_service_networking,omitempty"`
	// IPv4 CIDR block reserved for Cloud TPU in the VPC.
	Ipv4CidrBlock string `protobuf:"bytes,3,opt,name=ipv4_cidr_block,json=ipv4CidrBlock,proto3" json:"ipv4_cidr_block,omitempty"`
}

func (x *TpuConfig) Reset() {
	*x = TpuConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TpuConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TpuConfig) ProtoMessage() {}

func (x *TpuConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TpuConfig.ProtoReflect.Descriptor instead.
func (*TpuConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{106}
}

func (x *TpuConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *TpuConfig) GetUseServiceNetworking() bool {
	if x != nil {
		return x.UseServiceNetworking
	}
	return false
}

func (x *TpuConfig) GetIpv4CidrBlock() string {
	if x != nil {
		return x.Ipv4CidrBlock
	}
	return ""
}

// Master is the configuration for components on master.
type Master struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Master) Reset() {
	*x = Master{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Master) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Master) ProtoMessage() {}

func (x *Master) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Master.ProtoReflect.Descriptor instead.
func (*Master) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{107}
}

// NotificationConfig is the configuration of notifications.
type NotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notification config for Pub/Sub.
	Pubsub *NotificationConfig_PubSub `protobuf:"bytes,1,opt,name=pubsub,proto3" json:"pubsub,omitempty"`
}

func (x *NotificationConfig) Reset() {
	*x = NotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig) ProtoMessage() {}

func (x *NotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig.ProtoReflect.Descriptor instead.
func (*NotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{108}
}

func (x *NotificationConfig) GetPubsub() *NotificationConfig_PubSub {
	if x != nil {
		return x.Pubsub
	}
	return nil
}

// ConfidentialNodes is configuration for the confidential nodes feature, which
// makes nodes run on confidential VMs.
type ConfidentialNodes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Confidential Nodes feature is enabled for all nodes in this
	// cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ConfidentialNodes) Reset() {
	*x = ConfidentialNodes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfidentialNodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialNodes) ProtoMessage() {}

func (x *ConfidentialNodes) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialNodes.ProtoReflect.Descriptor instead.
func (*ConfidentialNodes) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{109}
}

func (x *ConfidentialNodes) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// UpgradeEvent is a notification sent to customers by the cluster server when
// a resource is upgrading.
type UpgradeEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource type that is upgrading.
	ResourceType UpgradeResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=google.container.v1beta1.UpgradeResourceType" json:"resource_type,omitempty"`
	// Required. The operation associated with this upgrade.
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// Required. The time when the operation was started.
	OperationStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=operation_start_time,json=operationStartTime,proto3" json:"operation_start_time,omitempty"`
	// Required. The current version before the upgrade.
	CurrentVersion string `protobuf:"bytes,4,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	// Required. The target version for the upgrade.
	TargetVersion string `protobuf:"bytes,5,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
	// Optional. Optional relative path to the resource. For example in node pool upgrades,
	// the relative path of the node pool.
	Resource string `protobuf:"bytes,6,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *UpgradeEvent) Reset() {
	*x = UpgradeEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeEvent) ProtoMessage() {}

func (x *UpgradeEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeEvent.ProtoReflect.Descriptor instead.
func (*UpgradeEvent) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{110}
}

func (x *UpgradeEvent) GetResourceType() UpgradeResourceType {
	if x != nil {
		return x.ResourceType
	}
	return UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED
}

func (x *UpgradeEvent) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *UpgradeEvent) GetOperationStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.OperationStartTime
	}
	return nil
}

func (x *UpgradeEvent) GetCurrentVersion() string {
	if x != nil {
		return x.CurrentVersion
	}
	return ""
}

func (x *UpgradeEvent) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

func (x *UpgradeEvent) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// display_name is an optional field for users to identify CIDR blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// cidr_block must be specified in CIDR notation.
	CidrBlock string `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*x = MasterAuthorizedNetworksConfig_CidrBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig_CidrBlock.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{23, 0}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if x != nil {
		return x.CidrBlock
	}
	return ""
}

// Progress metric is (string, int|float|string) pair.
type OperationProgress_Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Metric name, e.g., "nodes total", "percent done".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Strictly one of the values is required.
	//
	// Types that are assignable to Value:
	//	*OperationProgress_Metric_IntValue
	//	*OperationProgress_Metric_DoubleValue
	//	*OperationProgress_Metric_StringValue
	Value isOperationProgress_Metric_Value `protobuf_oneof:"value"`
}

func (x *OperationProgress_Metric) Reset() {
	*x = OperationProgress_Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationProgress_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationProgress_Metric) ProtoMessage() {}

func (x *OperationProgress_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationProgress_Metric.ProtoReflect.Descriptor instead.
func (*OperationProgress_Metric) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{34, 0}
}

func (x *OperationProgress_Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *OperationProgress_Metric) GetValue() isOperationProgress_Metric_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *OperationProgress_Metric) GetIntValue() int64 {
	if x, ok := x.GetValue().(*OperationProgress_Metric_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *OperationProgress_Metric) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*OperationProgress_Metric_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *OperationProgress_Metric) GetStringValue() string {
	if x, ok := x.GetValue().(*OperationProgress_Metric_StringValue); ok {
		return x.StringValue
	}
	return ""
}

type isOperationProgress_Metric_Value interface {
	isOperationProgress_Metric_Value()
}

type OperationProgress_Metric_IntValue struct {
	// For metrics with integer value.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type OperationProgress_Metric_DoubleValue struct {
	// For metrics with floating point value.
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type OperationProgress_Metric_StringValue struct {
	// For metrics with custom values (ratios, visual progress, etc.).
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*OperationProgress_Metric_IntValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_DoubleValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_StringValue) isOperationProgress_Metric_Value() {}

// ReleaseChannelConfig exposes configuration for a release channel.
type ServerConfig_ReleaseChannelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The release channel this configuration applies to.
	Channel ReleaseChannel_Channel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.container.v1beta1.ReleaseChannel_Channel" json:"channel,omitempty"`
	// The default version for newly created clusters on the channel.
	DefaultVersion string `protobuf:"bytes,2,opt,name=default_version,json=defaultVersion,proto3" json:"default_version,omitempty"`
	// Deprecated.
	// This field has been deprecated and replaced with the valid_versions
	// field.
	//
	// Deprecated: Do not use.
	AvailableVersions []*ServerConfig_ReleaseChannelConfig_AvailableVersion `protobuf:"bytes,3,rep,name=available_versions,json=availableVersions,proto3" json:"available_versions,omitempty"`
	// List of valid versions for the channel.
	ValidVersions []string `protobuf:"bytes,4,rep,name=valid_versions,json=validVersions,proto3" json:"valid_versions,omitempty"`
}

func (x *ServerConfig_ReleaseChannelConfig) Reset() {
	*x = ServerConfig_ReleaseChannelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerConfig_ReleaseChannelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig_ReleaseChannelConfig) ProtoMessage() {}

func (x *ServerConfig_ReleaseChannelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig_ReleaseChannelConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig_ReleaseChannelConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{54, 0}
}

func (x *ServerConfig_ReleaseChannelConfig) GetChannel() ReleaseChannel_Channel {
	if x != nil {
		return x.Channel
	}
	return ReleaseChannel_UNSPECIFIED
}

func (x *ServerConfig_ReleaseChannelConfig) GetDefaultVersion() string {
	if x != nil {
		return x.DefaultVersion
	}
	return ""
}

// Deprecated: Do not use.
func (x *ServerConfig_ReleaseChannelConfig) GetAvailableVersions() []*ServerConfig_ReleaseChannelConfig_AvailableVersion {
	if x != nil {
		return x.AvailableVersions
	}
	return nil
}

func (x *ServerConfig_ReleaseChannelConfig) GetValidVersions() []string {
	if x != nil {
		return x.ValidVersions
	}
	return nil
}

// Deprecated.
//
// Deprecated: Do not use.
type ServerConfig_ReleaseChannelConfig_AvailableVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes version.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Reason for availability.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *ServerConfig_ReleaseChannelConfig_AvailableVersion) Reset() {
	*x = ServerConfig_ReleaseChannelConfig_AvailableVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerConfig_ReleaseChannelConfig_AvailableVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig_ReleaseChannelConfig_AvailableVersion) ProtoMessage() {}

func (x *ServerConfig_ReleaseChannelConfig_AvailableVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig_ReleaseChannelConfig_AvailableVersion.ProtoReflect.Descriptor instead.
func (*ServerConfig_ReleaseChannelConfig_AvailableVersion) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{54, 0, 0}
}

func (x *ServerConfig_ReleaseChannelConfig_AvailableVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ServerConfig_ReleaseChannelConfig_AvailableVersion) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// These upgrade settings control the level of parallelism and the level of
// disruption caused by an upgrade.
//
// maxUnavailable controls the number of nodes that can be simultaneously
// unavailable.
//
// maxSurge controls the number of additional nodes that can be added to the
// node pool temporarily for the time of the upgrade to increase the number of
// available nodes.
//
// (maxUnavailable + maxSurge) determines the level of parallelism (how many
// nodes are being upgraded at the same time).
//
// Note: upgrades inevitably introduce some disruption since workloads need to
// be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
// this holds true. (Disruption stays within the limits of
// PodDisruptionBudget, if it is configured.)
//
// Consider a hypothetical node pool with 5 nodes having maxSurge=2,
// maxUnavailable=1. This means the upgrade process upgrades 3 nodes
// simultaneously. It creates 2 additional (upgraded) nodes, then it brings
// down 3 old (not yet upgraded) nodes at the same time. This ensures that
// there are always at least 4 nodes available.
type NodePool_UpgradeSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of nodes that can be created beyond the current size
	// of the node pool during the upgrade process.
	MaxSurge int32 `protobuf:"varint,1,opt,name=max_surge,json=maxSurge,proto3" json:"max_surge,omitempty"`
	// The maximum number of nodes that can be simultaneously unavailable during
	// the upgrade process. A node is considered available if its status is
	// Ready.
	MaxUnavailable int32 `protobuf:"varint,2,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
}

func (x *NodePool_UpgradeSettings) Reset() {
	*x = NodePool_UpgradeSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePool_UpgradeSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_UpgradeSettings) ProtoMessage() {}

func (x *NodePool_UpgradeSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_UpgradeSettings.ProtoReflect.Descriptor instead.
func (*NodePool_UpgradeSettings) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{59, 0}
}

func (x *NodePool_UpgradeSettings) GetMaxSurge() int32 {
	if x != nil {
		return x.MaxSurge
	}
	return 0
}

func (x *NodePool_UpgradeSettings) GetMaxUnavailable() int32 {
	if x != nil {
		return x.MaxUnavailable
	}
	return 0
}

// Parameters for using BigQuery as the destination of resource usage export.
type ResourceUsageExportConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
}

func (x *ResourceUsageExportConfig_BigQueryDestination) Reset() {
	*x = ResourceUsageExportConfig_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceUsageExportConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig_BigQueryDestination) ProtoMessage() {}

func (x *ResourceUsageExportConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{98, 0}
}

func (x *ResourceUsageExportConfig_BigQueryDestination) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

// Parameters for controlling consumption metering.
type ResourceUsageExportConfig_ConsumptionMeteringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable consumption metering for this cluster. If enabled, a
	// second BigQuery table will be created to hold resource consumption
	// records.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) Reset() {
	*x = ResourceUsageExportConfig_ConsumptionMeteringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) ProtoMessage() {}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig_ConsumptionMeteringConfig.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{98, 1}
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Pub/Sub specific notification config.
type NotificationConfig_PubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable notifications for Pub/Sub.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The desired Pub/Sub topic to which notifications will be
	// sent by GKE. Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *NotificationConfig_PubSub) Reset() {
	*x = NotificationConfig_PubSub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationConfig_PubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig_PubSub) ProtoMessage() {}

func (x *NotificationConfig_PubSub) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1beta1_cluster_service_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig_PubSub.ProtoReflect.Descriptor instead.
func (*NotificationConfig_PubSub) Descriptor() ([]byte, []int) {
	return file_google_container_v1beta1_cluster_service_proto_rawDescGZIP(), []int{108, 0}
}

func (x *NotificationConfig_PubSub) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NotificationConfig_PubSub) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

var File_google_container_v1beta1_cluster_service_proto protoreflect.FileDescriptor

var file_google_container_v1beta1_cluster_service_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9f, 0x01, 0x0a, 0x0f,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x50, 0x0a, 0x07, 0x73, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x79, 0x73, 0x63,
	0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x73, 0x79, 0x73, 0x63, 0x74, 0x6c,
	0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x53, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb2, 0x01,
	0x0a, 0x11, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x63, 0x70, 0x75, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x3e, 0x0a, 0x0d, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63, 0x70, 0x75, 0x43, 0x66, 0x73, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x12, 0x2f, 0x0a, 0x14, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x63, 0x70, 0x75, 0x43, 0x66, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x22, 0xec, 0x0b, 0x0a, 0x0a, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d,
	0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72,
	0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x61, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x4e, 0x0a, 0x0e, 0x73, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61,
	0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x60, 0x0a, 0x14, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x52, 0x13, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x12, 0x6a, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b,
	0x0a, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61,
	0x69, 0x6e, 0x74, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x11, 0x62,
	0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b,
	0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x6a, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65,
	0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x55, 0x0a, 0x11, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4e,
	0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0e, 0x6b, 0x75, 0x62,
	0x65, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d,
	0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a,
	0x18, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x70, 0x68, 0x65, 0x6d,
	0x65, 0x72, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x16, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x86, 0x01, 0x0a, 0x16, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f,
	0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x3e, 0x0a, 0x1b, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x9d, 0x01, 0x0a, 0x0d, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0c,
	0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x6e,
	0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x23, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x47, 0x56, 0x49, 0x53, 0x4f, 0x52, 0x10, 0x01, 0x22, 0x40, 0x0a, 0x16, 0x45, 0x70,
	0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x89, 0x02, 0x0a,
	0x13, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x79, 0x12, 0x6c, 0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x16, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5a, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53, 0x45,
	0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x4e, 0x59,
	0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18,
	0x0a, 0x14, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52,
	0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0xd2, 0x01, 0x0a, 0x09, 0x4e, 0x6f, 0x64,
	0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x42,
	0x0a, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61,
	0x69, 0x6e, 0x74, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x52, 0x06, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x22, 0x59, 0x0a, 0x06, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12,
	0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f,
	0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x45, 0x10, 0x03, 0x22, 0xbf, 0x02,
	0x0a, 0x0a, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x6d, 0x0a, 0x19,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x17, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x66,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x22,
	0x53, 0x0a, 0x17, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x18, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x22, 0xd6, 0x07, 0x0a, 0x0c, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x13, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x52,
	0x11, 0x68, 0x74, 0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x12, 0x70, 0x0a, 0x1a, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x18, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x12, 0x64, 0x0a, 0x14, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x5f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x61, 0x0a, 0x15, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a,
	0x0c, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x73, 0x74, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x73, 0x74, 0x69,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x10, 0x64,
	0x6e, 0x73, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0e, 0x64, 0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x67, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8b, 0x01, 0x0a, 0x25, 0x67, 0x63, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x63, 0x73, 0x69, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x65, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x67, 0x63, 0x65, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x0a, 0x0b, 0x6b, 0x61, 0x6c, 0x6d, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x61, 0x6c, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0a, 0x6b, 0x61, 0x6c, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2f, 0x0a,
	0x11, 0x48, 0x74, 0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x36,
	0x0a, 0x18, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x31, 0x0a, 0x13, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x31, 0x0a, 0x13, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x2a, 0x0a, 0x0e,
	0x44, 0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x26, 0x0a, 0x0a, 0x4b, 0x61, 0x6c, 0x6d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x22, 0x31, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x22, 0x3c, 0x0a, 0x20, 0x47, 0x63, 0x65, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x22, 0x42, 0x0a, 0x26, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xad, 0x03, 0x0a, 0x14, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30,
	0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x29, 0x0a,
	0x10, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x7f, 0x0a, 0x1b, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x67,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa7, 0x01, 0x0a, 0x0b, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x47, 0x0a, 0x04, 0x61, 0x75, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x73, 0x74, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x41, 0x75, 0x74, 0x68,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x22, 0x33, 0x0a, 0x0d, 0x49, 0x73,
	0x74, 0x69, 0x6f, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x55, 0x54, 0x48, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x55,
	0x54, 0x48, 0x5f, 0x4d, 0x55, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x54, 0x4c, 0x53, 0x10, 0x01, 0x22,
	0x8f, 0x02, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x67,
	0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x22, 0x78, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x01,
	0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45,
	0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10,
	0x02, 0x22, 0xee, 0x01, 0x0a, 0x1e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x63,
	0x0a, 0x0b, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x69,
	0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x1a, 0x4d, 0x0a, 0x09, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x22, 0x26, 0x0a, 0x0a, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63,
	0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xa9, 0x01, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4c, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x22, 0x30, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41,
	0x4c, 0x49, 0x43, 0x4f, 0x10, 0x01, 0x22, 0xbf, 0x05, 0x0a, 0x12, 0x49, 0x50, 0x41, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x24, 0x0a,
	0x0e, 0x75, 0x73, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x49, 0x70, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x27, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x11, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x28, 0x0a, 0x0e, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34, 0x43,
	0x69, 0x64, 0x72, 0x12, 0x30, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f,
	0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76,
	0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x3f, 0x0a, 0x1c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0x2f, 0x0a, 0x14, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69,
	0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x37, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x69, 0x70,
	0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76,
	0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61,
	0x70, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x70,
	0x75, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x70, 0x75, 0x49, 0x70, 0x76, 0x34,
	0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x75,
	0x73, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x22, 0x2f, 0x0a, 0x13, 0x42, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x33, 0x0a, 0x17, 0x50, 0x6f, 0x64,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x5c,
	0x0a, 0x19, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x9c, 0x01, 0x0a,
	0x10, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x43, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f,
	0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x59,
	0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x03, 0x22, 0xe6, 0x1f, 0x0a, 0x07,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x49, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x0a, 0x0b, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x75, 0x74, 0x68, 0x52, 0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x12, 0x27, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12,
	0x4b, 0x0a, 0x0d, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x41, 0x0a, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12,
	0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a,
	0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x5f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x12, 0x5e, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x12, 0x45, 0x0a, 0x0b, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x61, 0x62, 0x61,
	0x63, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x52, 0x0a, 0x6c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x12, 0x4e, 0x0a, 0x0e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5e, 0x0a, 0x14, 0x69, 0x70, 0x5f,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x50, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x69, 0x70, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x83, 0x01, 0x0a, 0x21, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x1e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5a, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x60, 0x0a, 0x14, 0x62,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a,
	0x1a, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x70, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a,
	0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x1a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4e, 0x0a,
	0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a,
	0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x16, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x12, 0x6a, 0x0a, 0x1b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x61,
	0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12,
	0x74, 0x0a, 0x1c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x1b, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x19, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x16, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6a, 0x0a, 0x18, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x64,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x27, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x16, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f,
	0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4e, 0x0a, 0x0e,
	0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x28,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x0d, 0x73,
	0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x6a, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x11, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x52, 0x10, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x12, 0x42, 0x0a, 0x0a, 0x74, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x70, 0x75, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x74,
	0x70, 0x75, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x32, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x52, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x66, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x67, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x14, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x69, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x64,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x29, 0x0a, 0x0e, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x6c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x6d, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64,
	0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x6e, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76, 0x34, 0x43,
	0x69, 0x64, 0x72, 0x12, 0x32, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x6f, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x30, 0x0a, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x70, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x71, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x72, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x74, 0x70, 0x75, 0x18, 0x73, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x70, 0x75, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x70, 0x75, 0x5f, 0x69, 0x70, 0x76,
	0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x74, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x74, 0x70, 0x75, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x5d, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x26, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x12, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x76, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38,
	0x0a, 0x06, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x18, 0x7c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x1a, 0x41, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x77, 0x0a, 0x06, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44,
	0x45, 0x44, 0x10, 0x06, 0x22, 0xab, 0x15, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5a, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x2f, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x70, 0x0a, 0x1d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x92, 0x01, 0x0a, 0x29, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x25,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7d, 0x0a, 0x22, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6f, 0x64,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x12, 0x6f, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x24,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x79, 0x0a, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50,
	0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1d, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f,
	0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x73, 0x0a, 0x1e,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x83, 0x01, 0x0a, 0x24, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e,
	0x74, 0x72, 0x61, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x72,
	0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6e,
	0x74, 0x72, 0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x6e, 0x61, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53,
	0x6e, 0x61, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x6e, 0x61, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x66, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x52, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x12, 0x60, 0x0a, 0x17, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x15, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x51, 0x0a,
	0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x70, 0x75, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x54, 0x70, 0x75, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x66, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x61, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x32, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52,
	0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x6c, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x1b,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x2e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x20, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x14,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0d,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12, 0x82, 0x01,
	0x0a, 0x23, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xb0, 0x09, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x4f, 0x0a, 0x0e,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x5c, 0x0a, 0x12, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5e, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x12, 0x6e, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x22, 0x52, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x42, 0x4f, 0x52, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0xfd, 0x02, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e,
	0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x03,
	0x12, 0x11, 0x0a, 0x0d, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45,
	0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x43, 0x4c,
	0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10,
	0x07, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45,
	0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x08, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x54, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x09, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x52, 0x45,
	0x50, 0x41, 0x49, 0x52, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x53, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x12,
	0x41, 0x55, 0x54, 0x4f, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x44,
	0x45, 0x53, 0x10, 0x0b, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x54, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x53, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x54, 0x5f, 0x4d, 0x41, 0x53, 0x54,
	0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x0d, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x54,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10,
	0x0e, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x54, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x0f, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45, 0x54,
	0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x10, 0x10, 0x22, 0x94, 0x03, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x42, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x4c, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x93, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23,
	0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb1, 0x01, 0x0a,
	0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x40, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x22, 0x8e, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xd7, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x44, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9b, 0x05, 0x0a, 0x15,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x6a, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x5d, 0x0a, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x55,
	0x0a, 0x11, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62,
	0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6b, 0x75, 0x62, 0x65,
	0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x99, 0x02, 0x0a, 0x1d, 0x53, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x1b,
	0x53, 0x65, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x32, 0x0a, 0x12, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x01, 0x0a, 0x16, 0x53,
	0x65, 0x74, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0d,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfa, 0x02, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x50, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x54,
	0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44,
	0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x4e, 0x41,
	0x4d, 0x45, 0x10, 0x03, 0x22, 0x91, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x7a, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5a,
	0x6f, 0x6e, 0x65, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x28, 0x0a,
	0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x97, 0x01,
	0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x28, 0x0a, 0x0c, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x43, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x22, 0x6d, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdd, 0x05, 0x0a, 0x0c,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x57, 0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x1a, 0xfd, 0x02, 0x0a, 0x14,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x12, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x48, 0x0a, 0x10, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xdc, 0x01, 0x0a, 0x15,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x09,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xbb, 0x01, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x22, 0xb8, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27,
	0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x08, 0x0a, 0x08,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4e,
	0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a,
	0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x66, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x41, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x29, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52,
	0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x48, 0x0a, 0x0a,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f,
	0x64, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x69, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b,
	0x0a, 0x12, 0x70, 0x6f, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x6f, 0x64, 0x49,
	0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x5d, 0x0a, 0x10, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x57, 0x0a, 0x0f, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x72, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61,
	0x78, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x81, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16,
	0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x22, 0xab, 0x01, 0x0a, 0x0e, 0x4e, 0x6f, 0x64, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x12, 0x55,
	0x0a, 0x0f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x6d, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x61, 0x75,
	0x74, 0x6f, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x43, 0x0a, 0x06, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12,
	0x29, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd6, 0x03, 0x0a, 0x11, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x6c, 0x0a, 0x18, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x69, 0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x16, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x5a,
	0x0a, 0x10, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x75, 0x72,
	0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x7d, 0x0a, 0x16, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x15, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x6e, 0x0a, 0x1a, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x7e, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x73, 0x0a, 0x13, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x3c, 0x0a, 0x06, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x53, 0x0a, 0x16, 0x44, 0x61, 0x69, 0x6c,
	0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x02,
	0x0a, 0x1c, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x4d,
	0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xe0, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a,
	0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x1e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x27,
	0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x09, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x22, 0xbc, 0x04, 0x0a, 0x12, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x40,
	0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x41, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x12, 0x50, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x12, 0x70, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x23, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x20,
	0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x3d, 0x0a, 0x1a, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x55, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18,
	0x0a, 0x14, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x54, 0x49, 0x4c, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x41, 0x4c, 0x41,
	0x4e, 0x43, 0x45, 0x44, 0x10, 0x02, 0x22, 0xb6, 0x04, 0x0a, 0x20, 0x41, 0x75, 0x74, 0x6f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x28, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43,
	0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6a, 0x0a, 0x18, 0x73, 0x68, 0x69,
	0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73,
	0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x68, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x22, 0xa5, 0x01, 0x0a, 0x13, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x6d,
	0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x22, 0xf0, 0x02, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x6c, 0x0a,
	0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x1a, 0x41, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xb0, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x4c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x49, 0x50, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a,
	0x12, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x72, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x96, 0x01, 0x0a,
	0x19, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x50, 0x52, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05,
	0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x22, 0xdf, 0x02, 0x0a, 0x16, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a,
	0x0d, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x49, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x22, 0x50, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x45, 0x58, 0x50, 0x4f, 0x53, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x4b, 0x45,
	0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52,
	0x10, 0x03, 0x22, 0x40, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x47, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x4b, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41,
	0x54, 0x41, 0x10, 0x02, 0x22, 0xe9, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x24, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x24, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xf3, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x5f, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x81, 0x01, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xca, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x43, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xbb, 0x02, 0x0a,
	0x0f, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x46, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x37, 0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x04,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x4f, 0x55,
	0x54, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x4b, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x47, 0x43, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54,
	0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f,
	0x53, 0x45, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10,
	0x04, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4b, 0x4d, 0x53, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x22, 0xc0, 0x02, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x72, 0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x5b, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x73, 0x6e, 0x61, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x6e, 0x61, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x6e, 0x61, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68,
	0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70,
	0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x10, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x8f, 0x01,
	0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x95, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x0b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x02, 0x0a, 0x1e, 0x55, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x69, 0x70, 0x5f,
	0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x69, 0x70, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x57, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x67, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x55, 0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x5f,
	0x55, 0x53, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a,
	0x14, 0x49, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x50, 0x4f, 0x44, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x5f, 0x55, 0x53,
	0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x50, 0x4f, 0x44, 0x10, 0x04, 0x22,
	0x81, 0x02, 0x0a, 0x10, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x22,
	0x0a, 0x0d, 0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x68, 0x0a, 0x13, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x11, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x32, 0x0a, 0x16, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50,
	0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x2f, 0x0a, 0x11, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x53, 0x6e, 0x61, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x35, 0x0a, 0x19, 0x49, 0x6e, 0x74, 0x72,
	0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x3e, 0x0a, 0x11, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x6d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x50, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x22,
	0x9d, 0x01, 0x0a, 0x16, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22,
	0xad, 0x01, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x32, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22,
	0xd9, 0x03, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a,
	0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x1e, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x65, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x8d,
	0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x34,
	0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x49, 0x64, 0x1a, 0x35, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x29, 0x0a, 0x0d, 0x53,
	0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x30, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65,
	0x6e, 0x49, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xdb, 0x02, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x4f, 0x70, 0x65, 0x6e, 0x49, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6a, 0x77, 0x6b, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6a, 0x77, 0x6b, 0x73, 0x55, 0x72, 0x69, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x15, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x25, 0x69, 0x64, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c,
	0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x2f, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4a, 0x53, 0x4f,
	0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x97, 0x01, 0x0a, 0x03, 0x4a, 0x77, 0x6b, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x74,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x61, 0x6c, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x69, 0x64, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x01, 0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x01, 0x65, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x01,
	0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x01, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x63, 0x72, 0x76, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x72,
	0x76, 0x22, 0x4b, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x77, 0x6b, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x9c,
	0x01, 0x0a, 0x0e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x12, 0x4a, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x3e, 0x0a,
	0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x41, 0x50,
	0x49, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x47, 0x55, 0x4c, 0x41, 0x52, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0x83, 0x01,
	0x0a, 0x09, 0x54, 0x70, 0x75, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x75, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x26, 0x0a, 0x0f, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x22, 0x08, 0x0a, 0x06, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x22, 0xbd, 0x01,
	0x0a, 0x12, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x52, 0x06, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x1a, 0x5a, 0x0a, 0x06, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x2d, 0x0a,
	0x11, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xd8, 0x02, 0x0a,
	0x0c, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x14, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2a, 0x61, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x70,
	0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x1d, 0x44,
	0x41, 0x54, 0x41, 0x50, 0x41, 0x54, 0x48, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x52,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x50, 0x41, 0x54,
	0x48, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x50, 0x41, 0x54, 0x48, 0x10, 0x02, 0x2a, 0x57, 0x0a, 0x13, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x25, 0x0a, 0x21, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x53, 0x54,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f,
	0x4c, 0x10, 0x02, 0x32, 0xea, 0x4a, 0x0a, 0x0e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0xf3, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6b, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x5a, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65,
	0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0xda, 0x41, 0x0f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0xfa, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x9b, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x78, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f,
	0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x1a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xf8, 0x01, 0x0a, 0x0d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x71, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a, 0x5a,
	0x39, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x17, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x8f, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x7e, 0x1a, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x46, 0x1a, 0x41, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e,
	0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c,
	0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x9a, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xaa, 0x01, 0x1a, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x66, 0x22, 0x61, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x3a, 0x01, 0x2a, 0x12, 0xbe, 0x02, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xbe, 0x01, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0x5a, 0x6b, 0x22, 0x66, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f,
	0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x3a, 0x01, 0x2a, 0x12, 0xb4, 0x02, 0x0a, 0x11, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x91, 0x01, 0x22, 0x3c, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x74, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0x5a, 0x4e,
	0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x2a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65,
	0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc3, 0x02, 0x0a, 0x14,
	0x53, 0x65, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xce, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0x5a, 0x51,
	0x22, 0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a,
	0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xac, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x41, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b,
	0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x6f,
	0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x28, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x2c, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0xab, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc6, 0x01, 0x88, 0x02, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x95, 0x01, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x50, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a,
	0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x24, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xaa,
	0x02, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x92, 0x01, 0x22, 0x3e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x01, 0x2a,
	0x5a, 0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x29, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e,
	0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x88, 0x02, 0x0a, 0x0d,
	0x53, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9a, 0x01, 0x22, 0x3f, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x3a, 0x01, 0x2a,
	0x5a, 0x54, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0x82, 0x02, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x78, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x43, 0x2a, 0x41, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41,
	0x1a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65,
	0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xfd, 0x01, 0x0a, 0x0e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6f, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5a,
	0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x0f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x88, 0x02, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xa3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7e, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x47,
	0x12, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x1c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0x96, 0x02, 0x0a, 0x0f, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0xb8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x92, 0x01, 0x22, 0x3a,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0x5a, 0x51, 0x22,
	0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x1c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f,
	0x6e, 0x65, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12,
	0xf7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x89, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x71, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x3a, 0x12, 0x38, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x0f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0xa5, 0x02, 0x0a, 0x0d, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb2, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x8e, 0x01, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x5a, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a,
	0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0xda, 0x41, 0x1a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x12, 0xb5, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12,
	0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x77, 0x6b, 0x73, 0x12, 0xb0, 0x02, 0x0a, 0x0b, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0xce, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x9d, 0x01, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x5c, 0x12, 0x5a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f,
	0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x7d, 0xda, 0x41, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c,
	0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x12, 0xab, 0x02, 0x0a,
	0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x01, 0x22,
	0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x3a, 0x01,
	0x2a, 0x5a, 0x50, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x24, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x2c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x12, 0xb7, 0x02, 0x0a, 0x0e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xce, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9d, 0x01, 0x2a, 0x3d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x5c, 0x2a, 0x5a,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a,
	0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x27, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x69, 0x64, 0x12, 0xe1, 0x02, 0x0a, 0x17, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xe6, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb5, 0x01, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x3a, 0x01, 0x2a, 0x5a, 0x68, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f,
	0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x7d, 0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65,
	0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x12, 0xf2, 0x02, 0x0a, 0x15, 0x53, 0x65, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xfb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbf, 0x01, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x6d, 0x22, 0x68, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x69, 0x64, 0x2c, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xc4, 0x02,
	0x0a, 0x09, 0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x9f, 0x01, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x55,
	0x22, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x12, 0xaa, 0x02, 0x0a, 0x0d, 0x53, 0x65, 0x74, 0x4c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x97, 0x01, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x3a, 0x01, 0x2a, 0x5a, 0x51, 0x22, 0x4c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x22, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0xad, 0x02, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x50, 0x52, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x50, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49,
	0x70, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0x5a, 0x56, 0x22, 0x51,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a,
	0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x70, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x12, 0xb9, 0x02, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x50,
	0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x50, 0x52, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xc8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa4, 0x01, 0x22, 0x44, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x70, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0x5a, 0x59, 0x22, 0x54, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a,
	0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x70, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x1a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f,
	0x6e, 0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xa5, 0x02,
	0x0a, 0x0f, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xb3, 0x01, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x67, 0x22, 0x62,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a,
	0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xc0, 0x02, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xd3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa0, 0x01, 0x22, 0x42, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x3a, 0x01, 0x2a, 0x5a, 0x57, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e,
	0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x29, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e, 0x65, 0x2c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xd4, 0x02, 0x0a, 0x14, 0x53, 0x65, 0x74,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa8, 0x01, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a,
	0x01, 0x2a, 0x5a, 0x5b, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65,
	0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x7a, 0x6f, 0x6e,
	0x65, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0xd4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x2f, 0x75, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa9, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x1a, 0x4c, 0xca, 0x41, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xa1, 0x02, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x42, 0x13, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x41, 0x40, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_container_v1beta1_cluster_service_proto_rawDescOnce sync.Once
	file_google_container_v1beta1_cluster_service_proto_rawDescData = file_google_container_v1beta1_cluster_service_proto_rawDesc
)

func file_google_container_v1beta1_cluster_service_proto_rawDescGZIP() []byte {
	file_google_container_v1beta1_cluster_service_proto_rawDescOnce.Do(func() {
		file_google_container_v1beta1_cluster_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_container_v1beta1_cluster_service_proto_rawDescData)
	})
	return file_google_container_v1beta1_cluster_service_proto_rawDescData
}

var file_google_container_v1beta1_cluster_service_proto_enumTypes = make([]protoimpl.EnumInfo, 22)
var file_google_container_v1beta1_cluster_service_proto_msgTypes = make([]protoimpl.MessageInfo, 125)
var file_google_container_v1beta1_cluster_service_proto_goTypes = []interface{}{
	(DatapathProvider)(0),                            // 0: google.container.v1beta1.DatapathProvider
	(UpgradeResourceType)(0),                         // 1: google.container.v1beta1.UpgradeResourceType
	(SandboxConfig_Type)(0),                          // 2: google.container.v1beta1.SandboxConfig.Type
	(ReservationAffinity_Type)(0),                    // 3: google.container.v1beta1.ReservationAffinity.Type
	(NodeTaint_Effect)(0),                            // 4: google.container.v1beta1.NodeTaint.Effect
	(IstioConfig_IstioAuthMode)(0),                   // 5: google.container.v1beta1.IstioConfig.IstioAuthMode
	(CloudRunConfig_LoadBalancerType)(0),             // 6: google.container.v1beta1.CloudRunConfig.LoadBalancerType
	(NetworkPolicy_Provider)(0),                      // 7: google.container.v1beta1.NetworkPolicy.Provider
	(ClusterTelemetry_Type)(0),                       // 8: google.container.v1beta1.ClusterTelemetry.Type
	(Cluster_Status)(0),                              // 9: google.container.v1beta1.Cluster.Status
	(Operation_Status)(0),                            // 10: google.container.v1beta1.Operation.Status
	(Operation_Type)(0),                              // 11: google.container.v1beta1.Operation.Type
	(SetMasterAuthRequest_Action)(0),                 // 12: google.container.v1beta1.SetMasterAuthRequest.Action
	(NodePool_Status)(0),                             // 13: google.container.v1beta1.NodePool.Status
	(ClusterAutoscaling_AutoscalingProfile)(0),       // 14: google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile
	(WorkloadMetadataConfig_NodeMetadata)(0),         // 15: google.container.v1beta1.WorkloadMetadataConfig.NodeMetadata
	(WorkloadMetadataConfig_Mode)(0),                 // 16: google.container.v1beta1.WorkloadMetadataConfig.Mode
	(Location_LocationType)(0),                       // 17: google.container.v1beta1.Location.LocationType
	(StatusCondition_Code)(0),                        // 18: google.container.v1beta1.StatusCondition.Code
	(UsableSubnetworkSecondaryRange_Status)(0),       // 19: google.container.v1beta1.UsableSubnetworkSecondaryRange.Status
	(DatabaseEncryption_State)(0),                    // 20: google.container.v1beta1.DatabaseEncryption.State
	(ReleaseChannel_Channel)(0),                      // 21: google.container.v1beta1.ReleaseChannel.Channel
	(*LinuxNodeConfig)(nil),                          // 22: google.container.v1beta1.LinuxNodeConfig
	(*NodeKubeletConfig)(nil),                        // 23: google.container.v1beta1.NodeKubeletConfig
	(*NodeConfig)(nil),                               // 24: google.container.v1beta1.NodeConfig
	(*ShieldedInstanceConfig)(nil),                   // 25: google.container.v1beta1.ShieldedInstanceConfig
	(*SandboxConfig)(nil),                            // 26: google.container.v1beta1.SandboxConfig
	(*EphemeralStorageConfig)(nil),                   // 27: google.container.v1beta1.EphemeralStorageConfig
	(*ReservationAffinity)(nil),                      // 28: google.container.v1beta1.ReservationAffinity
	(*NodeTaint)(nil),                                // 29: google.container.v1beta1.NodeTaint
	(*MasterAuth)(nil),                               // 30: google.container.v1beta1.MasterAuth
	(*ClientCertificateConfig)(nil),                  // 31: google.container.v1beta1.ClientCertificateConfig
	(*AddonsConfig)(nil),                             // 32: google.container.v1beta1.AddonsConfig
	(*HttpLoadBalancing)(nil),                        // 33: google.container.v1beta1.HttpLoadBalancing
	(*HorizontalPodAutoscaling)(nil),                 // 34: google.container.v1beta1.HorizontalPodAutoscaling
	(*KubernetesDashboard)(nil),                      // 35: google.container.v1beta1.KubernetesDashboard
	(*NetworkPolicyConfig)(nil),                      // 36: google.container.v1beta1.NetworkPolicyConfig
	(*DnsCacheConfig)(nil),                           // 37: google.container.v1beta1.DnsCacheConfig
	(*KalmConfig)(nil),                               // 38: google.container.v1beta1.KalmConfig
	(*ConfigConnectorConfig)(nil),                    // 39: google.container.v1beta1.ConfigConnectorConfig
	(*GcePersistentDiskCsiDriverConfig)(nil),         // 40: google.container.v1beta1.GcePersistentDiskCsiDriverConfig
	(*PrivateClusterMasterGlobalAccessConfig)(nil),   // 41: google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
	(*PrivateClusterConfig)(nil),                     // 42: google.container.v1beta1.PrivateClusterConfig
	(*IstioConfig)(nil),                              // 43: google.container.v1beta1.IstioConfig
	(*CloudRunConfig)(nil),                           // 44: google.container.v1beta1.CloudRunConfig
	(*MasterAuthorizedNetworksConfig)(nil),           // 45: google.container.v1beta1.MasterAuthorizedNetworksConfig
	(*LegacyAbac)(nil),                               // 46: google.container.v1beta1.LegacyAbac
	(*NetworkPolicy)(nil),                            // 47: google.container.v1beta1.NetworkPolicy
	(*IPAllocationPolicy)(nil),                       // 48: google.container.v1beta1.IPAllocationPolicy
	(*BinaryAuthorization)(nil),                      // 49: google.container.v1beta1.BinaryAuthorization
	(*PodSecurityPolicyConfig)(nil),                  // 50: google.container.v1beta1.PodSecurityPolicyConfig
	(*AuthenticatorGroupsConfig)(nil),                // 51: google.container.v1beta1.AuthenticatorGroupsConfig
	(*ClusterTelemetry)(nil),                         // 52: google.container.v1beta1.ClusterTelemetry
	(*Cluster)(nil),                                  // 53: google.container.v1beta1.Cluster
	(*ClusterUpdate)(nil),                            // 54: google.container.v1beta1.ClusterUpdate
	(*Operation)(nil),                                // 55: google.container.v1beta1.Operation
	(*OperationProgress)(nil),                        // 56: google.container.v1beta1.OperationProgress
	(*CreateClusterRequest)(nil),                     // 57: google.container.v1beta1.CreateClusterRequest
	(*GetClusterRequest)(nil),                        // 58: google.container.v1beta1.GetClusterRequest
	(*UpdateClusterRequest)(nil),                     // 59: google.container.v1beta1.UpdateClusterRequest
	(*UpdateNodePoolRequest)(nil),                    // 60: google.container.v1beta1.UpdateNodePoolRequest
	(*SetNodePoolAutoscalingRequest)(nil),            // 61: google.container.v1beta1.SetNodePoolAutoscalingRequest
	(*SetLoggingServiceRequest)(nil),                 // 62: google.container.v1beta1.SetLoggingServiceRequest
	(*SetMonitoringServiceRequest)(nil),              // 63: google.container.v1beta1.SetMonitoringServiceRequest
	(*SetAddonsConfigRequest)(nil),                   // 64: google.container.v1beta1.SetAddonsConfigRequest
	(*SetLocationsRequest)(nil),                      // 65: google.container.v1beta1.SetLocationsRequest
	(*UpdateMasterRequest)(nil),                      // 66: google.container.v1beta1.UpdateMasterRequest
	(*SetMasterAuthRequest)(nil),                     // 67: google.container.v1beta1.SetMasterAuthRequest
	(*DeleteClusterRequest)(nil),                     // 68: google.container.v1beta1.DeleteClusterRequest
	(*ListClustersRequest)(nil),                      // 69: google.container.v1beta1.ListClustersRequest
	(*ListClustersResponse)(nil),                     // 70: google.container.v1beta1.ListClustersResponse
	(*GetOperationRequest)(nil),                      // 71: google.container.v1beta1.GetOperationRequest
	(*ListOperationsRequest)(nil),                    // 72: google.container.v1beta1.ListOperationsRequest
	(*CancelOperationRequest)(nil),                   // 73: google.container.v1beta1.CancelOperationRequest
	(*ListOperationsResponse)(nil),                   // 74: google.container.v1beta1.ListOperationsResponse
	(*GetServerConfigRequest)(nil),                   // 75: google.container.v1beta1.GetServerConfigRequest
	(*ServerConfig)(nil),                             // 76: google.container.v1beta1.ServerConfig
	(*CreateNodePoolRequest)(nil),                    // 77: google.container.v1beta1.CreateNodePoolRequest
	(*DeleteNodePoolRequest)(nil),                    // 78: google.container.v1beta1.DeleteNodePoolRequest
	(*ListNodePoolsRequest)(nil),                     // 79: google.container.v1beta1.ListNodePoolsRequest
	(*GetNodePoolRequest)(nil),                       // 80: google.container.v1beta1.GetNodePoolRequest
	(*NodePool)(nil),                                 // 81: google.container.v1beta1.NodePool
	(*NodeManagement)(nil),                           // 82: google.container.v1beta1.NodeManagement
	(*AutoUpgradeOptions)(nil),                       // 83: google.container.v1beta1.AutoUpgradeOptions
	(*MaintenancePolicy)(nil),                        // 84: google.container.v1beta1.MaintenancePolicy
	(*MaintenanceWindow)(nil),                        // 85: google.container.v1beta1.MaintenanceWindow
	(*TimeWindow)(nil),                               // 86: google.container.v1beta1.TimeWindow
	(*RecurringTimeWindow)(nil),                      // 87: google.container.v1beta1.RecurringTimeWindow
	(*DailyMaintenanceWindow)(nil),                   // 88: google.container.v1beta1.DailyMaintenanceWindow
	(*SetNodePoolManagementRequest)(nil),             // 89: google.container.v1beta1.SetNodePoolManagementRequest
	(*SetNodePoolSizeRequest)(nil),                   // 90: google.container.v1beta1.SetNodePoolSizeRequest
	(*RollbackNodePoolUpgradeRequest)(nil),           // 91: google.container.v1beta1.RollbackNodePoolUpgradeRequest
	(*ListNodePoolsResponse)(nil),                    // 92: google.container.v1beta1.ListNodePoolsResponse
	(*ClusterAutoscaling)(nil),                       // 93: google.container.v1beta1.ClusterAutoscaling
	(*AutoprovisioningNodePoolDefaults)(nil),         // 94: google.container.v1beta1.AutoprovisioningNodePoolDefaults
	(*ResourceLimit)(nil),                            // 95: google.container.v1beta1.ResourceLimit
	(*NodePoolAutoscaling)(nil),                      // 96: google.container.v1beta1.NodePoolAutoscaling
	(*SetLabelsRequest)(nil),                         // 97: google.container.v1beta1.SetLabelsRequest
	(*SetLegacyAbacRequest)(nil),                     // 98: google.container.v1beta1.SetLegacyAbacRequest
	(*StartIPRotationRequest)(nil),                   // 99: google.container.v1beta1.StartIPRotationRequest
	(*CompleteIPRotationRequest)(nil),                // 100: google.container.v1beta1.CompleteIPRotationRequest
	(*AcceleratorConfig)(nil),                        // 101: google.container.v1beta1.AcceleratorConfig
	(*WorkloadMetadataConfig)(nil),                   // 102: google.container.v1beta1.WorkloadMetadataConfig
	(*SetNetworkPolicyRequest)(nil),                  // 103: google.container.v1beta1.SetNetworkPolicyRequest
	(*SetMaintenancePolicyRequest)(nil),              // 104: google.container.v1beta1.SetMaintenancePolicyRequest
	(*ListLocationsRequest)(nil),                     // 105: google.container.v1beta1.ListLocationsRequest
	(*ListLocationsResponse)(nil),                    // 106: google.container.v1beta1.ListLocationsResponse
	(*Location)(nil),                                 // 107: google.container.v1beta1.Location
	(*StatusCondition)(nil),                          // 108: google.container.v1beta1.StatusCondition
	(*NetworkConfig)(nil),                            // 109: google.container.v1beta1.NetworkConfig
	(*ListUsableSubnetworksRequest)(nil),             // 110: google.container.v1beta1.ListUsableSubnetworksRequest
	(*ListUsableSubnetworksResponse)(nil),            // 111: google.container.v1beta1.ListUsableSubnetworksResponse
	(*UsableSubnetworkSecondaryRange)(nil),           // 112: google.container.v1beta1.UsableSubnetworkSecondaryRange
	(*UsableSubnetwork)(nil),                         // 113: google.container.v1beta1.UsableSubnetwork
	(*VerticalPodAutoscaling)(nil),                   // 114: google.container.v1beta1.VerticalPodAutoscaling
	(*DefaultSnatStatus)(nil),                        // 115: google.container.v1beta1.DefaultSnatStatus
	(*IntraNodeVisibilityConfig)(nil),                // 116: google.container.v1beta1.IntraNodeVisibilityConfig
	(*MaxPodsConstraint)(nil),                        // 117: google.container.v1beta1.MaxPodsConstraint
	(*WorkloadIdentityConfig)(nil),                   // 118: google.container.v1beta1.WorkloadIdentityConfig
	(*DatabaseEncryption)(nil),                       // 119: google.container.v1beta1.DatabaseEncryption
	(*ResourceUsageExportConfig)(nil),                // 120: google.container.v1beta1.ResourceUsageExportConfig
	(*ShieldedNodes)(nil),                            // 121: google.container.v1beta1.ShieldedNodes
	(*GetOpenIDConfigRequest)(nil),                   // 122: google.container.v1beta1.GetOpenIDConfigRequest
	(*GetOpenIDConfigResponse)(nil),                  // 123: google.container.v1beta1.GetOpenIDConfigResponse
	(*GetJSONWebKeysRequest)(nil),                    // 124: google.container.v1beta1.GetJSONWebKeysRequest
	(*Jwk)(nil),                                      // 125: google.container.v1beta1.Jwk
	(*GetJSONWebKeysResponse)(nil),                   // 126: google.container.v1beta1.GetJSONWebKeysResponse
	(*ReleaseChannel)(nil),                           // 127: google.container.v1beta1.ReleaseChannel
	(*TpuConfig)(nil),                                // 128: google.container.v1beta1.TpuConfig
	(*Master)(nil),                                   // 129: google.container.v1beta1.Master
	(*NotificationConfig)(nil),                       // 130: google.container.v1beta1.NotificationConfig
	(*ConfidentialNodes)(nil),                        // 131: google.container.v1beta1.ConfidentialNodes
	(*UpgradeEvent)(nil),                             // 132: google.container.v1beta1.UpgradeEvent
	nil,                                              // 133: google.container.v1beta1.LinuxNodeConfig.SysctlsEntry
	nil,                                              // 134: google.container.v1beta1.NodeConfig.MetadataEntry
	nil,                                              // 135: google.container.v1beta1.NodeConfig.LabelsEntry
	(*MasterAuthorizedNetworksConfig_CidrBlock)(nil), // 136: google.container.v1beta1.MasterAuthorizedNetworksConfig.CidrBlock
	nil,                              // 137: google.container.v1beta1.Cluster.ResourceLabelsEntry
	(*OperationProgress_Metric)(nil), // 138: google.container.v1beta1.OperationProgress.Metric
	(*ServerConfig_ReleaseChannelConfig)(nil),                  // 139: google.container.v1beta1.ServerConfig.ReleaseChannelConfig
	(*ServerConfig_ReleaseChannelConfig_AvailableVersion)(nil), // 140: google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
	(*NodePool_UpgradeSettings)(nil),                           // 141: google.container.v1beta1.NodePool.UpgradeSettings
	nil,                                                        // 142: google.container.v1beta1.MaintenanceWindow.MaintenanceExclusionsEntry
	nil,                                                        // 143: google.container.v1beta1.SetLabelsRequest.ResourceLabelsEntry
	(*ResourceUsageExportConfig_BigQueryDestination)(nil),       // 144: google.container.v1beta1.ResourceUsageExportConfig.BigQueryDestination
	(*ResourceUsageExportConfig_ConsumptionMeteringConfig)(nil), // 145: google.container.v1beta1.ResourceUsageExportConfig.ConsumptionMeteringConfig
	(*NotificationConfig_PubSub)(nil),                           // 146: google.container.v1beta1.NotificationConfig.PubSub
	(*wrapperspb.BoolValue)(nil),                                // 147: google.protobuf.BoolValue
	(*status.Status)(nil),                                       // 148: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                               // 149: google.protobuf.Timestamp
	(code.Code)(0),                                              // 150: google.rpc.Code
	(*emptypb.Empty)(nil),                                       // 151: google.protobuf.Empty
}
var file_google_container_v1beta1_cluster_service_proto_depIdxs = []int32{
	133, // 0: google.container.v1beta1.LinuxNodeConfig.sysctls:type_name -> google.container.v1beta1.LinuxNodeConfig.SysctlsEntry
	147, // 1: google.container.v1beta1.NodeKubeletConfig.cpu_cfs_quota:type_name -> google.protobuf.BoolValue
	134, // 2: google.container.v1beta1.NodeConfig.metadata:type_name -> google.container.v1beta1.NodeConfig.MetadataEntry
	135, // 3: google.container.v1beta1.NodeConfig.labels:type_name -> google.container.v1beta1.NodeConfig.LabelsEntry
	101, // 4: google.container.v1beta1.NodeConfig.accelerators:type_name -> google.container.v1beta1.AcceleratorConfig
	26,  // 5: google.container.v1beta1.NodeConfig.sandbox_config:type_name -> google.container.v1beta1.SandboxConfig
	28,  // 6: google.container.v1beta1.NodeConfig.reservation_affinity:type_name -> google.container.v1beta1.ReservationAffinity
	102, // 7: google.container.v1beta1.NodeConfig.workload_metadata_config:type_name -> google.container.v1beta1.WorkloadMetadataConfig
	29,  // 8: google.container.v1beta1.NodeConfig.taints:type_name -> google.container.v1beta1.NodeTaint
	25,  // 9: google.container.v1beta1.NodeConfig.shielded_instance_config:type_name -> google.container.v1beta1.ShieldedInstanceConfig
	22,  // 10: google.container.v1beta1.NodeConfig.linux_node_config:type_name -> google.container.v1beta1.LinuxNodeConfig
	23,  // 11: google.container.v1beta1.NodeConfig.kubelet_config:type_name -> google.container.v1beta1.NodeKubeletConfig
	27,  // 12: google.container.v1beta1.NodeConfig.ephemeral_storage_config:type_name -> google.container.v1beta1.EphemeralStorageConfig
	2,   // 13: google.container.v1beta1.SandboxConfig.type:type_name -> google.container.v1beta1.SandboxConfig.Type
	3,   // 14: google.container.v1beta1.ReservationAffinity.consume_reservation_type:type_name -> google.container.v1beta1.ReservationAffinity.Type
	4,   // 15: google.container.v1beta1.NodeTaint.effect:type_name -> google.container.v1beta1.NodeTaint.Effect
	31,  // 16: google.container.v1beta1.MasterAuth.client_certificate_config:type_name -> google.container.v1beta1.ClientCertificateConfig
	33,  // 17: google.container.v1beta1.AddonsConfig.http_load_balancing:type_name -> google.container.v1beta1.HttpLoadBalancing
	34,  // 18: google.container.v1beta1.AddonsConfig.horizontal_pod_autoscaling:type_name -> google.container.v1beta1.HorizontalPodAutoscaling
	35,  // 19: google.container.v1beta1.AddonsConfig.kubernetes_dashboard:type_name -> google.container.v1beta1.KubernetesDashboard
	36,  // 20: google.container.v1beta1.AddonsConfig.network_policy_config:type_name -> google.container.v1beta1.NetworkPolicyConfig
	43,  // 21: google.container.v1beta1.AddonsConfig.istio_config:type_name -> google.container.v1beta1.IstioConfig
	44,  // 22: google.container.v1beta1.AddonsConfig.cloud_run_config:type_name -> google.container.v1beta1.CloudRunConfig
	37,  // 23: google.container.v1beta1.AddonsConfig.dns_cache_config:type_name -> google.container.v1beta1.DnsCacheConfig
	39,  // 24: google.container.v1beta1.AddonsConfig.config_connector_config:type_name -> google.container.v1beta1.ConfigConnectorConfig
	40,  // 25: google.container.v1beta1.AddonsConfig.gce_persistent_disk_csi_driver_config:type_name -> google.container.v1beta1.GcePersistentDiskCsiDriverConfig
	38,  // 26: google.container.v1beta1.AddonsConfig.kalm_config:type_name -> google.container.v1beta1.KalmConfig
	41,  // 27: google.container.v1beta1.PrivateClusterConfig.master_global_access_config:type_name -> google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
	5,   // 28: google.container.v1beta1.IstioConfig.auth:type_name -> google.container.v1beta1.IstioConfig.IstioAuthMode
	6,   // 29: google.container.v1beta1.CloudRunConfig.load_balancer_type:type_name -> google.container.v1beta1.CloudRunConfig.LoadBalancerType
	136, // 30: google.container.v1beta1.MasterAuthorizedNetworksConfig.cidr_blocks:type_name -> google.container.v1beta1.MasterAuthorizedNetworksConfig.CidrBlock
	7,   // 31: google.container.v1beta1.NetworkPolicy.provider:type_name -> google.container.v1beta1.NetworkPolicy.Provider
	8,   // 32: google.container.v1beta1.ClusterTelemetry.type:type_name -> google.container.v1beta1.ClusterTelemetry.Type
	24,  // 33: google.container.v1beta1.Cluster.node_config:type_name -> google.container.v1beta1.NodeConfig
	30,  // 34: google.container.v1beta1.Cluster.master_auth:type_name -> google.container.v1beta1.MasterAuth
	32,  // 35: google.container.v1beta1.Cluster.addons_config:type_name -> google.container.v1beta1.AddonsConfig
	81,  // 36: google.container.v1beta1.Cluster.node_pools:type_name -> google.container.v1beta1.NodePool
	137, // 37: google.container.v1beta1.Cluster.resource_labels:type_name -> google.container.v1beta1.Cluster.ResourceLabelsEntry
	46,  // 38: google.container.v1beta1.Cluster.legacy_abac:type_name -> google.container.v1beta1.LegacyAbac
	47,  // 39: google.container.v1beta1.Cluster.network_policy:type_name -> google.container.v1beta1.NetworkPolicy
	48,  // 40: google.container.v1beta1.Cluster.ip_allocation_policy:type_name -> google.container.v1beta1.IPAllocationPolicy
	45,  // 41: google.container.v1beta1.Cluster.master_authorized_networks_config:type_name -> google.container.v1beta1.MasterAuthorizedNetworksConfig
	84,  // 42: google.container.v1beta1.Cluster.maintenance_policy:type_name -> google.container.v1beta1.MaintenancePolicy
	49,  // 43: google.container.v1beta1.Cluster.binary_authorization:type_name -> google.container.v1beta1.BinaryAuthorization
	50,  // 44: google.container.v1beta1.Cluster.pod_security_policy_config:type_name -> google.container.v1beta1.PodSecurityPolicyConfig
	93,  // 45: google.container.v1beta1.Cluster.autoscaling:type_name -> google.container.v1beta1.ClusterAutoscaling
	109, // 46: google.container.v1beta1.Cluster.network_config:type_name -> google.container.v1beta1.NetworkConfig
	117, // 47: google.container.v1beta1.Cluster.default_max_pods_constraint:type_name -> google.container.v1beta1.MaxPodsConstraint
	120, // 48: google.container.v1beta1.Cluster.resource_usage_export_config:type_name -> google.container.v1beta1.ResourceUsageExportConfig
	51,  // 49: google.container.v1beta1.Cluster.authenticator_groups_config:type_name -> google.container.v1beta1.AuthenticatorGroupsConfig
	42,  // 50: google.container.v1beta1.Cluster.private_cluster_config:type_name -> google.container.v1beta1.PrivateClusterConfig
	114, // 51: google.container.v1beta1.Cluster.vertical_pod_autoscaling:type_name -> google.container.v1beta1.VerticalPodAutoscaling
	121, // 52: google.container.v1beta1.Cluster.shielded_nodes:type_name -> google.container.v1beta1.ShieldedNodes
	127, // 53: google.container.v1beta1.Cluster.release_channel:type_name -> google.container.v1beta1.ReleaseChannel
	118, // 54: google.container.v1beta1.Cluster.workload_identity_config:type_name -> google.container.v1beta1.WorkloadIdentityConfig
	52,  // 55: google.container.v1beta1.Cluster.cluster_telemetry:type_name -> google.container.v1beta1.ClusterTelemetry
	128, // 56: google.container.v1beta1.Cluster.tpu_config:type_name -> google.container.v1beta1.TpuConfig
	130, // 57: google.container.v1beta1.Cluster.notification_config:type_name -> google.container.v1beta1.NotificationConfig
	131, // 58: google.container.v1beta1.Cluster.confidential_nodes:type_name -> google.container.v1beta1.ConfidentialNodes
	9,   // 59: google.container.v1beta1.Cluster.status:type_name -> google.container.v1beta1.Cluster.Status
	119, // 60: google.container.v1beta1.Cluster.database_encryption:type_name -> google.container.v1beta1.DatabaseEncryption
	108, // 61: google.container.v1beta1.Cluster.conditions:type_name -> google.container.v1beta1.StatusCondition
	129, // 62: google.container.v1beta1.Cluster.master:type_name -> google.container.v1beta1.Master
	32,  // 63: google.container.v1beta1.ClusterUpdate.desired_addons_config:type_name -> google.container.v1beta1.AddonsConfig
	96,  // 64: google.container.v1beta1.ClusterUpdate.desired_node_pool_autoscaling:type_name -> google.container.v1beta1.NodePoolAutoscaling
	45,  // 65: google.container.v1beta1.ClusterUpdate.desired_master_authorized_networks_config:type_name -> google.container.v1beta1.MasterAuthorizedNetworksConfig
	50,  // 66: google.container.v1beta1.ClusterUpdate.desired_pod_security_policy_config:type_name -> google.container.v1beta1.PodSecurityPolicyConfig
	93,  // 67: google.container.v1beta1.ClusterUpdate.desired_cluster_autoscaling:type_name -> google.container.v1beta1.ClusterAutoscaling
	49,  // 68: google.container.v1beta1.ClusterUpdate.desired_binary_authorization:type_name -> google.container.v1beta1.BinaryAuthorization
	120, // 69: google.container.v1beta1.ClusterUpdate.desired_resource_usage_export_config:type_name -> google.container.v1beta1.ResourceUsageExportConfig
	114, // 70: google.container.v1beta1.ClusterUpdate.desired_vertical_pod_autoscaling:type_name -> google.container.v1beta1.VerticalPodAutoscaling
	42,  // 71: google.container.v1beta1.ClusterUpdate.desired_private_cluster_config:type_name -> google.container.v1beta1.PrivateClusterConfig
	116, // 72: google.container.v1beta1.ClusterUpdate.desired_intra_node_visibility_config:type_name -> google.container.v1beta1.IntraNodeVisibilityConfig
	115, // 73: google.container.v1beta1.ClusterUpdate.desired_default_snat_status:type_name -> google.container.v1beta1.DefaultSnatStatus
	52,  // 74: google.container.v1beta1.ClusterUpdate.desired_cluster_telemetry:type_name -> google.container.v1beta1.ClusterTelemetry
	127, // 75: google.container.v1beta1.ClusterUpdate.desired_release_channel:type_name -> google.container.v1beta1.ReleaseChannel
	128, // 76: google.container.v1beta1.ClusterUpdate.desired_tpu_config:type_name -> google.container.v1beta1.TpuConfig
	0,   // 77: google.container.v1beta1.ClusterUpdate.desired_datapath_provider:type_name -> google.container.v1beta1.DatapathProvider
	130, // 78: google.container.v1beta1.ClusterUpdate.desired_notification_config:type_name -> google.container.v1beta1.NotificationConfig
	119, // 79: google.container.v1beta1.ClusterUpdate.desired_database_encryption:type_name -> google.container.v1beta1.DatabaseEncryption
	118, // 80: google.container.v1beta1.ClusterUpdate.desired_workload_identity_config:type_name -> google.container.v1beta1.WorkloadIdentityConfig
	121, // 81: google.container.v1beta1.ClusterUpdate.desired_shielded_nodes:type_name -> google.container.v1beta1.ShieldedNodes
	129, // 82: google.container.v1beta1.ClusterUpdate.desired_master:type_name -> google.container.v1beta1.Master
	51,  // 83: google.container.v1beta1.ClusterUpdate.desired_authenticator_groups_config:type_name -> google.container.v1beta1.AuthenticatorGroupsConfig
	11,  // 84: google.container.v1beta1.Operation.operation_type:type_name -> google.container.v1beta1.Operation.Type
	10,  // 85: google.container.v1beta1.Operation.status:type_name -> google.container.v1beta1.Operation.Status
	56,  // 86: google.container.v1beta1.Operation.progress:type_name -> google.container.v1beta1.OperationProgress
	108, // 87: google.container.v1beta1.Operation.cluster_conditions:type_name -> google.container.v1beta1.StatusCondition
	108, // 88: google.container.v1beta1.Operation.nodepool_conditions:type_name -> google.container.v1beta1.StatusCondition
	148, // 89: google.container.v1beta1.Operation.error:type_name -> google.rpc.Status
	10,  // 90: google.container.v1beta1.OperationProgress.status:type_name -> google.container.v1beta1.Operation.Status
	138, // 91: google.container.v1beta1.OperationProgress.metrics:type_name -> google.container.v1beta1.OperationProgress.Metric
	56,  // 92: google.container.v1beta1.OperationProgress.stages:type_name -> google.container.v1beta1.OperationProgress
	53,  // 93: google.container.v1beta1.CreateClusterRequest.cluster:type_name -> google.container.v1beta1.Cluster
	54,  // 94: google.container.v1beta1.UpdateClusterRequest.update:type_name -> google.container.v1beta1.ClusterUpdate
	102, // 95: google.container.v1beta1.UpdateNodePoolRequest.workload_metadata_config:type_name -> google.container.v1beta1.WorkloadMetadataConfig
	141, // 96: google.container.v1beta1.UpdateNodePoolRequest.upgrade_settings:type_name -> google.container.v1beta1.NodePool.UpgradeSettings
	22,  // 97: google.container.v1beta1.UpdateNodePoolRequest.linux_node_config:type_name -> google.container.v1beta1.LinuxNodeConfig
	23,  // 98: google.container.v1beta1.UpdateNodePoolRequest.kubelet_config:type_name -> google.container.v1beta1.NodeKubeletConfig
	96,  // 99: google.container.v1beta1.SetNodePoolAutoscalingRequest.autoscaling:type_name -> google.container.v1beta1.NodePoolAutoscaling
	32,  // 100: google.container.v1beta1.SetAddonsConfigRequest.addons_config:type_name -> google.container.v1beta1.AddonsConfig
	12,  // 101: google.container.v1beta1.SetMasterAuthRequest.action:type_name -> google.container.v1beta1.SetMasterAuthRequest.Action
	30,  // 102: google.container.v1beta1.SetMasterAuthRequest.update:type_name -> google.container.v1beta1.MasterAuth
	53,  // 103: google.container.v1beta1.ListClustersResponse.clusters:type_name -> google.container.v1beta1.Cluster
	55,  // 104: google.container.v1beta1.ListOperationsResponse.operations:type_name -> google.container.v1beta1.Operation
	139, // 105: google.container.v1beta1.ServerConfig.channels:type_name -> google.container.v1beta1.ServerConfig.ReleaseChannelConfig
	81,  // 106: google.container.v1beta1.CreateNodePoolRequest.node_pool:type_name -> google.container.v1beta1.NodePool
	24,  // 107: google.container.v1beta1.NodePool.config:type_name -> google.container.v1beta1.NodeConfig
	13,  // 108: google.container.v1beta1.NodePool.status:type_name -> google.container.v1beta1.NodePool.Status
	96,  // 109: google.container.v1beta1.NodePool.autoscaling:type_name -> google.container.v1beta1.NodePoolAutoscaling
	82,  // 110: google.container.v1beta1.NodePool.management:type_name -> google.container.v1beta1.NodeManagement
	117, // 111: google.container.v1beta1.NodePool.max_pods_constraint:type_name -> google.container.v1beta1.MaxPodsConstraint
	108, // 112: google.container.v1beta1.NodePool.conditions:type_name -> google.container.v1beta1.StatusCondition
	141, // 113: google.container.v1beta1.NodePool.upgrade_settings:type_name -> google.container.v1beta1.NodePool.UpgradeSettings
	83,  // 114: google.container.v1beta1.NodeManagement.upgrade_options:type_name -> google.container.v1beta1.AutoUpgradeOptions
	85,  // 115: google.container.v1beta1.MaintenancePolicy.window:type_name -> google.container.v1beta1.MaintenanceWindow
	88,  // 116: google.container.v1beta1.MaintenanceWindow.daily_maintenance_window:type_name -> google.container.v1beta1.DailyMaintenanceWindow
	87,  // 117: google.container.v1beta1.MaintenanceWindow.recurring_window:type_name -> google.container.v1beta1.RecurringTimeWindow
	142, // 118: google.container.v1beta1.MaintenanceWindow.maintenance_exclusions:type_name -> google.container.v1beta1.MaintenanceWindow.MaintenanceExclusionsEntry
	149, // 119: google.container.v1beta1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	149, // 120: google.container.v1beta1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	86,  // 121: google.container.v1beta1.RecurringTimeWindow.window:type_name -> google.container.v1beta1.TimeWindow
	82,  // 122: google.container.v1beta1.SetNodePoolManagementRequest.management:type_name -> google.container.v1beta1.NodeManagement
	81,  // 123: google.container.v1beta1.ListNodePoolsResponse.node_pools:type_name -> google.container.v1beta1.NodePool
	95,  // 124: google.container.v1beta1.ClusterAutoscaling.resource_limits:type_name -> google.container.v1beta1.ResourceLimit
	14,  // 125: google.container.v1beta1.ClusterAutoscaling.autoscaling_profile:type_name -> google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile
	94,  // 126: google.container.v1beta1.ClusterAutoscaling.autoprovisioning_node_pool_defaults:type_name -> google.container.v1beta1.AutoprovisioningNodePoolDefaults
	141, // 127: google.container.v1beta1.AutoprovisioningNodePoolDefaults.upgrade_settings:type_name -> google.container.v1beta1.NodePool.UpgradeSettings
	82,  // 128: google.container.v1beta1.AutoprovisioningNodePoolDefaults.management:type_name -> google.container.v1beta1.NodeManagement
	25,  // 129: google.container.v1beta1.AutoprovisioningNodePoolDefaults.shielded_instance_config:type_name -> google.container.v1beta1.ShieldedInstanceConfig
	143, // 130: google.container.v1beta1.SetLabelsRequest.resource_labels:type_name -> google.container.v1beta1.SetLabelsRequest.ResourceLabelsEntry
	15,  // 131: google.container.v1beta1.WorkloadMetadataConfig.node_metadata:type_name -> google.container.v1beta1.WorkloadMetadataConfig.NodeMetadata
	16,  // 132: google.container.v1beta1.WorkloadMetadataConfig.mode:type_name -> google.container.v1beta1.WorkloadMetadataConfig.Mode
	47,  // 133: google.container.v1beta1.SetNetworkPolicyRequest.network_policy:type_name -> google.container.v1beta1.NetworkPolicy
	84,  // 134: google.container.v1beta1.SetMaintenancePolicyRequest.maintenance_policy:type_name -> google.container.v1beta1.MaintenancePolicy
	107, // 135: google.container.v1beta1.ListLocationsResponse.locations:type_name -> google.container.v1beta1.Location
	17,  // 136: google.container.v1beta1.Location.type:type_name -> google.container.v1beta1.Location.LocationType
	18,  // 137: google.container.v1beta1.StatusCondition.code:type_name -> google.container.v1beta1.StatusCondition.Code
	150, // 138: google.container.v1beta1.StatusCondition.canonical_code:type_name -> google.rpc.Code
	115, // 139: google.container.v1beta1.NetworkConfig.default_snat_status:type_name -> google.container.v1beta1.DefaultSnatStatus
	0,   // 140: google.container.v1beta1.NetworkConfig.datapath_provider:type_name -> google.container.v1beta1.DatapathProvider
	113, // 141: google.container.v1beta1.ListUsableSubnetworksResponse.subnetworks:type_name -> google.container.v1beta1.UsableSubnetwork
	19,  // 142: google.container.v1beta1.UsableSubnetworkSecondaryRange.status:type_name -> google.container.v1beta1.UsableSubnetworkSecondaryRange.Status
	112, // 143: google.container.v1beta1.UsableSubnetwork.secondary_ip_ranges:type_name -> google.container.v1beta1.UsableSubnetworkSecondaryRange
	20,  // 144: google.container.v1beta1.DatabaseEncryption.state:type_name -> google.container.v1beta1.DatabaseEncryption.State
	144, // 145: google.container.v1beta1.ResourceUsageExportConfig.bigquery_destination:type_name -> google.container.v1beta1.ResourceUsageExportConfig.BigQueryDestination
	145, // 146: google.container.v1beta1.ResourceUsageExportConfig.consumption_metering_config:type_name -> google.container.v1beta1.ResourceUsageExportConfig.ConsumptionMeteringConfig
	125, // 147: google.container.v1beta1.GetJSONWebKeysResponse.keys:type_name -> google.container.v1beta1.Jwk
	21,  // 148: google.container.v1beta1.ReleaseChannel.channel:type_name -> google.container.v1beta1.ReleaseChannel.Channel
	146, // 149: google.container.v1beta1.NotificationConfig.pubsub:type_name -> google.container.v1beta1.NotificationConfig.PubSub
	1,   // 150: google.container.v1beta1.UpgradeEvent.resource_type:type_name -> google.container.v1beta1.UpgradeResourceType
	149, // 151: google.container.v1beta1.UpgradeEvent.operation_start_time:type_name -> google.protobuf.Timestamp
	21,  // 152: google.container.v1beta1.ServerConfig.ReleaseChannelConfig.channel:type_name -> google.container.v1beta1.ReleaseChannel.Channel
	140, // 153: google.container.v1beta1.ServerConfig.ReleaseChannelConfig.available_versions:type_name -> google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
	86,  // 154: google.container.v1beta1.MaintenanceWindow.MaintenanceExclusionsEntry.value:type_name -> google.container.v1beta1.TimeWindow
	69,  // 155: google.container.v1beta1.ClusterManager.ListClusters:input_type -> google.container.v1beta1.ListClustersRequest
	58,  // 156: google.container.v1beta1.ClusterManager.GetCluster:input_type -> google.container.v1beta1.GetClusterRequest
	57,  // 157: google.container.v1beta1.ClusterManager.CreateCluster:input_type -> google.container.v1beta1.CreateClusterRequest
	59,  // 158: google.container.v1beta1.ClusterManager.UpdateCluster:input_type -> google.container.v1beta1.UpdateClusterRequest
	60,  // 159: google.container.v1beta1.ClusterManager.UpdateNodePool:input_type -> google.container.v1beta1.UpdateNodePoolRequest
	61,  // 160: google.container.v1beta1.ClusterManager.SetNodePoolAutoscaling:input_type -> google.container.v1beta1.SetNodePoolAutoscalingRequest
	62,  // 161: google.container.v1beta1.ClusterManager.SetLoggingService:input_type -> google.container.v1beta1.SetLoggingServiceRequest
	63,  // 162: google.container.v1beta1.ClusterManager.SetMonitoringService:input_type -> google.container.v1beta1.SetMonitoringServiceRequest
	64,  // 163: google.container.v1beta1.ClusterManager.SetAddonsConfig:input_type -> google.container.v1beta1.SetAddonsConfigRequest
	65,  // 164: google.container.v1beta1.ClusterManager.SetLocations:input_type -> google.container.v1beta1.SetLocationsRequest
	66,  // 165: google.container.v1beta1.ClusterManager.UpdateMaster:input_type -> google.container.v1beta1.UpdateMasterRequest
	67,  // 166: google.container.v1beta1.ClusterManager.SetMasterAuth:input_type -> google.container.v1beta1.SetMasterAuthRequest
	68,  // 167: google.container.v1beta1.ClusterManager.DeleteCluster:input_type -> google.container.v1beta1.DeleteClusterRequest
	72,  // 168: google.container.v1beta1.ClusterManager.ListOperations:input_type -> google.container.v1beta1.ListOperationsRequest
	71,  // 169: google.container.v1beta1.ClusterManager.GetOperation:input_type -> google.container.v1beta1.GetOperationRequest
	73,  // 170: google.container.v1beta1.ClusterManager.CancelOperation:input_type -> google.container.v1beta1.CancelOperationRequest
	75,  // 171: google.container.v1beta1.ClusterManager.GetServerConfig:input_type -> google.container.v1beta1.GetServerConfigRequest
	79,  // 172: google.container.v1beta1.ClusterManager.ListNodePools:input_type -> google.container.v1beta1.ListNodePoolsRequest
	124, // 173: google.container.v1beta1.ClusterManager.GetJSONWebKeys:input_type -> google.container.v1beta1.GetJSONWebKeysRequest
	80,  // 174: google.container.v1beta1.ClusterManager.GetNodePool:input_type -> google.container.v1beta1.GetNodePoolRequest
	77,  // 175: google.container.v1beta1.ClusterManager.CreateNodePool:input_type -> google.container.v1beta1.CreateNodePoolRequest
	78,  // 176: google.container.v1beta1.ClusterManager.DeleteNodePool:input_type -> google.container.v1beta1.DeleteNodePoolRequest
	91,  // 177: google.container.v1beta1.ClusterManager.RollbackNodePoolUpgrade:input_type -> google.container.v1beta1.RollbackNodePoolUpgradeRequest
	89,  // 178: google.container.v1beta1.ClusterManager.SetNodePoolManagement:input_type -> google.container.v1beta1.SetNodePoolManagementRequest
	97,  // 179: google.container.v1beta1.ClusterManager.SetLabels:input_type -> google.container.v1beta1.SetLabelsRequest
	98,  // 180: google.container.v1beta1.ClusterManager.SetLegacyAbac:input_type -> google.container.v1beta1.SetLegacyAbacRequest
	99,  // 181: google.container.v1beta1.ClusterManager.StartIPRotation:input_type -> google.container.v1beta1.StartIPRotationRequest
	100, // 182: google.container.v1beta1.ClusterManager.CompleteIPRotation:input_type -> google.container.v1beta1.CompleteIPRotationRequest
	90,  // 183: google.container.v1beta1.ClusterManager.SetNodePoolSize:input_type -> google.container.v1beta1.SetNodePoolSizeRequest
	103, // 184: google.container.v1beta1.ClusterManager.SetNetworkPolicy:input_type -> google.container.v1beta1.SetNetworkPolicyRequest
	104, // 185: google.container.v1beta1.ClusterManager.SetMaintenancePolicy:input_type -> google.container.v1beta1.SetMaintenancePolicyRequest
	110, // 186: google.container.v1beta1.ClusterManager.ListUsableSubnetworks:input_type -> google.container.v1beta1.ListUsableSubnetworksRequest
	105, // 187: google.container.v1beta1.ClusterManager.ListLocations:input_type -> google.container.v1beta1.ListLocationsRequest
	70,  // 188: google.container.v1beta1.ClusterManager.ListClusters:output_type -> google.container.v1beta1.ListClustersResponse
	53,  // 189: google.container.v1beta1.ClusterManager.GetCluster:output_type -> google.container.v1beta1.Cluster
	55,  // 190: google.container.v1beta1.ClusterManager.CreateCluster:output_type -> google.container.v1beta1.Operation
	55,  // 191: google.container.v1beta1.ClusterManager.UpdateCluster:output_type -> google.container.v1beta1.Operation
	55,  // 192: google.container.v1beta1.ClusterManager.UpdateNodePool:output_type -> google.container.v1beta1.Operation
	55,  // 193: google.container.v1beta1.ClusterManager.SetNodePoolAutoscaling:output_type -> google.container.v1beta1.Operation
	55,  // 194: google.container.v1beta1.ClusterManager.SetLoggingService:output_type -> google.container.v1beta1.Operation
	55,  // 195: google.container.v1beta1.ClusterManager.SetMonitoringService:output_type -> google.container.v1beta1.Operation
	55,  // 196: google.container.v1beta1.ClusterManager.SetAddonsConfig:output_type -> google.container.v1beta1.Operation
	55,  // 197: google.container.v1beta1.ClusterManager.SetLocations:output_type -> google.container.v1beta1.Operation
	55,  // 198: google.container.v1beta1.ClusterManager.UpdateMaster:output_type -> google.container.v1beta1.Operation
	55,  // 199: google.container.v1beta1.ClusterManager.SetMasterAuth:output_type -> google.container.v1beta1.Operation
	55,  // 200: google.container.v1beta1.ClusterManager.DeleteCluster:output_type -> google.container.v1beta1.Operation
	74,  // 201: google.container.v1beta1.ClusterManager.ListOperations:output_type -> google.container.v1beta1.ListOperationsResponse
	55,  // 202: google.container.v1beta1.ClusterManager.GetOperation:output_type -> google.container.v1beta1.Operation
	151, // 203: google.container.v1beta1.ClusterManager.CancelOperation:output_type -> google.protobuf.Empty
	76,  // 204: google.container.v1beta1.ClusterManager.GetServerConfig:output_type -> google.container.v1beta1.ServerConfig
	92,  // 205: google.container.v1beta1.ClusterManager.ListNodePools:output_type -> google.container.v1beta1.ListNodePoolsResponse
	126, // 206: google.container.v1beta1.ClusterManager.GetJSONWebKeys:output_type -> google.container.v1beta1.GetJSONWebKeysResponse
	81,  // 207: google.container.v1beta1.ClusterManager.GetNodePool:output_type -> google.container.v1beta1.NodePool
	55,  // 208: google.container.v1beta1.ClusterManager.CreateNodePool:output_type -> google.container.v1beta1.Operation
	55,  // 209: google.container.v1beta1.ClusterManager.DeleteNodePool:output_type -> google.container.v1beta1.Operation
	55,  // 210: google.container.v1beta1.ClusterManager.RollbackNodePoolUpgrade:output_type -> google.container.v1beta1.Operation
	55,  // 211: google.container.v1beta1.ClusterManager.SetNodePoolManagement:output_type -> google.container.v1beta1.Operation
	55,  // 212: google.container.v1beta1.ClusterManager.SetLabels:output_type -> google.container.v1beta1.Operation
	55,  // 213: google.container.v1beta1.ClusterManager.SetLegacyAbac:output_type -> google.container.v1beta1.Operation
	55,  // 214: google.container.v1beta1.ClusterManager.StartIPRotation:output_type -> google.container.v1beta1.Operation
	55,  // 215: google.container.v1beta1.ClusterManager.CompleteIPRotation:output_type -> google.container.v1beta1.Operation
	55,  // 216: google.container.v1beta1.ClusterManager.SetNodePoolSize:output_type -> google.container.v1beta1.Operation
	55,  // 217: google.container.v1beta1.ClusterManager.SetNetworkPolicy:output_type -> google.container.v1beta1.Operation
	55,  // 218: google.container.v1beta1.ClusterManager.SetMaintenancePolicy:output_type -> google.container.v1beta1.Operation
	111, // 219: google.container.v1beta1.ClusterManager.ListUsableSubnetworks:output_type -> google.container.v1beta1.ListUsableSubnetworksResponse
	106, // 220: google.container.v1beta1.ClusterManager.ListLocations:output_type -> google.container.v1beta1.ListLocationsResponse
	188, // [188:221] is the sub-list for method output_type
	155, // [155:188] is the sub-list for method input_type
	155, // [155:155] is the sub-list for extension type_name
	155, // [155:155] is the sub-list for extension extendee
	0,   // [0:155] is the sub-list for field type_name
}

func init() { file_google_container_v1beta1_cluster_service_proto_init() }
func file_google_container_v1beta1_cluster_service_proto_init() {
	if File_google_container_v1beta1_cluster_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_container_v1beta1_cluster_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinuxNodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeKubeletConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShieldedInstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SandboxConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EphemeralStorageConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReservationAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeTaint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientCertificateConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddonsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpLoadBalancing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HorizontalPodAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesDashboard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsCacheConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KalmConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigConnectorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcePersistentDiskCsiDriverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateClusterMasterGlobalAccessConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IstioConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRunConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuthorizedNetworksConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LegacyAbac); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IPAllocationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinaryAuthorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PodSecurityPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticatorGroupsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterTelemetry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetNodePoolAutoscalingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetLoggingServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMonitoringServiceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetAddonsConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetLocationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMasterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMasterAuthRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOperationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelOperationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServerConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodePoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeManagement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoUpgradeOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenancePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecurringTimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyMaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetNodePoolManagementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetNodePoolSizeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackNodePoolUpgradeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodePoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoprovisioningNodePoolDefaults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodePoolAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetLegacyAbacRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartIPRotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteIPRotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcceleratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadMetadataConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMaintenancePolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLocationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLocationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableSubnetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableSubnetworksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsableSubnetworkSecondaryRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsableSubnetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerticalPodAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultSnatStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntraNodeVisibilityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaxPodsConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadIdentityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceUsageExportConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShieldedNodes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOpenIDConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOpenIDConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJSONWebKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Jwk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJSONWebKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TpuConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Master); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfidentialNodes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterAuthorizedNetworksConfig_CidrBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationProgress_Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerConfig_ReleaseChannelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerConfig_ReleaseChannelConfig_AvailableVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodePool_UpgradeSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceUsageExportConfig_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceUsageExportConfig_ConsumptionMeteringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_container_v1beta1_cluster_service_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationConfig_PubSub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_container_v1beta1_cluster_service_proto_msgTypes[63].OneofWrappers = []interface{}{
		(*MaintenanceWindow_DailyMaintenanceWindow)(nil),
		(*MaintenanceWindow_RecurringWindow)(nil),
	}
	file_google_container_v1beta1_cluster_service_proto_msgTypes[116].OneofWrappers = []interface{}{
		(*OperationProgress_Metric_IntValue)(nil),
		(*OperationProgress_Metric_DoubleValue)(nil),
		(*OperationProgress_Metric_StringValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_container_v1beta1_cluster_service_proto_rawDesc,
			NumEnums:      22,
			NumMessages:   125,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_container_v1beta1_cluster_service_proto_goTypes,
		DependencyIndexes: file_google_container_v1beta1_cluster_service_proto_depIdxs,
		EnumInfos:         file_google_container_v1beta1_cluster_service_proto_enumTypes,
		MessageInfos:      file_google_container_v1beta1_cluster_service_proto_msgTypes,
	}.Build()
	File_google_container_v1beta1_cluster_service_proto = out.File
	file_google_container_v1beta1_cluster_service_proto_rawDesc = nil
	file_google_container_v1beta1_cluster_service_proto_goTypes = nil
	file_google_container_v1beta1_cluster_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterManagerClient is the client API for ClusterManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details for a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default
	// network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the Kubelet creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range the cluster is using.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings for a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the version and/or image type of a specific node pool.
	UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deprecated: Do not use.
	// Sets the locations for a specific cluster.
	// Deprecated. Use
	// [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters/update)
	// instead.
	SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets master auth materials. Currently supports changing the admin password
	// or a specific cluster, either via password generation or explicitly setting
	// the password.
	SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster,
	// such as load balancer resources, are not deleted if they weren't present
	// when the cluster was initially created.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in the specified zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns configuration info about the Google Kubernetes Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	// This API is not yet intended for general use, and is not available for all
	// clusters.
	GetJSONWebKeys(ctx context.Context, in *GetJSONWebKeysRequest, opts ...grpc.CallOption) (*GetJSONWebKeysResponse, error)
	// Retrieves the requested node pool.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Rolls back a previously Aborted or Failed NodePool upgrade.
	// This makes no changes if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts master IP rotation.
	StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables Network Policy for a cluster.
	SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists subnetworks that can be used for creating clusters in a project.
	ListUsableSubnetworks(ctx context.Context, in *ListUsableSubnetworksRequest, opts ...grpc.CallOption) (*ListUsableSubnetworksResponse, error)
	// Fetches locations that offer Google Kubernetes Engine.
	ListLocations(ctx context.Context, in *ListLocationsRequest, opts ...grpc.CallOption) (*ListLocationsResponse, error)
}

type clusterManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterManagerClient(cc grpc.ClientConnInterface) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateNodePool(ctx context.Context, in *UpdateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolAutoscaling(ctx context.Context, in *SetNodePoolAutoscalingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolAutoscaling", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLoggingService(ctx context.Context, in *SetLoggingServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLoggingService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMonitoringService(ctx context.Context, in *SetMonitoringServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMonitoringService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetAddonsConfig(ctx context.Context, in *SetAddonsConfigRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetAddonsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *clusterManagerClient) SetLocations(ctx context.Context, in *SetLocationsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateMaster(ctx context.Context, in *UpdateMasterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/UpdateMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMasterAuth", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CancelOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListNodePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetJSONWebKeys(ctx context.Context, in *GetJSONWebKeysRequest, opts ...grpc.CallOption) (*GetJSONWebKeysResponse, error) {
	out := new(GetJSONWebKeysResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetJSONWebKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/GetNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CreateNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/DeleteNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/RollbackNodePoolUpgrade", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolManagement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetLegacyAbac", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/StartIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/CompleteIPRotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolSize(ctx context.Context, in *SetNodePoolSizeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNodePoolSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNetworkPolicy(ctx context.Context, in *SetNetworkPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMaintenancePolicy(ctx context.Context, in *SetMaintenancePolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/SetMaintenancePolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListUsableSubnetworks(ctx context.Context, in *ListUsableSubnetworksRequest, opts ...grpc.CallOption) (*ListUsableSubnetworksResponse, error) {
	out := new(ListUsableSubnetworksResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListUsableSubnetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListLocations(ctx context.Context, in *ListLocationsRequest, opts ...grpc.CallOption) (*ListLocationsResponse, error) {
	out := new(ListLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.container.v1beta1.ClusterManager/ListLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterManagerServer is the server API for ClusterManager service.
type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details for a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default
	// network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the Kubelet creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range the cluster is using.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings for a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Updates the version and/or image type of a specific node pool.
	UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*Operation, error)
	// Sets the autoscaling settings of a specific node pool.
	SetNodePoolAutoscaling(context.Context, *SetNodePoolAutoscalingRequest) (*Operation, error)
	// Sets the logging service for a specific cluster.
	SetLoggingService(context.Context, *SetLoggingServiceRequest) (*Operation, error)
	// Sets the monitoring service for a specific cluster.
	SetMonitoringService(context.Context, *SetMonitoringServiceRequest) (*Operation, error)
	// Sets the addons for a specific cluster.
	SetAddonsConfig(context.Context, *SetAddonsConfigRequest) (*Operation, error)
	// Deprecated: Do not use.
	// Sets the locations for a specific cluster.
	// Deprecated. Use
	// [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters/update)
	// instead.
	SetLocations(context.Context, *SetLocationsRequest) (*Operation, error)
	// Updates the master for a specific cluster.
	UpdateMaster(context.Context, *UpdateMasterRequest) (*Operation, error)
	// Sets master auth materials. Currently supports changing the admin password
	// or a specific cluster, either via password generation or explicitly setting
	// the password.
	SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster,
	// such as load balancer resources, are not deleted if they weren't present
	// when the cluster was initially created.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in the specified zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(context.Context, *CancelOperationRequest) (*emptypb.Empty, error)
	// Returns configuration info about the Google Kubernetes Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	// This API is not yet intended for general use, and is not available for all
	// clusters.
	GetJSONWebKeys(context.Context, *GetJSONWebKeysRequest) (*GetJSONWebKeysResponse, error)
	// Retrieves the requested node pool.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error)
	// Rolls back a previously Aborted or Failed NodePool upgrade.
	// This makes no changes if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(context.Context, *SetLabelsRequest) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error)
	// Starts master IP rotation.
	StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error)
	// Sets the size for a specific node pool.
	SetNodePoolSize(context.Context, *SetNodePoolSizeRequest) (*Operation, error)
	// Enables or disables Network Policy for a cluster.
	SetNetworkPolicy(context.Context, *SetNetworkPolicyRequest) (*Operation, error)
	// Sets the maintenance policy for a cluster.
	SetMaintenancePolicy(context.Context, *SetMaintenancePolicyRequest) (*Operation, error)
	// Lists subnetworks that can be used for creating clusters in a project.
	ListUsableSubnetworks(context.Context, *ListUsableSubnetworksRequest) (*ListUsableSubnetworksResponse, error)
	// Fetches locations that offer Google Kubernetes Engine.
	ListLocations(context.Context, *ListLocationsRequest) (*ListLocationsResponse, error)
}

// UnimplementedClusterManagerServer can be embedded to have forward compatible implementations.
type UnimplementedClusterManagerServer struct {
}

func (*UnimplementedClusterManagerServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedClusterManagerServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClusterManagerServer) CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateNodePool(context.Context, *UpdateNodePoolRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolAutoscaling(context.Context, *SetNodePoolAutoscalingRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetNodePoolAutoscaling not implemented")
}
func (*UnimplementedClusterManagerServer) SetLoggingService(context.Context, *SetLoggingServiceRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetLoggingService not implemented")
}
func (*UnimplementedClusterManagerServer) SetMonitoringService(context.Context, *SetMonitoringServiceRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetMonitoringService not implemented")
}
func (*UnimplementedClusterManagerServer) SetAddonsConfig(context.Context, *SetAddonsConfigRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetAddonsConfig not implemented")
}
func (*UnimplementedClusterManagerServer) SetLocations(context.Context, *SetLocationsRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetLocations not implemented")
}
func (*UnimplementedClusterManagerServer) UpdateMaster(context.Context, *UpdateMasterRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateMaster not implemented")
}
func (*UnimplementedClusterManagerServer) SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetMasterAuth not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClusterManagerServer) ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterManagerServer) GetOperation(context.Context, *GetOperationRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetOperation not implemented")
}
func (*UnimplementedClusterManagerServer) CancelOperation(context.Context, *CancelOperationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelOperation not implemented")
}
func (*UnimplementedClusterManagerServer) GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetServerConfig not implemented")
}
func (*UnimplementedClusterManagerServer) ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListNodePools not implemented")
}
func (*UnimplementedClusterManagerServer) GetJSONWebKeys(context.Context, *GetJSONWebKeysRequest) (*GetJSONWebKeysResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetJSONWebKeys not implemented")
}
func (*UnimplementedClusterManagerServer) GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteNodePool not implemented")
}
func (*UnimplementedClusterManagerServer) RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RollbackNodePoolUpgrade not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetNodePoolManagement not implemented")
}
func (*UnimplementedClusterManagerServer) SetLabels(context.Context, *SetLabelsRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (*UnimplementedClusterManagerServer) SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetLegacyAbac not implemented")
}
func (*UnimplementedClusterManagerServer) StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method StartIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CompleteIPRotation not implemented")
}
func (*UnimplementedClusterManagerServer) SetNodePoolSize(context.Context, *SetNodePoolSizeRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetNodePoolSize not implemented")
}
func (*UnimplementedClusterManagerServer) SetNetworkPolicy(context.Context, *SetNetworkPolicyRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetNetworkPolicy not implemented")
}
func (*UnimplementedClusterManagerServer) SetMaintenancePolicy(context.Context, *SetMaintenancePolicyRequest) (*Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetMaintenancePolicy not implemented")
}
func (*UnimplementedClusterManagerServer) ListUsableSubnetworks(context.Context, *ListUsableSubnetworksRequest) (*ListUsableSubnetworksResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListUsableSubnetworks not implemented")
}
func (*UnimplementedClusterManagerServer) ListLocations(context.Context, *ListLocationsRequest) (*ListLocationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListLocations not implemented")
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateNodePool(ctx, req.(*UpdateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolAutoscaling_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolAutoscalingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolAutoscaling",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolAutoscaling(ctx, req.(*SetNodePoolAutoscalingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLoggingService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLoggingServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLoggingService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLoggingService(ctx, req.(*SetLoggingServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMonitoringService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMonitoringServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMonitoringService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMonitoringService(ctx, req.(*SetMonitoringServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetAddonsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAddonsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetAddonsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetAddonsConfig(ctx, req.(*SetAddonsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLocations(ctx, req.(*SetLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/UpdateMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateMaster(ctx, req.(*UpdateMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMasterAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMasterAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMasterAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, req.(*SetMasterAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetJSONWebKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJSONWebKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetJSONWebKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetJSONWebKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetJSONWebKeys(ctx, req.(*GetJSONWebKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/GetNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CreateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/DeleteNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_RollbackNodePoolUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackNodePoolUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/RollbackNodePoolUpgrade",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, req.(*RollbackNodePoolUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolManagement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolManagementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolManagement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, req.(*SetNodePoolManagementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLabels(ctx, req.(*SetLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLegacyAbac_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLegacyAbacRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetLegacyAbac",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, req.(*SetLegacyAbacRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_StartIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/StartIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, req.(*StartIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CompleteIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/CompleteIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, req.(*CompleteIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNodePoolSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolSize(ctx, req.(*SetNodePoolSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNetworkPolicy(ctx, req.(*SetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMaintenancePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMaintenancePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/SetMaintenancePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMaintenancePolicy(ctx, req.(*SetMaintenancePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListUsableSubnetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableSubnetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListUsableSubnetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListUsableSubnetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListUsableSubnetworks(ctx, req.(*ListUsableSubnetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1beta1.ClusterManager/ListLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListLocations(ctx, req.(*ListLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1beta1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "UpdateNodePool",
			Handler:    _ClusterManager_UpdateNodePool_Handler,
		},
		{
			MethodName: "SetNodePoolAutoscaling",
			Handler:    _ClusterManager_SetNodePoolAutoscaling_Handler,
		},
		{
			MethodName: "SetLoggingService",
			Handler:    _ClusterManager_SetLoggingService_Handler,
		},
		{
			MethodName: "SetMonitoringService",
			Handler:    _ClusterManager_SetMonitoringService_Handler,
		},
		{
			MethodName: "SetAddonsConfig",
			Handler:    _ClusterManager_SetAddonsConfig_Handler,
		},
		{
			MethodName: "SetLocations",
			Handler:    _ClusterManager_SetLocations_Handler,
		},
		{
			MethodName: "UpdateMaster",
			Handler:    _ClusterManager_UpdateMaster_Handler,
		},
		{
			MethodName: "SetMasterAuth",
			Handler:    _ClusterManager_SetMasterAuth_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _ClusterManager_CancelOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _ClusterManager_ListNodePools_Handler,
		},
		{
			MethodName: "GetJSONWebKeys",
			Handler:    _ClusterManager_GetJSONWebKeys_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _ClusterManager_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _ClusterManager_CreateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _ClusterManager_DeleteNodePool_Handler,
		},
		{
			MethodName: "RollbackNodePoolUpgrade",
			Handler:    _ClusterManager_RollbackNodePoolUpgrade_Handler,
		},
		{
			MethodName: "SetNodePoolManagement",
			Handler:    _ClusterManager_SetNodePoolManagement_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ClusterManager_SetLabels_Handler,
		},
		{
			MethodName: "SetLegacyAbac",
			Handler:    _ClusterManager_SetLegacyAbac_Handler,
		},
		{
			MethodName: "StartIPRotation",
			Handler:    _ClusterManager_StartIPRotation_Handler,
		},
		{
			MethodName: "CompleteIPRotation",
			Handler:    _ClusterManager_CompleteIPRotation_Handler,
		},
		{
			MethodName: "SetNodePoolSize",
			Handler:    _ClusterManager_SetNodePoolSize_Handler,
		},
		{
			MethodName: "SetNetworkPolicy",
			Handler:    _ClusterManager_SetNetworkPolicy_Handler,
		},
		{
			MethodName: "SetMaintenancePolicy",
			Handler:    _ClusterManager_SetMaintenancePolicy_Handler,
		},
		{
			MethodName: "ListUsableSubnetworks",
			Handler:    _ClusterManager_ListUsableSubnetworks_Handler,
		},
		{
			MethodName: "ListLocations",
			Handler:    _ClusterManager_ListLocations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/container/v1beta1/cluster_service.proto",
}
