#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# Copyright 2024 by Wilson Snyder. This program is free software; you
# can redistribute it and/or modify it under the terms of either the GNU
# Lesser General Public License Version 3 or the Perl Artistic License
# Version 2.0.
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('simulator')
test.top_filename = test.obj_dir + "/t_timing_long.v"

# Look for O(n^2) problems in process handling


def gen(filename):
    with open(filename, 'w', encoding="utf8") as fh:
        fh.write("// Generated by t_timing_long.py\n")

        fh.write("\n")
        fh.write("`ifdef TEST_VERBOSE\n")
        fh.write(" `define MSG(m) $display m\n")
        fh.write("`else\n")
        fh.write(" `define MSG(m)\n")
        fh.write("`endif\n")
        fh.write("\n")

        fh.write("module t;\n")
        fh.write("\n")
        fh.write("  int cnt;\n")
        fh.write("\n")
        fh.write("  initial begin\n")

        n = 100
        for i in range(1, n):
            # If statement around the timing is important to make the code scheduling
            # mostly unpredictable
            fh.write("    if (cnt == " + str(i - 1) + ") begin\n")
            fh.write("      #1; ++cnt; `MSG((\"[%0t] cnt?=" + str(i) + "\", $time));" +
                     " if (cnt != " + str(i) + ") $stop;\n")
            fh.write("    end\n")

        fh.write("\n")
        fh.write('    $write("*-* All Finished *-*\\n");' + "\n")
        fh.write("    $finish;\n")
        fh.write("  end\n")
        fh.write("endmodule\n")


gen(test.top_filename)

if test.have_coroutines:
    test.compile(verilator_flags2=["--binary"], make_top=1)

    test.execute()

test.compile(verilator_flags2=["--binary --no-timing -Wno-STMTDLY"], make_top=1)

test.execute()

test.passes()
