---
myst:
  html_meta:
    keywords: LaTeX,conversion,HeVeA,Tralics,convertir du LaTeX en HTML,MathML, Mathjax, pandoc"
---
# Comment convertir de (La)TeX vers HTML ?


TeX et LaTeX sont bien adaptés à la production de documents publiables
électroniquement (notamment sous la forme de fichiers PDF). Cependant, il est
important de comprendre la différence entre la mise en page et le balisage
fonctionnel. TeX est capable d'une mise 
en page extrêmement détaillée, ce qui n'est pas le cas de HTML qui n’est pas
un langage de mise en page. Le rendu exact du HTML n'est pas spécifié par le
document qui est publié, mais il est, 
dans une certaine mesure, laissé à la discrétion du navigateur. Si vous exigez
de vos lecteurs qu'ils voient une reproduction exacte de l'aspect de votre
document, vous ne pouvez pas utiliser HTML et vous devez utiliser un autre
format de publication tel que le PDF. Cela vaut pour tous les outils de
création HTML. 
  
Les excellentes capacités mathématiques de TeX restent un défi pour la
conversion en HTML. À l'origine, il n'existait que deux techniques généralement
fiables pour générer des mathématiques sur le web : la création de bitmaps de
morceaux de caractères qui ne peuvent pas être traduits et l'utilisation de
symboles et de tableaux. Aucune de ces deux techniques n'est entièrement
satisfaisante. Les bitmaps entraînent une profusion de fichiers minuscules, sont
lents à charger et sont inaccessibles aux personnes souffrant d'un handicap
visuel. Les polices de symboles mathématiques ne permettent pas de composer
l’ensemble des mathématiques et leur
utilisation nécessite une configuration du navigateur. 


Aujourd'hui, avec le rendu natif du [MathML](wpfr:MathML) dans certains
navigateurs et le rendu mathématique de haute qualité disponible via JavaScript
et CSS dans tous les navigateurs graphiques modernes, plusieurs possibilités
s'offrent à nous.

Les convertisseurs LaTeX vers HTML énumérés ci-dessous permettent tous de
composer les mathématiques dans une certaine mesure. Pour plus de détails sur la
gestion des mathématiques sur le web, nous renvoyons à la page
[](/5_fichiers/formats/xml/mathml.md).


Actuellement, il existe plusieurs packages réalisant la conversion (La)TeX vers
HTML :
- [TeX4ht](ctanpkg:tex4ht) est un programme compilé qui prend en charge LaTeX ou Plain
  TeX, en traitant un fichier DVI ; il utilise des bitmaps pour les
  mathématiques, mais peut aussi utiliser d'autres technologies le cas échéant.
  Écrit par Eitan Gurari, il analyse le fichier DVI généré lorsque vous exécutez
  (La)TeX sur votre fichier avec les macros `tex4ht` incluses. Par conséquent,
  il est assez robuste par rapport aux macros que vous incluez dans votre
  document, et il est également assez rapide. 

  Configurer et utiliser `TeX4ht` peut être assez compliqué et le système `make4ht`
  de Michal Hoftich fournit une alternative plus simple d’utilisation,
  utilisant le convertisseur `tex4ht` en interne.
  
- `LaTeXML` fourni par le [NIST](https://www.nist.gov/) est un programme Perl
  qui peut analyser la plupart des codes TeX, y compris les définitions de
  macros compliquées. Il a été utilisé pour générer la version web de
  [DLMF](https://dlmf.nist.gov/) à partir de sources LaTeX. Actuellement, il est
  distribué à partir du site du NIST et ne figure pas dans les distributions TeX
  standard.
-  <ctanpkg:lwarp>, de Brian Dunn, est un convertisseur TeX vers HTML récent qui
   utilise TeX pour analyser le document d'entrée. Les documents peuvent être
   produits par LaTeX, LuaLaTeX ou XeLaTeX. Un script texlua supprime le besoin
   d'utilitaires système tels que `make` et `gawk`, et prend en charge également
   <ctanpkg:xindy> et <ctanpkg:latexmk>.
- [LaTeX2HTML](ctanpkg:latex2html) est une bibliothèque Perl qui ne prend en charge que
  LaTeX et traite les mathématiques (et d'autres «choses difficiles») en
  utilisant des bitmaps. La version originale a été écrite par Nikos Drakos pour
  les systèmes Unix, mais le package a maintenant une liste illustre de
  co-auteurs et est également disponible pour les systèmes Windows.  Michel
  Goossens et Janne Saarela ont publié dans [TUGboat 16(2)]
  (https://www.tug.org/TUGboat/Contents/contents16-2.html) une discussion
  détaillée sur `LaTeX2HTML` et sur la manière de l'adapter.
  
  Une liste de diffusion pour les utilisateurs peut être trouvé sur [le site du
  TUG](https://tug.org/mailman/listinfo/latex2html).

- [Hevea](http://pauillac.inria.fr/~maranget/hevea/) un programme compilé qui ne
  prend en charge que LaTeX, et qui utilise la technique des tableaux et de la police
  de symbole pour les équations (en fait, toute son approche est très similaire
  à `TtH`). Il est écrit en [Objective CAML](wpfr:OCaml) par Luc
  Maranget. `Hevea` n'est pas archivé sur CTAN.
- `TtH` est un programme compilé qui prend en charge soit LaTeX, soit Plain TeX,
  et qui utilise la technique tableaux et de police de symboles pour représenter
  les mathématiques. Il a été écrit par Ian Hutchinson, en utilisant
  [Flex](wpfr:Flex_(logiciel)). La distribution consiste en une source `C`
  unique (ou un exécutable compilé), qui est facile à installer et fonctionne
  très rapidement. Cependant, le HTML résultant n'atteint pas vraiment les
  standards modernes, et seules des mathématiques très simples peuvent être
  converties.
- `plasTeX` est un _framework_ Python permettant le traitement de document
  LaTeX. Il offre un accès de type DOM à un document LaTeX, ainsi que la
  possibilité de générer plusieurs formats de sortie (par exemple HTML, DocBook,
  tBook, etc.). 
- [Pandoc](https://pandoc.org/) est sans doute un des convertisseurs les plus
  puissants (Plain TeX, LaTeX et ConTeXt, mais bien plus encore). Il est _le
  couteau suisse de la création des documents_, une application en ligne de
  commande permettant de convertir un fichier texte balisé depuis les formats
  Markdown, reStructuredText, textile, HTML, DocBook, (La)TeX, etc. vers les
  formats XHTML, HTML5, diaporama HTML Slidy, S5, ou DZSlides, vers les formats
  de traitement de texte Microsoft Word, OpenOffice/LibreOffice, OpenDocument
  XML, les EPUB, les DocBook, GNU TexInfo, Groff man pages etc.

:::{todo} Le précédent paragraphe appelle une révision.
:::

::: {note}
- `TeXpider` était un programme commercial de
  [Micropress](faquk:FAQ-commercial), dont on peut trouver la description sur
  [une version archivée du site web de Micropress](http://web.archive.org/web/20211016235240/http://www.micropress-inc.com/webb/wbstart.htm).
  Il utilisait les images pour afficher les mathématiques.
  La société ayant fermé, il n'est sans doute plus possible de se le procurer.
:::

:::{sources}
- [Conversion from (La)TeX to HTML](faquk:FAQ-LaTeX2HTML)
:::
