from typing import ClassVar, Dict

from typing import overload

class HttpRequestOptions:
    auth_pass: str
    auth_user: str
    extra_headers: Dict[str,str]
    port: int
    timeout_ms: int
    @overload
    def __init__(self, arg0: HttpRequestOptions) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> HttpRequestOptions: ...

class HttpRequestOutput:
    errormsg: str
    http_responsecode: int
    out_headers: Dict[str,str]
    @overload
    def __init__(self, arg0: HttpRequestOutput) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> HttpRequestOutput: ...

class http_errorcode:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BadURL: ClassVar[http_errorcode] = ...
    CouldntConnect: ClassVar[http_errorcode] = ...
    NotFound: ClassVar[http_errorcode] = ...
    Ok: ClassVar[http_errorcode] = ...
    OtherHTTPError: ClassVar[http_errorcode] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

@overload
def DNS_resolve_async(server_name: str, out_ip: str) -> bool: ...
@overload
def DNS_resolve_async(server_name: str, out_ip: str, timeout_ms: int) -> bool: ...
@overload
def DNS_resolve_async(conststd, std, constunsignedint) -> bool: ...
@overload
def Ping(address: str, max_attempts: int) -> bool: ...
@overload
def Ping(address: str, max_attempts: int, output_str: str) -> bool: ...
@overload
def Ping(conststd, constint, std) -> bool: ...
def getLastSocketErrorStr() -> str: ...
