const syllabary = {
    a: 45,
    ai: 189,
    an: 196,
    ang: 42,
    ao: 172,
    ba: 219,
    bai: 173,
    ban: 123,
    bang: 105,
    bao: 231,
    bei: 211,
    ben: 70,
    beng: 112,
    bi: 517,
    bian: 218,
    biao: 113,
    bie: 84,
    bin: 92,
    bing: 176,
    bo: 599,
    bu: 392,
    ca: 21,
    cai: 97,
    can: 220,
    cang: 99,
    cao: 92,
    ce: 61,
    cei: 0,
    cen: 35,
    ceng: 48,
    cha: 179,
    chai: 90,
    chan: 289,
    chang: 477,
    chao: 174,
    che: 133,
    chen: 259,
    cheng: 289,
    chi: 450,
    chong: 281,
    chou: 192,
    chu: 268,
    chua: 14,
    chuai: 23,
    chuan: 105,
    chuang: 91,
    chui: 65,
    chun: 118,
    chuo: 72,
    ci: 198,
    cong: 159,
    cou: 20,
    cu: 120,
    cuan: 67,
    cui: 141,
    cun: 49,
    cuo: 99,
    da: 364,
    dai: 160,
    dan: 300,
    dang: 117,
    dao: 159,
    de: 67,
    dei: 11,
    den: 0,
    deng: 80,
    di: 669,
    dia: 0,
    dian: 222,
    diao: 205,
    die: 155,
    din: 0,
    ding: 108,
    diu: 14,
    dong: 170,
    dou: 141,
    du: 256,
    duan: 62,
    dui: 124,
    dun: 98,
    duo: 216,
    e: 353,
    eh: 1,
    ei: 4,
    en: 28,
    eng: 2,
    er: 139,
    fa: 106,
    fan: 308,
    fang: 111,
    fei: 252,
    fen: 196,
    feng: 232,
    fiao: 0,
    fo: 13,
    fong: 0,
    fou: 22,
    fu: 694,
    ga: 46,
    gai: 124,
    gan: 340,
    gang: 97,
    gao: 203,
    ge: 286,
    gei: 5,
    gen: 27,
    geng: 111,
    gong: 270,
    gou: 156,
    gu: 309,
    gua: 141,
    guai: 54,
    guan: 182,
    guang: 104,
    gui: 319,
    gun: 60,
    guo: 204,
    ha: 19,
    hai: 152,
    han: 333,
    hang: 115,
    hao: 194,
    he: 387,
    hei: 15,
    hen: 31,
    heng: 73,
    hong: 231,
    hou: 129,
    hu: 457,
    hua: 200,
    huai: 51,
    huan: 309,
    huang: 194,
    hui: 388,
    hun: 130,
    huo: 223,
    ji: 1003,
    jia: 285,
    jian: 585,
    jiang: 151,
    jiao: 501,
    jie: 517,
    jin: 320,
    jing: 320,
    jiong: 69,
    jiu: 232,
    ju: 509,
    juan: 175,
    jue: 338,
    jun: 169,
    ka: 55,
    kai: 113,
    kan: 99,
    kang: 84,
    kao: 43,
    ke: 225,
    kei: 0,
    ken: 28,
    keng: 61,
    kong: 74,
    kou: 90,
    ku: 117,
    kua: 46,
    kuai: 94,
    kuan: 27,
    kuang: 105,
    kui: 198,
    kun: 102,
    kuo: 50,
    la: 135,
    lai: 98,
    lan: 173,
    lang: 114,
    lao: 186,
    le: 131,
    lei: 204,
    leng: 59,
    li: 708,
    lia: 2,
    lian: 219,
    liang: 133,
    liao: 220,
    lie: 147,
    lin: 177,
    ling: 256,
    liu: 237,
    lo: 1,
    long: 180,
    lou: 163,
    lu: 428,
    luan: 73,
    lun: 66,
    luo: 232,
    lv: 196,
    lvan: 13,
    lve: 43,
    ma: 151,
    mai: 82,
    man: 155,
    mang: 98,
    mao: 204,
    me: 7,
    mei: 209,
    men: 59,
    meng: 180,
    mi: 273,
    mian: 156,
    miao: 59,
    mie: 65,
    min: 128,
    ming: 108,
    miu: 28,
    mo: 387,
    mou: 70,
    mu: 167,
    na: 138,
    nai: 58,
    nang: 39,
    nao: 127,
    ne: 19,
    nei: 65,
    nen: 28,
    neng: 23,
    ni: 220,
    nia: 2,
    nian: 126,
    niang: 9,
    niao: 63,
    nie: 179,
    nin: 10,
    ning: 79,
    niu: 72,
    nong: 67,
    nou: 35,
    nu: 46,
    nuan: 18,
    nun: 2,
    nuo: 86,
    nv: 41,
    nve: 15,
    o: 19,
    ou: 91,
    pa: 73,
    pai: 60,
    pan: 144,
    pang: 112,
    pao: 99,
    pei: 163,
    pen: 27,
    peng: 158,
    pi: 504,
    pia: 1,
    pian: 105,
    piao: 85,
    pie: 23,
    pin: 96,
    ping: 148,
    po: 170,
    pou: 67,
    pu: 194,
    qi: 727,
    qia: 77,
    qian: 495,
    qiang: 192,
    qiao: 205,
    qie: 134,
    qin: 193,
    qing: 232,
    qiong: 105,
    qiu: 233,
    qu: 321,
    quan: 182,
    que: 141,
    qun: 47,
    ran: 76,
    rang: 34,
    rao: 30,
    re: 31,
    ren: 156,
    reng: 19,
    ri: 46,
    rong: 150,
    rou: 63,
    ru: 159,
    ruan: 69,
    rui: 54,
    run: 16,
    ruo: 39,
    sa: 80,
    sai: 58,
    san: 160,
    sang: 37,
    sao: 80,
    se: 107,
    sei: 0,
    sen: 12,
    seng: 6,
    sha: 154,
    shai: 25,
    shan: 257,
    shang: 101,
    shao: 106,
    she: 168,
    shei: 13,
    shen: 287,
    sheng: 240,
    shi: 548,
    shou: 125,
    shu: 403,
    shua: 14,
    shuai: 55,
    shuan: 24,
    shuang: 68,
    shui: 111,
    shun: 32,
    shuo: 78,
    si: 323,
    song: 109,
    sou: 97,
    su: 308,
    suan: 28,
    sui: 199,
    sun: 49,
    suo: 163,
    ta: 208,
    tai: 123,
    tan: 294,
    tang: 163,
    tao: 171,
    te: 41,
    tei: 0,
    teng: 55,
    ti: 276,
    tian: 285,
    tiao: 229,
    tie: 39,
    ting: 135,
    tong: 208,
    tou: 101,
    tu: 228,
    tuan: 69,
    tui: 112,
    tun: 101,
    tuo: 234,
    wa: 107,
    wai: 56,
    wan: 236,
    wang: 128,
    wei: 519,
    wen: 160,
    weng: 54,
    wo: 134,
    wong: 1,
    wu: 485,
    xi: 823,
    xia: 260,
    xian: 642,
    xiang: 237,
    xiao: 397,
    xie: 455,
    xin: 196,
    xing: 506,
    xiong: 74,
    xiu: 135,
    xu: 368,
    xuan: 298,
    xue: 187,
    xun: 222,
    ya: 213,
    yai: 6,
    yan: 688,
    yang: 236,
    yao: 349,
    ye: 312,
    yi: 1160,
    yin: 419,
    ying: 298,
    yo: 3,
    yong: 177,
    you: 394,
    yu: 844,
    yuan: 290,
    yue: 239,
    yun: 210,
    za: 81,
    zai: 64,
    zan: 82,
    zang: 60,
    zao: 117,
    ze: 133,
    zei: 9,
    zen: 12,
    zeng: 81,
    zha: 260,
    zhai: 112,
    zhan: 260,
    zhang: 157,
    zhao: 269,
    zhe: 245,
    zhei: 1,
    zhen: 286,
    zheng: 183,
    zhi: 804,
    zhong: 334,
    zhou: 204,
    zhu: 411,
    zhua: 41,
    zhuai: 7,
    zhuan: 138,
    zhuang: 97,
    zhui: 79,
    zhun: 38,
    zhuo: 272,
    zi: 332,
    zong: 170,
    zou: 63,
    zu: 130,
    zuan: 43,
    zui: 110,
    zun: 51,
    zuo: 129,
};
const table = [];
let score= 0;
for (syllable in syllabary) {
    score += syllabary[syllable];
    table.push({score, syllable});
}
const len = Number(process.argv[2]);
let t = [];
for (let i = 0; i < len; ++i) {
    const r = Math.floor(Math.random() * score);
    t.push(table.find(({score, syllable}) => score > r).syllable);
}
console.log(t.join(''));
