#!/bin/sh

# This autopkgtest exercises multidelta using the same "interestingness"
# test script as delta.sh, but applied to multiple input files.
#
# multidelta does not expose the same intermediate artifacts as singledelta.
# For a more detailed explanation of the delta debugging process, log
# structure, and rationale behind these tests, see debian/tests/delta.sh.

cd debian/tests/
cp input.txt input2.txt test.sh $AUTOPKGTEST_TMP
cd $AUTOPKGTEST_TMP

multidelta ./test.sh input.txt input2.txt

echo "\nREADING LOG\n"
cat log | grep -C 50 start | grep -B 50 done
