#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Nanotale - Typing Chronicles
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250502.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='nanotale-typing-chronicles'
GAME_NAME='Nanotale - Typing Chronicles'

ARCHIVE_BASE_LINUX_1_NAME='nanotale_typing_chronicles_1_96_51035.sh'
ARCHIVE_BASE_LINUX_1_MD5='fee2152ca68930869172c1bb6785d37d'
ARCHIVE_BASE_LINUX_1_SIZE='5200000'
ARCHIVE_BASE_LINUX_1_VERSION='1.96-gog51035'
ARCHIVE_BASE_LINUX_1_URL='https://www.gog.com/game/nanotale_typing_chronicles'

ARCHIVE_BASE_WINDOWS_1_NAME='setup_nanotale_-_typing_chronicles_1.96_(51033).exe'
ARCHIVE_BASE_WINDOWS_1_MD5='721fec7965771ba863bd29cdab8008b1'
ARCHIVE_BASE_WINDOWS_1_TYPE='innosetup'
ARCHIVE_BASE_WINDOWS_1_PART1_NAME='setup_nanotale_-_typing_chronicles_1.96_(51033)-1.bin'
ARCHIVE_BASE_WINDOWS_1_PART1_MD5='54e817f9e83c456e6e7bef0977cd4a4a'
ARCHIVE_BASE_WINDOWS_1_SIZE='5219492'
ARCHIVE_BASE_WINDOWS_1_VERSION='1.96-gog51033'
ARCHIVE_BASE_WINDOWS_1_URL='https://www.gog.com/game/nanotale_typing_chronicles'

ARCHIVE_BASE_LINUX_0_NAME='nanotale_typing_chronicles_1_95_50826.sh'
ARCHIVE_BASE_LINUX_0_MD5='a77a001896b0c742feddd24ce594bc3e'
ARCHIVE_BASE_LINUX_0_SIZE='4600000'
ARCHIVE_BASE_LINUX_0_VERSION='1.95-gog50826'

UNITY3D_NAME_LINUX='Nanotale'
UNITY3D_NAME_WINDOWS='nanotale'
UNITY3D_PLUGINS='
libfmodstudioL.so
libfmodstudio.so
libresonanceaudio.so
sqlite3.so
UnityFbxSdkNative.so'

CONTENT_PATH_DEFAULT_LINUX='data/noarch/game'
CONTENT_PATH_DEFAULT_WINDOWS='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Fishing Cactus/Nanotale'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_DESCRIPTION_LINUX='Linux build'
PKG_BIN_DESCRIPTION_WINDOWS='Windows build'
PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_LINUX="${PKG_DATA_ID}-linux"
PKG_DATA_ID_WINDOWS="${PKG_DATA_ID}-windows"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DESCRIPTION_LINUX="$PKG_DATA_DESCRIPTION - Linux build"
PKG_DATA_DESCRIPTION_WINDOWS="$PKG_DATA_DESCRIPTION - Windows build"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
