#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Monstrata Fracture
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250521.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='monstrata-fracture'
GAME_NAME='Monstrata Fracture'

ARCHIVE_BASE_3_NAME='monstrata-fracture-win-linux.zip'
ARCHIVE_BASE_3_MD5='b20a1bcf571f96a24681af86eecb21ed'
ARCHIVE_BASE_3_SIZE='734454'
ARCHIVE_BASE_3_VERSION='1.2.23-itch.2023.12.08'
ARCHIVE_BASE_3_URL='https://astralore.itch.io/monstrata-fracture'

ARCHIVE_BASE_2_NAME='monstrata-fracture-win-osx-linux.zip'
ARCHIVE_BASE_2_MD5='77587f9906e97a79163849d74fc77c3b'
ARCHIVE_BASE_2_SIZE='797917'
ARCHIVE_BASE_2_VERSION='1.2.23-itch.2023.12.08'
ARCHIVE_BASE_2_URL='https://astralore.itch.io/monstrata-fracture'

ARCHIVE_BASE_1_NAME='monstrata-fracture-win-linux.zip'
ARCHIVE_BASE_1_MD5='9839d978298251f296febd5bc9a9b550'
ARCHIVE_BASE_1_SIZE='240017'
ARCHIVE_BASE_1_VERSION='1.2.11-itch1'

ARCHIVE_BASE_0_NAME='monstrata-fracture-win-osx-linux.zip'
ARCHIVE_BASE_0_MD5='7fa34744e2ff3ad7b745909ebfea51fc'
ARCHIVE_BASE_0_SIZE='270000'
ARCHIVE_BASE_0_VERSION='1.2.11-itch1'

CONTENT_PATH_DEFAULT_3='Monstrata-1.2.23-pc/game'
CONTENT_PATH_DEFAULT_2='game'
CONTENT_PATH_DEFAULT_1='Monstrata-1.2.11-pc/game'
CONTENT_PATH_DEFAULT_0='Monstrata-1.2.11-market/game'
CONTENT_GAME_MAIN_FILES='
audio
cache
shaders
sounds
script_version.txt
*.rpa'
CONTENT_DOC_DATA_RELATIVE_PATH='..'
CONTENT_DOC_DATA_FILES='
credits.txt'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from pre-20250514.1 packages.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
monstrata-fracture-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

## Use the default Ren'Py icon.
desktop_field_icon() { printf 'renpy'; }

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
